/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.util.CodecUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;

public class TileTextures
extends SimplePreparableReloadListener<Map<ResourceLocation, TileTextureMeta>>
implements IdentifiableResourceReloadListener {
    public static final TileTextures INSTANCE = new TileTextures();
    public static final ResourceLocation ID = AntiqueAtlas.id("tile_textures");
    protected final Map<ResourceLocation, TileTexture> textures = new HashMap<ResourceLocation, TileTexture>();

    public static TileTextures getInstance() {
        return INSTANCE;
    }

    public Map<ResourceLocation, TileTexture> getTextures() {
        return this.textures;
    }

    protected Map<ResourceLocation, TileTextureMeta> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, TileTextureMeta> textureMeta = new HashMap<ResourceLocation, TileTextureMeta>();
        for (Map.Entry e : manager.m_214159_("textures/atlas/tile", id -> id.m_135815_().endsWith(".png")).entrySet()) {
            ResourceLocation id2 = ResourceLocation.m_214293_((String)((ResourceLocation)e.getKey()).m_135827_(), (String)((ResourceLocation)e.getKey()).m_135815_().substring("textures/atlas/tile/".length(), ((ResourceLocation)e.getKey()).m_135815_().length() - ".png".length()));
            try {
                ResourceMetadata metadata = ((Resource)e.getValue()).m_215509_();
                metadata.m_214059_(TileTextureMeta.METADATA).ifPresentOrElse(meta -> textureMeta.put(id2, (TileTextureMeta)meta), () -> {
                    AntiqueAtlas.LOGGER.info("[Antique Atlas] Metadata not present for {} - using defaults.", e.getKey());
                    textureMeta.put(id2, TileTextureMeta.DEFAULT);
                });
            }
            catch (IOException ex) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Failed to access tile texture metadata for {}", e.getKey(), (Object)ex);
                textureMeta.put(id2, TileTextureMeta.DEFAULT);
            }
        }
        return textureMeta;
    }

    protected void apply(Map<ResourceLocation, TileTextureMeta> prepared, ResourceManager manager, ProfilerFiller profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Tile Textures...");
        prepared.forEach((id, meta) -> meta.warnMissing((ResourceLocation)id, prepared.keySet()));
        HashMap invalidParents = new HashMap();
        prepared.forEach((id, meta) -> {
            if (meta.parent != null && !prepared.containsKey(meta.parent)) {
                invalidParents.put(id, meta.parent);
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Failed to reload a tile texture! {} had invalid parent {}", id, (Object)meta.parent);
            }
        });
        invalidParents.keySet().forEach(prepared::remove);
        prepared.forEach((id, meta) -> {
            Optional<TileTextureMeta> parent = meta.parent().map(prepared::get);
            while (parent.isPresent()) {
                meta.inheritFromAncestor(parent.orElseThrow());
                parent = parent.orElseThrow().parent().map(prepared::get);
            }
        });
        HashMap textureTags = new HashMap();
        prepared.forEach((id, meta) -> meta.tags.forEach(tag -> textureTags.computeIfAbsent(tag, t -> new HashSet()).add(id)));
        prepared.forEach((id, meta) -> meta.substituteTags((ResourceLocation)id, textureTags));
        prepared.forEach((id, meta) -> meta.applyTilesToThis((ResourceLocation)id, prepared));
        HashMap<ResourceLocation, TileTexture.Builder> textureBuilders = new HashMap<ResourceLocation, TileTexture.Builder>();
        prepared.forEach((id, meta) -> textureBuilders.put((ResourceLocation)id, meta.toBuilder((ResourceLocation)id)));
        this.textures.clear();
        textureBuilders.forEach((id, builder) -> this.textures.put((ResourceLocation)id, TileTexture.empty(id, builder.innerBorder())));
        textureBuilders.forEach((id, builder) -> builder.build(this.textures));
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public static class TileTextureMeta {
        public static final TileTextureMeta DEFAULT = new TileTextureMeta(null, null, Set.of(), Set.of(), Set.of(), Set.of(), Set.of(), Set.of(), Set.of());
        public static final Codec<TileTextureMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("parent").forGetter(TileTextureMeta::parent), (App)CodecUtil.ofEnum(BorderType.class).optionalFieldOf("borderType").forGetter(TileTextureMeta::borderType), (App)CodecUtil.set(ResourceLocation.f_135803_).fieldOf("tags").orElseGet(HashSet::new).forGetter(TileTextureMeta::tags), (App)CodecUtil.set(ExtraCodecs.f_216161_).fieldOf("tilesTo").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesTo), (App)CodecUtil.set(ExtraCodecs.f_216161_).fieldOf("tilesToHorizontal").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToHorizontal), (App)CodecUtil.set(ExtraCodecs.f_216161_).fieldOf("tilesToVertical").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToVertical), (App)CodecUtil.set(ExtraCodecs.f_216161_).fieldOf("tilesToThis").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToThis), (App)CodecUtil.set(ExtraCodecs.f_216161_).fieldOf("tilesToThisHorizontal").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToThisHorizontal), (App)CodecUtil.set(ExtraCodecs.f_216161_).fieldOf("tilesToThisVertical").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToThisVertical)).apply((Applicative)instance, (p, b, t, tt, tth, ttv, ttt, ttth, tttv) -> new TileTextureMeta(p.orElse(null), b.orElse(null), (Set<ResourceLocation>)t, (Set<ExtraCodecs.TagOrElementLocation>)tt, (Set<ExtraCodecs.TagOrElementLocation>)tth, (Set<ExtraCodecs.TagOrElementLocation>)ttv, (Set<ExtraCodecs.TagOrElementLocation>)ttt, (Set<ExtraCodecs.TagOrElementLocation>)ttth, (Set<ExtraCodecs.TagOrElementLocation>)tttv)));
        public static final MetadataSectionSerializer<TileTextureMeta> METADATA = new CodecUtil.CodecResourceMetadataSerializer<TileTextureMeta>(CODEC, AntiqueAtlas.id("tiling"));
        protected final ResourceLocation parent;
        protected BorderType borderType;
        protected final Set<ResourceLocation> tags;
        protected final Set<ExtraCodecs.TagOrElementLocation> tilesTo;
        protected final Set<ExtraCodecs.TagOrElementLocation> tilesToHorizontal;
        protected final Set<ExtraCodecs.TagOrElementLocation> tilesToVertical;
        protected final Set<ExtraCodecs.TagOrElementLocation> tilesToThis;
        protected final Set<ExtraCodecs.TagOrElementLocation> tilesToThisHorizontal;
        protected final Set<ExtraCodecs.TagOrElementLocation> tilesToThisVertical;

        public TileTextureMeta(ResourceLocation parent, BorderType borderType, Set<ResourceLocation> tags, Set<ExtraCodecs.TagOrElementLocation> tilesTo, Set<ExtraCodecs.TagOrElementLocation> tilesToHorizontal, Set<ExtraCodecs.TagOrElementLocation> tilesToVertical, Set<ExtraCodecs.TagOrElementLocation> tilesToThis, Set<ExtraCodecs.TagOrElementLocation> tilesToThisHorizontal, Set<ExtraCodecs.TagOrElementLocation> tilesToThisVertical) {
            this.parent = parent;
            this.borderType = borderType;
            this.tags = tags;
            this.tilesTo = tilesTo;
            this.tilesToHorizontal = tilesToHorizontal;
            this.tilesToVertical = tilesToVertical;
            this.tilesToThis = tilesToThis;
            this.tilesToThisHorizontal = tilesToThisHorizontal;
            this.tilesToThisVertical = tilesToThisVertical;
        }

        public void warnMissing(ResourceLocation thisId, Set<ResourceLocation> identifiers) {
            for (Set<ExtraCodecs.TagOrElementLocation> entrySet : List.of(this.tilesTo, this.tilesToHorizontal, this.tilesToVertical, this.tilesToThis, this.tilesToThisHorizontal, this.tilesToThisVertical)) {
                for (ExtraCodecs.TagOrElementLocation entry : entrySet) {
                    if (entry.f_216196_() || identifiers.contains(entry.f_216195_())) continue;
                    AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing!", (Object)thisId, (Object)entry.f_216195_());
                }
            }
        }

        void inheritFromAncestor(TileTextureMeta other) {
            if (other.borderType().isPresent()) {
                this.borderType = other.borderType;
            }
            this.tags.addAll(other.tags);
            this.tilesTo.addAll(other.tilesTo);
            this.tilesToHorizontal.addAll(other.tilesToHorizontal);
            this.tilesToVertical.addAll(other.tilesToVertical);
            this.tilesToThis.addAll(other.tilesToThis);
            this.tilesToThisHorizontal.addAll(other.tilesToThisHorizontal);
            this.tilesToThisVertical.addAll(other.tilesToThisVertical);
        }

        void substituteTags(ResourceLocation thisId, Map<ResourceLocation, Set<ResourceLocation>> tags) {
            for (Set<ExtraCodecs.TagOrElementLocation> entrySet : List.of(this.tilesTo, this.tilesToHorizontal, this.tilesToVertical, this.tilesToThis, this.tilesToThisHorizontal, this.tilesToThisVertical)) {
                HashSet<ExtraCodecs.TagOrElementLocation> entryTags = new HashSet<ExtraCodecs.TagOrElementLocation>();
                for (ExtraCodecs.TagOrElementLocation entry : entrySet) {
                    if (!entry.f_216196_()) continue;
                    entryTags.add(entry);
                }
                if (!entryTags.isEmpty()) {
                    entrySet.removeAll(entryTags);
                }
                for (ExtraCodecs.TagOrElementLocation entry : entryTags) {
                    Set resolvedIds = tags.getOrDefault(entry.f_216195_(), Set.of());
                    if (resolvedIds.isEmpty()) {
                        AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references tag {}, which is empty", (Object)thisId, (Object)entry.f_216195_());
                        continue;
                    }
                    entrySet.addAll(resolvedIds.stream().map(id -> new ExtraCodecs.TagOrElementLocation(id, false)).toList());
                }
            }
        }

        void applyTilesToThis(ResourceLocation thisId, Map<ResourceLocation, TileTextureMeta> map) {
            for (ExtraCodecs.TagOrElementLocation entryId : this.tilesToThis) {
                if (entryId.f_216196_()) {
                    throw new IllegalStateException("tags must be resolved to apply tilesToThis!");
                }
                if (map.containsKey(entryId.f_216195_())) {
                    map.get((Object)entryId.f_216195_()).tilesTo.add(new ExtraCodecs.TagOrElementLocation(thisId, false));
                    continue;
                }
                AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing", (Object)thisId, (Object)entryId.f_216195_());
            }
            for (ExtraCodecs.TagOrElementLocation entryId : this.tilesToThisHorizontal) {
                if (entryId.f_216196_()) {
                    throw new IllegalStateException("tags must be resolved to apply tilesToThis!");
                }
                if (map.containsKey(entryId.f_216195_())) {
                    map.get((Object)entryId.f_216195_()).tilesToHorizontal.add(new ExtraCodecs.TagOrElementLocation(thisId, false));
                    continue;
                }
                AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing", (Object)thisId, (Object)entryId.f_216195_());
            }
            for (ExtraCodecs.TagOrElementLocation entryId : this.tilesToThisVertical) {
                if (entryId.f_216196_()) {
                    throw new IllegalStateException("tags must be resolved to apply tilesToThis!");
                }
                if (map.containsKey(entryId.f_216195_())) {
                    map.get((Object)entryId.f_216195_()).tilesToVertical.add(new ExtraCodecs.TagOrElementLocation(thisId, false));
                    continue;
                }
                AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing", (Object)thisId, (Object)entryId.f_216195_());
            }
        }

        public TileTexture.Builder toBuilder(ResourceLocation thisId) {
            return new TileTexture.Builder(thisId, this.borderType().orElse(BorderType.OUTER) == BorderType.INNER, this.tilesTo.stream().map(ExtraCodecs.TagOrElementLocation::f_216195_).collect(Collectors.toSet()), this.tilesToHorizontal.stream().map(ExtraCodecs.TagOrElementLocation::f_216195_).collect(Collectors.toSet()), this.tilesToVertical.stream().map(ExtraCodecs.TagOrElementLocation::f_216195_).collect(Collectors.toSet()));
        }

        public Optional<ResourceLocation> parent() {
            return Optional.ofNullable(this.parent);
        }

        public Optional<BorderType> borderType() {
            return Optional.ofNullable(this.borderType);
        }

        public Set<ResourceLocation> tags() {
            return this.tags;
        }

        public Set<ExtraCodecs.TagOrElementLocation> tilesTo() {
            return this.tilesTo;
        }

        public Set<ExtraCodecs.TagOrElementLocation> tilesToHorizontal() {
            return this.tilesToHorizontal;
        }

        public Set<ExtraCodecs.TagOrElementLocation> tilesToVertical() {
            return this.tilesToVertical;
        }

        public Set<ExtraCodecs.TagOrElementLocation> tilesToThis() {
            return this.tilesToThis;
        }

        public Set<ExtraCodecs.TagOrElementLocation> tilesToThisHorizontal() {
            return this.tilesToThisHorizontal;
        }

        public Set<ExtraCodecs.TagOrElementLocation> tilesToThisVertical() {
            return this.tilesToThisVertical;
        }

        public static enum BorderType {
            OUTER,
            INNER;

        }
    }
}

