/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.gui.core.ToggleButtonComponent;
import folk.sisby.antique_atlas.util.ColorUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BookmarkButton
extends ToggleButtonComponent {
    public static final ResourceLocation TEXTURE_LEFT = AntiqueAtlas.id("textures/gui/bookmark_left.png");
    public static final ResourceLocation TEXTURE_RIGHT = AntiqueAtlas.id("textures/gui/bookmark_right.png");
    public static final int WIDTH = 24;
    public static final int HEIGHT = 18;
    protected Component title;
    protected ResourceLocation iconTexture;
    protected final float[] backgroundTint;
    protected final float[] iconTint;
    protected final int iconWidth;
    protected final int iconHeight;
    protected final boolean left;
    protected final ResourceLocation backgroundTexture;

    public BookmarkButton(ResourceLocation backgroundTexture, Component title, ResourceLocation iconTexture, @Nullable Integer backgroundTint, @Nullable Integer iconTint, int iconWidth, int iconHeight, boolean left) {
        super(false);
        this.backgroundTexture = backgroundTexture;
        this.title = title;
        this.iconTexture = iconTexture;
        this.backgroundTint = backgroundTint == null ? null : ColorUtil.componentsFromRgb(backgroundTint);
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.iconTint = iconTint == null ? null : ColorUtil.componentsFromRgb(iconTint);
        this.left = left;
        this.setTitle(title);
        this.setSize(24, 18);
    }

    public BookmarkButton(Component title, ResourceLocation iconTexture, @Nullable Integer backgroundTint, @Nullable Integer iconTint, int iconWidth, int iconHeight, boolean left) {
        this(left ? TEXTURE_LEFT : TEXTURE_RIGHT, title, iconTexture, backgroundTint, iconTint, iconWidth, iconHeight, left);
    }

    public void setIconTexture(ResourceLocation iconTexture) {
        this.iconTexture = iconTexture;
    }

    public Component m_96636_() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public void drawIcon(GuiGraphics context, int x, int y) {
        if (this.iconTint != null) {
            RenderSystem.setShaderColor((float)this.iconTint[0], (float)this.iconTint[1], (float)this.iconTint[2], (float)1.0f);
        }
        context.m_280163_(this.iconTexture, x, y, 0.0f, 0.0f, this.iconWidth, this.iconHeight, this.iconWidth, this.iconHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        boolean mouseOver = this.m_5953_(mouseX, mouseY);
        boolean isExtended = mouseOver || this.isSelected();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.backgroundTint != null) {
            RenderSystem.setShaderColor((float)this.backgroundTint[0], (float)this.backgroundTint[1], (float)this.backgroundTint[2], (float)1.0f);
        }
        context.m_280163_(this.backgroundTexture, this.getGuiX(), this.getGuiY(), 0.0f, isExtended ? 0.0f : 18.0f, 24, 18, 24, 36);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.iconTexture != null) {
            int iconX = this.getGuiX() + 10 - this.iconWidth / 2 + (isExtended ? (this.left ? 3 : 1) : (this.left ? 4 : 0));
            int iconY = this.getGuiY() + 9 - this.iconHeight / 2;
            this.drawIcon(context, iconX, iconY);
        }
        this.renderTooltip(context, mouseX, mouseY, partialTick, mouseOver);
    }

    public void renderTooltip(GuiGraphics context, int mouseX, int mouseY, float partialTick, boolean mouseOver) {
        if (mouseOver && !this.title.getString().isEmpty()) {
            context.m_280557_(this.f_96547_, this.title, mouseX, mouseY);
        }
    }
}

