/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasKeybindings;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.AtlasOverlay;
import folk.sisby.antique_atlas.gui.AtlasRenderer;
import folk.sisby.antique_atlas.gui.BlinkingMarkerComponent;
import folk.sisby.antique_atlas.gui.BookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerBookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerModal;
import folk.sisby.antique_atlas.gui.TextBookmarkButton;
import folk.sisby.antique_atlas.gui.core.ButtonComponent;
import folk.sisby.antique_atlas.gui.core.Component;
import folk.sisby.antique_atlas.gui.core.CursorComponent;
import folk.sisby.antique_atlas.gui.core.ScreenState;
import folk.sisby.antique_atlas.gui.core.ScrollBoxComponent;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.util.RegionPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector2d;

public class AtlasScreen
extends Component
implements AtlasRenderer {
    public final int bookWidth;
    public final int bookHeight;
    public final int mapWidth;
    public final int mapHeight;
    public static double mapOffsetX;
    public static double mapOffsetY;
    public static int tilePixels;
    public static int tileChunks;
    public int mapScale;
    public Player player;
    public WorldAtlasData worldAtlasData;
    public final BookmarkButton addMarkerBookmark;
    public final BookmarkButton deleteMarkerBookmark;
    public final BookmarkButton markerVisibilityBookmark;
    public final TextBookmarkButton resetScaleBookmark;
    public final BookmarkButton playerBookmark;
    public final ScrollBoxComponent markerScrollBox = new ScrollBoxComponent(true, 20);
    public final MarkerModal markerModal = new MarkerModal();
    public final BlinkingMarkerComponent markerCursor = new BlinkingMarkerComponent();
    public final CursorComponent eraser = new CursorComponent();
    public final List<BookmarkButton> markerBookmarks = new ArrayList<BookmarkButton>();
    public final ScreenState<AtlasScreen> state = new ScreenState((oldState, newState) -> AntiqueAtlas.lastState.switchTo((ScreenState.State<AtlasScreen>)newState, this));
    public Landmark hoveredLandmark = null;
    public PlayerSummary hoveredFriend = null;
    public ButtonComponent selectedButton = null;
    public Integer targetOffsetX;
    public Integer targetOffsetY;
    public boolean isMouseOverMap = false;
    public boolean isDragging = false;
    public final boolean fullscreen;
    protected int sideButtonY = 14;

    public AtlasScreen() {
        this.fullscreen = AntiqueAtlas.CONFIG.fullscreen;
        if (this.fullscreen) {
            this.bookWidth = (int)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.9 - 40.0);
            this.bookHeight = (int)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.9);
        } else {
            this.bookWidth = 310;
            this.bookHeight = 218;
        }
        this.setSize(this.bookWidth, this.bookHeight);
        this.mapWidth = this.bookWidth - 34;
        this.mapHeight = this.bookHeight - 22;
        this.mapScale = this.calculateMapScale();
        this.playerBookmark = new BookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.followPlayer"), AntiqueAtlas.id("textures/gui/player.png"), DyeColor.GRAY.m_41070_(), null, 7, 8, false);
        this.addChild(this.playerBookmark).offsetGuiCoords(this.bookWidth - 10, this.bookHeight - 11 - 18 - 10);
        this.playerBookmark.addListener(b -> {
            this.selectedButton = this.playerBookmark;
            this.clearTargetBookmarks(this.playerBookmark);
            this.playerBookmark.setSelected(true);
        });
        this.addMarkerBookmark = new BookmarkButton(TEXT_ADD_MARKER, ICON_ADD_MARKER, DyeColor.RED.m_41070_(), null, 16, 16, false);
        this.addChild(this.addMarkerBookmark);
        this.offsetSideButton(this.addMarkerBookmark);
        this.addMarkerBookmark.addListener(button -> {
            if (this.state.is(PLACING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = button;
                this.state.switchTo(PLACING_MARKER, this);
                if (AtlasScreen.m_96638_()) {
                    this.markerModal.setMarkerData(this.player.m_20193_(), Landmark.create((UUID)SurveyorClient.getClientUuid(), (ResourceLocation)AntiqueAtlas.id("newmarker"), b -> b.add(LandmarkComponentTypes.POS, (Object)this.player.m_20183_())));
                    this.addChild(this.markerModal);
                    this.markerCursor.setTexture(this.markerModal.selectedTexture.id(), this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight());
                    this.addChildBehind(this.markerModal, this.markerCursor).setGuiCoords((int)this.worldXToScreenX((double)this.player.m_146903_() - 16.0), (int)this.worldZToScreenY((double)this.player.m_146907_() - 16.0));
                    KeyMapping.m_90847_();
                    this.selectedButton = null;
                    this.state.switchTo(NORMAL, this);
                }
            }
        });
        this.deleteMarkerBookmark = new BookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.delMarker"), ICON_DELETE_MARKER, DyeColor.YELLOW.m_41070_(), null, 16, 16, false);
        this.addChild(this.deleteMarkerBookmark);
        this.offsetSideButton(this.deleteMarkerBookmark);
        this.deleteMarkerBookmark.addListener(button -> {
            if (this.state.is(DELETING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = button;
                this.state.switchTo(DELETING_MARKER, this);
            }
        });
        this.markerVisibilityBookmark = new BookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.hideMarkers"), ICON_HIDE_MARKERS, DyeColor.GREEN.m_41070_(), null, 16, 16, false);
        this.addChild(this.markerVisibilityBookmark);
        this.offsetSideButton(this.markerVisibilityBookmark);
        this.markerVisibilityBookmark.addListener(button -> {
            this.selectedButton = null;
            if (this.state.is(HIDING_MARKERS)) {
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = null;
                this.state.switchTo(HIDING_MARKERS, this);
            }
        });
        this.resetScaleBookmark = new TextBookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.resetScale"), net.minecraft.network.chat.Component.m_130674_((String)"1c"));
        this.addChild(this.resetScaleBookmark);
        this.offsetSideButton(this.resetScaleBookmark);
        this.resetScaleBookmark.addListener(button -> {
            this.resetZoom();
            this.resetScaleBookmark.setSelected(false);
        });
        this.addChild(this.markerScrollBox).setRelativeCoords(-14, 19);
        int markersOnScreen = (this.mapHeight - 20) / 18;
        this.markerScrollBox.getViewport().setSize(24, markersOnScreen * 20 - 2);
        this.markerModal.addMarkerListener(this.markerCursor);
        this.eraser.setTexture(ERASER, 12, 14, 2, 11);
        this.state.switchTo(AntiqueAtlas.lastState.is(HIDING_MARKERS) ? HIDING_MARKERS : NORMAL, this);
        for (ResourceLocation id : overlays.keySet()) {
            ((AtlasOverlay)overlays.get(id)).onScreenInit(this);
        }
    }

    public int calculateMapScale() {
        return switch (AntiqueAtlas.CONFIG.mapScale) {
            case -2 -> Math.max(1, (int)Math.floor(this.guiScale() / 2.0));
            case -1 -> Math.max(1, (int)Math.ceil(this.guiScale() / 2.0));
            case 0 -> (int)this.guiScale();
            default -> AntiqueAtlas.CONFIG.mapScale;
        };
    }

    public void prepareToOpen() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        this.player = Minecraft.m_91087_().f_91074_;
        this.updateAtlasData();
        if (!AntiqueAtlas.CONFIG.keepOffset) {
            this.playerBookmark.setSelected(true);
            this.setMapPosition(this.player.m_146903_(), this.player.m_146907_());
        }
        if (!AntiqueAtlas.CONFIG.keepZoom) {
            this.resetZoom();
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.setGuiCoords((this.f_96543_ - this.bookWidth) / 2, (this.f_96544_ - this.bookHeight) / 2);
        this.updateScaleBookmark();
        this.updateBookmarkerList();
    }

    public void updateBookmarkerList() {
        this.markerScrollBox.getViewport().removeAllContent();
        this.markerScrollBox.setScrollPos(0);
        this.markerBookmarks.clear();
        if (this.worldAtlasData == null) {
            return;
        }
        this.worldAtlasData.getEditableLandmarks(this.player.m_20193_()).forEach((landmark, texture) -> {
            MarkerBookmarkButton bookmark = new MarkerBookmarkButton((net.minecraft.network.chat.Component)landmark.getOrDefault(LandmarkComponentTypes.NAME, (Object)net.minecraft.network.chat.Component.m_237113_((String)landmark.id().m_135815_())), (MarkerTexture)texture, (Integer)landmark.getOrDefault(LandmarkComponentTypes.COLOR, (Object)0xFFFFFF), true);
            bookmark.addListener(button -> {
                if (this.state.is(NORMAL)) {
                    this.clearTargetBookmarks(bookmark);
                    this.setTargetPosition(new ColumnPos(((BlockPos)landmark.getOrDefault(LandmarkComponentTypes.POS, (Object)BlockPos.f_121853_)).m_123341_(), ((BlockPos)landmark.getOrDefault(LandmarkComponentTypes.POS, (Object)BlockPos.f_121853_)).m_123343_()));
                } else if (this.state.is(DELETING_MARKER)) {
                    if (!this.worldAtlasData.deleteLandmark(this.player.m_20193_(), (Landmark)landmark)) {
                        return;
                    }
                    this.updateBookmarkerList();
                    this.player.m_20193_().m_5594_(this.player, this.player.m_20183_(), SoundEvents.f_12493_, SoundSource.AMBIENT, 1.0f, 0.5f);
                    if (!AtlasScreen.m_96638_()) {
                        this.state.switchTo(NORMAL, this);
                    }
                }
            });
            this.markerBookmarks.add(bookmark);
        });
        int[] contentY = new int[]{0};
        for (BookmarkButton bookmark : this.markerBookmarks) {
            this.markerScrollBox.getViewport().addContent(bookmark).setRelativeY(contentY[0]);
            contentY[0] = contentY[0] + 20;
        }
    }

    public void clearTargetBookmarks(BookmarkButton except) {
        if (this.playerBookmark != except) {
            this.playerBookmark.setSelected(false);
        }
        for (BookmarkButton bookmark : this.markerBookmarks) {
            if (bookmark == except) continue;
            bookmark.setSelected(false);
        }
    }

    public void updateMouse(double mouseX, double mouseY) {
        double relativeMouseX = mouseX - (double)this.getGuiX();
        double relativeMouseY = mouseY - (double)this.getGuiY();
        this.isMouseOverMap = relativeMouseX >= 17.0 && relativeMouseX <= (double)(17 + this.mapWidth) && relativeMouseY >= 11.0 && relativeMouseY <= (double)(11 + this.mapHeight);
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this.updateMouse(mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseState) {
        this.updateMouse(mouseX, mouseY);
        if (this.markerModal.getParent() != null) {
            return this.markerModal.m_6375_(mouseX, mouseY, mouseState);
        }
        if (super.m_6375_(mouseX, mouseY, mouseState)) {
            return true;
        }
        if (this.state.is(NORMAL) && this.hoveredLandmark != null && this.hoveredLandmark.contains(LandmarkComponentTypes.POS) && WorldLandmarks.canModify((UUID)this.hoveredLandmark.owner(), (Level)this.player.m_20193_(), null) && mouseState == 1) {
            this.markerModal.setMarkerData(this.player.m_20193_(), this.hoveredLandmark);
            this.addChild(this.markerModal);
            this.markerCursor.setTexture(this.markerModal.selectedTexture.id(), 32, 32);
            this.addChildBehind(this.markerModal, this.markerCursor).setGuiCoords((int)mouseX - 16, (int)mouseY - 16);
            KeyMapping.m_90847_();
            this.state.switchTo(NORMAL, this);
            return true;
        }
        if (!this.state.is(NORMAL) && !this.state.is(HIDING_MARKERS)) {
            if (this.state.is(PLACING_MARKER) && this.isMouseOverMap && mouseState == 0) {
                this.markerModal.setMarkerData(this.player.m_20193_(), Landmark.create((UUID)SurveyorClient.getClientUuid(), (ResourceLocation)AntiqueAtlas.id("newmarker"), b -> b.add(LandmarkComponentTypes.POS, (Object)new BlockPos(this.screenXToWorldX(mouseX), 0, this.screenYToWorldZ(mouseY)))));
                this.addChild(this.markerModal);
                this.markerCursor.setTexture(this.markerModal.selectedTexture.id(), 32, 32);
                this.addChildBehind(this.markerModal, this.markerCursor).setGuiCoords((int)mouseX - 16, (int)mouseY - 16);
                KeyMapping.m_90847_();
                this.state.switchTo(NORMAL, this);
                return true;
            }
            if (this.state.is(DELETING_MARKER) && this.hoveredLandmark != null && this.isMouseOverMap && mouseState == 0 && this.worldAtlasData.deleteLandmark(this.player.m_20193_(), this.hoveredLandmark)) {
                this.updateBookmarkerList();
                this.player.m_20193_().m_5594_(this.player, this.player.m_20183_(), SoundEvents.f_12493_, SoundSource.AMBIENT, 1.0f, 0.5f);
            }
            if (!AtlasScreen.m_96638_() || !this.state.is(DELETING_MARKER)) {
                this.state.switchTo(NORMAL, this);
            }
        } else if (this.isMouseOverMap && this.selectedButton == null) {
            this.isDragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.navigateMap(0, 24);
        } else if (keyCode == 264) {
            this.navigateMap(0, -24);
        } else if (keyCode == 263) {
            this.navigateMap(24, 0);
        } else if (keyCode == 262) {
            this.navigateMap(-24, 0);
        } else if (keyCode == 61 || keyCode == 334) {
            this.zoomIn(true, 16 << AntiqueAtlas.CONFIG.maxTilePixels);
        } else if (keyCode == 45 || keyCode == 333) {
            this.zoomOut(true, 1 << AntiqueAtlas.CONFIG.maxTileChunks);
        } else if (keyCode == 256 || AntiqueAtlasKeybindings.ATLAS_KEYMAPPING.m_90832_(keyCode, scanCode) && this.markerModal.getParent() == null) {
            this.m_7379_();
        } else {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return true;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double wheelMove) {
        this.updateMouse(mouseX, mouseY);
        if (super.m_6050_(mouseX, mouseY, wheelMove)) {
            return true;
        }
        if (this.markerModal.getParent() == null && wheelMove != 0.0) {
            int direction;
            int n = direction = wheelMove > 0.0 ? 1 : -1;
            if ((wheelMove > 0.0 ? this.zoomIn(true, 16 << AntiqueAtlas.CONFIG.maxTilePixels) : this.zoomOut(true, 1 << AntiqueAtlas.CONFIG.maxTileChunks)) && (this.isMouseOverMap || this.isDragging)) {
                double xOffset = ((double)(this.getGuiX() + 17) + (double)this.mapWidth / 2.0 - mouseX) * (double)direction;
                double yOffset = ((double)(this.getGuiY() + 11) + (double)this.mapHeight / 2.0 - mouseY) * (double)direction;
                if (Math.abs(xOffset) > 5.0 || Math.abs(yOffset) > 5.0) {
                    mapOffsetX += xOffset / (direction < 0 ? 2.0 : 1.0);
                    mapOffsetY += yOffset / (direction < 0 ? 2.0 : 1.0);
                    this.clearTargetBookmarks(null);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseState) {
        boolean result = false;
        if (mouseState != -1) {
            result = this.selectedButton != null || this.isDragging;
            this.selectedButton = null;
            this.isDragging = false;
        }
        return super.m_6348_(mouseX, mouseY, mouseState) || result;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int lastMouseButton, double deltaX, double deltaY) {
        boolean result = false;
        if (this.isDragging) {
            this.clearTargetBookmarks(null);
            mapOffsetX += deltaX;
            mapOffsetY += deltaY;
            result = true;
        }
        return super.m_7979_(mouseX, mouseY, lastMouseButton, deltaX, deltaY) || result;
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.player == null) {
            return;
        }
        if (this.playerBookmark.isSelected() && (mapOffsetX != (double)(-this.player.m_146903_()) * this.getPixelsPerBlock() || mapOffsetY != (double)(-this.player.m_146907_()) * this.getPixelsPerBlock())) {
            this.setTargetPosition(new ColumnPos(this.player.m_146903_(), this.player.m_146907_()));
        }
        if (this.targetOffsetX != null) {
            if (Math.abs(this.getTargetPositionX() - mapOffsetX) > 24.0) {
                this.softNavigateMap(this.getTargetPositionX() > mapOffsetX ? 24 : -24, 0);
            } else {
                mapOffsetX = this.getTargetPositionX();
                this.targetOffsetX = null;
            }
        }
        if (this.targetOffsetY != null) {
            if (Math.abs(this.getTargetPositionY() - mapOffsetY) > 24.0) {
                this.softNavigateMap(0, this.getTargetPositionY() > mapOffsetY ? 24 : -24);
            } else {
                mapOffsetY = this.getTargetPositionY();
                this.targetOffsetY = null;
            }
        }
    }

    public void updateAtlasData() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            this.worldAtlasData = WorldAtlasData.getOrCreate((Level)Minecraft.m_91087_().f_91073_);
        }
    }

    public void navigateMap(int dx, int dy) {
        mapOffsetX += (double)dx;
        mapOffsetY += (double)dy;
        this.clearTargetBookmarks(null);
    }

    public void softNavigateMap(int dx, int dy) {
        mapOffsetX += (double)dx;
        mapOffsetY += (double)dy;
    }

    public void setMapPosition(int x, int z) {
        mapOffsetX = (int)((double)(-x) * this.getPixelsPerBlock());
        mapOffsetY = (int)((double)(-z) * this.getPixelsPerBlock());
    }

    public void setTargetPosition(ColumnPos pos) {
        this.targetOffsetX = pos.f_140723_();
        this.targetOffsetY = pos.f_140724_();
    }

    public double getTargetPositionX() {
        return (double)(-this.targetOffsetX.intValue()) * this.getPixelsPerBlock();
    }

    public double getTargetPositionY() {
        return (double)(-this.targetOffsetY.intValue()) * this.getPixelsPerBlock();
    }

    public void updateScaleBookmark() {
        int tileSizeBlocks = tileChunks * 16 * 16 / tilePixels;
        int defaultTileSizeBlocks = 16;
        int rulerSizeBlocks = (int)((float)tileSizeBlocks / this.getEffectiveScale());
        this.resetScaleBookmark.setLabel((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)(rulerSizeBlocks == 16 | rulerSizeBlocks >= 32 ? "%dc".formatted(rulerSizeBlocks / 16) : "%db".formatted(rulerSizeBlocks))).m_130940_(tileSizeBlocks < defaultTileSizeBlocks ? ChatFormatting.DARK_RED : (tileSizeBlocks == defaultTileSizeBlocks ? ChatFormatting.BLACK : ChatFormatting.DARK_BLUE)));
    }

    public boolean zoomIn(boolean playSound, int maxTilePixels) {
        if (tileChunks == 1) {
            if (tilePixels >= maxTilePixels) {
                return false;
            }
            tilePixels <<= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_144231_, (float)1.0f));
            }
        } else {
            tileChunks >>= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
        }
        mapOffsetX *= 2.0;
        mapOffsetY *= 2.0;
        this.updateScaleBookmark();
        return true;
    }

    public boolean zoomOut(boolean playSound, int maxTileChunks) {
        if (tilePixels == 16) {
            if (tileChunks >= maxTileChunks) {
                return false;
            }
            tileChunks <<= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
        } else {
            tilePixels >>= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_144231_, (float)1.0f));
            }
        }
        mapOffsetX /= 2.0;
        mapOffsetY /= 2.0;
        this.updateScaleBookmark();
        return true;
    }

    public void resetZoom() {
        block3: {
            block2: {
                if (!this.zoomIn(true, 8)) break block2;
                while (this.zoomIn(false, 8)) {
                }
                break block3;
            }
            if (!this.zoomOut(true, 1)) break block3;
            while (this.zoomOut(false, 1)) {
            }
        }
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        int left_width;
        int trueMouseX = mouseX;
        int trueMouseY = mouseY;
        if (this.markerModal.getParent() != null) {
            mouseX = -100;
            mouseY = -100;
        }
        super.m_280273_(context);
        this.mapScale = this.calculateMapScale();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.fullscreen) {
            left_width = this.bookWidth / 2 - 15;
            context.m_280260_(BOOK_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.m_280260_(BOOK_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.m_280260_(BOOK_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.m_280163_(BOOK, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, this.bookWidth, this.bookHeight, this.bookWidth, this.bookHeight);
        }
        if (this.worldAtlasData == null) {
            return;
        }
        RenderSystem.enableScissor((int)((int)(this.guiScale() * (double)(this.getGuiX() + 17))), (int)((int)(this.guiScale() * (double)(this.getGuiY() + 11))), (int)((int)(this.guiScale() * (double)this.mapWidth)), (int)((int)(this.guiScale() * (double)this.mapHeight)));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.state.is(DELETING_MARKER) ? 0.5f : 1.0f));
        this.renderTiles(context.m_280168_(), null, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        if (this.fullscreen) {
            left_width = this.bookWidth / 2 - 15;
            context.m_280260_(BOOK_FRAME_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.m_280260_(BOOK_FRAME_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.m_280260_(BOOK_FRAME_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.m_280163_(BOOK_FRAME, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, this.bookWidth, this.bookHeight, this.bookWidth, this.bookHeight);
        }
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)this.getGuiX(), (float)this.getGuiY(), 0.0f);
        float markerScale = this.getEffectiveScale() * ((float)tilePixels / 16.0f);
        Map<UUID, PlayerSummary> friends = AntiqueAtlas.getOrderedFriends();
        for (ResourceLocation id : overlays.keySet()) {
            ((AtlasOverlay)overlays.get(id)).onScreenRender(new AtlasOverlay.AtlasScreenRenderContext(this, context, mouseX, mouseY, markerScale, friends));
        }
        this.hoveredLandmark = null;
        this.hoveredFriend = null;
        if (!this.state.is(HIDING_MARKERS)) {
            if (this.isMouseOverMap) {
                double bestDistance = Double.MAX_VALUE;
                for (Map.Entry<Landmark, MarkerTexture> entry : this.worldAtlasData.getAllMarkers(tileChunks).entrySet()) {
                    Landmark landmark2 = entry.getKey();
                    MarkerTexture texture2 = entry.getValue();
                    BlockPos pos = (BlockPos)landmark2.get(LandmarkComponentTypes.POS);
                    if (pos == null) {
                        Set chunks = RegionPos.regionsToChunks((Map)((Map)landmark2.getOrDefault(LandmarkComponentTypes.CHUNKS, new HashMap())));
                        for (ChunkPos chunk : chunks) {
                            double screenX = this.worldXToScreenX(chunk.m_45604_());
                            double screenEndX = this.worldXToScreenX(chunk.m_45604_() + 16);
                            double screenY = this.worldZToScreenY(chunk.m_45605_());
                            double screenEndY = this.worldZToScreenY(chunk.m_45605_() + 16);
                            boolean isInside = (double)mouseX >= screenX && (double)mouseX < screenEndX && (double)mouseY >= screenY && (double)mouseY < screenEndY;
                            if (!isInside || !(10.0 < bestDistance)) continue;
                            this.hoveredLandmark = landmark2;
                            bestDistance = 10.0;
                        }
                        continue;
                    }
                    double markerX = this.worldXToScreenX(pos.m_123341_());
                    double markerY = this.worldZToScreenY(pos.m_123343_());
                    Vector2d markerCenter = texture2.getCenter(tileChunks);
                    double squaredDistance = Vector2d.distanceSquared((double)(markerX + (double)markerScale * markerCenter.x), (double)(markerY + (double)markerScale * markerCenter.y), (double)mouseX, (double)mouseY);
                    if (!(squaredDistance > 0.0) || !(squaredDistance < bestDistance) || !(squaredDistance < texture2.getSquaredSize(tileChunks) * (double)markerScale * (double)markerScale / 4.0)) continue;
                    bestDistance = squaredDistance;
                    this.hoveredLandmark = landmark2;
                }
                for (PlayerSummary friend2 : friends.values()) {
                    double markerY;
                    double markerX = this.worldXToScreenX(friend2.pos().m_7096_());
                    double squaredDistance = Vector2d.distanceSquared((double)markerX, (double)(markerY = this.worldZToScreenY(friend2.pos().m_7094_())), (double)mouseX, (double)mouseY);
                    if (!(squaredDistance > 0.0) || !(squaredDistance < bestDistance) || !(squaredDistance < 21.0)) continue;
                    bestDistance = squaredDistance;
                    this.hoveredFriend = friend2;
                    this.hoveredLandmark = null;
                }
            }
            this.worldAtlasData.getAllMarkers(tileChunks).forEach((landmark, texture) -> {
                boolean hovering = this.hoveredLandmark == landmark && this.markerModal.getParent() == null;
                boolean editable = WorldLandmarks.canModify((UUID)landmark.owner(), (Level)this.player.m_20193_(), null);
                BiFunction<Double, Double, Float> alpha = (x, y) -> Float.valueOf(this.state.is(PLACING_MARKER) || this.state.is(DELETING_MARKER) && !editable || hovering && x <= 17.0 || x >= (double)(this.mapWidth + 17) || y <= 11.0 || y >= (double)(this.mapHeight + 11) ? 0.5f : 1.0f);
                this.renderMarker(context.m_280168_(), null, (Landmark)landmark, (MarkerTexture)texture, 0.0f, 0xF000F0, alpha, editable, hovering, markerScale);
                net.minecraft.network.chat.Component name = (net.minecraft.network.chat.Component)landmark.get(LandmarkComponentTypes.NAME);
                if (hovering && name != null && !name.getString().isEmpty()) {
                    context.m_280666_(this.f_96547_, Stream.concat(Stream.of(name), ((List)landmark.getOrDefault(LandmarkComponentTypes.LORE, new ArrayList())).stream().map(t -> t.m_6881_().m_130940_(ChatFormatting.GRAY))).toList(), (int)this.getMouseX() - this.getGuiX(), (int)this.getMouseY() - this.getGuiY());
                }
            });
        }
        context.m_280168_().m_85849_();
        RenderSystem.disableScissor();
        if (this.fullscreen) {
            int left_width2 = this.bookWidth / 2 - 15;
            context.m_280260_(BOOK_FRAME_NARROW_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width2, this.bookHeight, 50, 140, 218, 0, 0);
            context.m_280260_(BOOK_FRAME_NARROW_FULLSCREEN, this.getGuiX() + left_width2, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.m_280260_(BOOK_FRAME_NARROW_FULLSCREEN_R, this.getGuiX() + left_width2 + 29, this.getGuiY(), left_width2 + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.m_280163_(BOOK_FRAME_NARROW, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, this.bookWidth, this.bookHeight, this.bookWidth, this.bookHeight);
        }
        this.markerScrollBox.getViewport().setClipped(this.state.is(HIDING_MARKERS));
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)this.getGuiX(), (float)this.getGuiY(), 0.0f);
        friends.forEach((uuid, friend) -> {
            boolean hovering;
            boolean self = uuid.equals(SurveyorClient.getClientUuid());
            boolean bl = hovering = this.hoveredFriend == friend && this.markerModal.getParent() == null;
            if (this.state.is(HIDING_MARKERS) && (!this.playerBookmark.isSelected() || self)) {
                return;
            }
            this.renderPlayer(context.m_280168_(), null, 0.0f, 0xF000F0, (PlayerSummary)friend, this.getEffectiveScale(), this.state.is(PLACING_MARKER) ? 0.5f : 1.0f, hovering, self);
            if (hovering && !self) {
                context.m_280557_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)friend.username()).m_130940_(friend.online() ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GRAY), (int)this.getMouseX() - this.getGuiX(), (int)this.getMouseY() - this.getGuiY());
            }
        });
        context.m_280168_().m_85849_();
        if (this.state.is(PLACING_MARKER)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.m_280163_(this.markerModal.selectedTexture.id(), mouseX + this.markerModal.selectedTexture.offsetX(), mouseY + this.markerModal.selectedTexture.offsetY(), 0.0f, 0.0f, this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight(), this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.addMarkerBookmark.setTitle(AtlasScreen.m_96638_() ? TEXT_ADD_MARKER_HERE : TEXT_ADD_MARKER);
        if (AtlasScreen.m_96639_() && !this.isDragging && this.isMouseOverMap && this.markerModal.getParent() == null) {
            int x = this.screenXToWorldX((int)this.getMouseX());
            int z = this.screenYToWorldZ((int)this.getMouseY());
            ChunkPos pos = new ChunkPos(new BlockPos(x, 0, z));
            context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)"%d,%d (%d,%d)".formatted(pos.f_45578_, pos.f_45579_, x, z)), this.getGuiX(), this.getGuiY() - 12, -1, true);
            if (this.hoveredLandmark != null) {
                texture = this.worldAtlasData.getMarkerTexture(this.hoveredLandmark);
                context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)this.hoveredLandmark.id().toString()), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)this.hoveredLandmark.id().toString())), this.getGuiY() - 12, -1, true);
                if (texture != null) {
                    context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)((MarkerTexture)texture).displayId()), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)((MarkerTexture)texture).displayId())), this.getGuiY() + this.bookHeight, -1, true);
                }
            } else {
                texture = this.worldAtlasData.getTile(pos);
                ResourceLocation providerId = this.worldAtlasData.getProvider(pos);
                String predicate = this.worldAtlasData.getTilePredicate(pos);
                if (texture != null) {
                    if (predicate != null) {
                        context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)predicate), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)predicate)), this.getGuiY() - 12, -1, true);
                    }
                    if (providerId != null) {
                        context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)providerId.toString()), this.getGuiX(), this.getGuiY() + this.bookHeight, -1, true);
                    }
                    context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)((TileTexture)texture).displayId()), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)((TileTexture)texture).displayId())), this.getGuiY() + this.bookHeight, -1, true);
                }
            }
        }
        if (this.markerModal.getParent() != null) {
            this.markerModal.setClipped(true);
            super.m_88315_(context, mouseX, mouseY, partialTick);
            this.markerModal.setClipped(false);
            this.markerModal.m_88315_(context, trueMouseX, trueMouseY, partialTick);
        } else {
            super.m_88315_(context, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public double guiScale() {
        return Minecraft.m_91087_().m_91268_().m_85449_();
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.markerModal.closeChild();
        this.removeChild(this.markerCursor);
    }

    @Override
    public void onChildClosed(Component child) {
        if (((Object)((Object)child)).equals((Object)this.markerModal)) {
            this.removeChild(this.markerCursor);
        }
    }

    float getEffectiveScale() {
        return (float)((double)this.mapScale() / this.guiScale());
    }

    @Override
    public double getPixelsPerBlock() {
        return (double)this.getEffectiveScale() * (double)this.tilePixels() / ((double)this.tileChunks() * 16.0);
    }

    @Override
    public int bookX() {
        return this.getGuiX();
    }

    @Override
    public int bookY() {
        return this.getGuiY();
    }

    @Override
    public int bookHeight() {
        return this.bookHeight;
    }

    @Override
    public int mapWidth() {
        return this.mapWidth;
    }

    @Override
    public int mapHeight() {
        return this.mapHeight;
    }

    @Override
    public double mapOffsetX() {
        return mapOffsetX;
    }

    @Override
    public double mapOffsetY() {
        return mapOffsetY;
    }

    @Override
    public int mapScale() {
        return this.mapScale;
    }

    @Override
    public int tilePixels() {
        return tilePixels;
    }

    @Override
    public int tileChunks() {
        return tileChunks;
    }

    @Override
    public Player player() {
        return this.player;
    }

    @Override
    public int bookWidth() {
        return this.bookWidth;
    }

    @Override
    public WorldAtlasData worldAtlasData() {
        return this.worldAtlasData;
    }

    public void offsetSideButton(Component component) {
        component.offsetGuiCoords(this.bookWidth - 10, this.sideButtonY);
        this.sideButtonY += component.getHeight() + 1;
    }

    static {
        tilePixels = 16;
        tileChunks = 1;
    }
}

