/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.AtlasOverlay;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.gui.core.ScreenState;
import folk.sisby.antique_atlas.gui.tiles.SubTile;
import folk.sisby.antique_atlas.gui.tiles.SubTileQuartet;
import folk.sisby.antique_atlas.gui.tiles.TileRenderIterator;
import folk.sisby.antique_atlas.util.ColorUtil;
import folk.sisby.antique_atlas.util.DrawBatcher;
import folk.sisby.antique_atlas.util.DrawUtil;
import folk.sisby.antique_atlas.util.MathUtil;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.util.RegionPos;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public interface AtlasRenderer {
    public static final Map<ResourceLocation, AtlasOverlay> overlays = new HashMap<ResourceLocation, AtlasOverlay>();
    public static final ResourceLocation BOOK = AntiqueAtlas.id("textures/gui/book.png");
    public static final ResourceLocation BOOK_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_fullscreen.png");
    public static final ResourceLocation BOOK_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_fullscreen_r.png");
    public static final ResourceLocation BOOK_FRAME = AntiqueAtlas.id("textures/gui/book_frame.png");
    public static final ResourceLocation BOOK_FRAME_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_frame_fullscreen.png");
    public static final ResourceLocation BOOK_FRAME_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_frame_fullscreen_r.png");
    public static final ResourceLocation BOOK_FRAME_NARROW = AntiqueAtlas.id("textures/gui/book_frame_narrow.png");
    public static final ResourceLocation BOOK_FRAME_NARROW_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_frame_narrow_fullscreen.png");
    public static final ResourceLocation BOOK_FRAME_NARROW_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_frame_narrow_fullscreen_r.png");
    public static final ResourceLocation PLAYER = AntiqueAtlas.id("textures/gui/player.png");
    public static final ResourceLocation ERASER = AntiqueAtlas.id("textures/gui/eraser.png");
    public static final ResourceLocation ICON_ADD_MARKER = AntiqueAtlas.id("textures/gui/icons/add_marker.png");
    public static final ResourceLocation ICON_DELETE_MARKER = AntiqueAtlas.id("textures/gui/icons/del_marker.png");
    public static final ResourceLocation ICON_SHOW_MARKERS = AntiqueAtlas.id("textures/gui/icons/show_markers.png");
    public static final ResourceLocation ICON_HIDE_MARKERS = AntiqueAtlas.id("textures/gui/icons/hide_markers.png");
    public static final Component TEXT_ADD_MARKER = Component.m_237115_((String)"gui.antique_atlas.addMarker");
    public static final Component TEXT_ADD_MARKER_HERE = Component.m_237115_((String)"gui.antique_atlas.addMarkerHere");
    public static final int DEFAULT_BOOK_WIDTH = 310;
    public static final int DEFAULT_BOOK_HEIGHT = 218;
    public static final int MAP_BORDER_WIDTH = 17;
    public static final int MAP_BORDER_HEIGHT = 11;
    public static final float PLAYER_ROTATION_STEPS = 16.0f;
    public static final int PLAYER_ICON_WIDTH = 7;
    public static final int PLAYER_ICON_HEIGHT = 8;
    public static final int BOOKMARK_SPACING = 2;
    public static final int MARKER_SIZE = 32;
    public static final int NAVIGATE_STEP = 24;
    public static final int MAX_LIGHT = 0xF000F0;
    public static final ScreenState.State<AtlasScreen> NORMAL = new ScreenState.ToggleState<AtlasScreen>();
    public static final ScreenState.State<AtlasScreen> PLACING_MARKER = new ScreenState.ToggleState<AtlasScreen>(s -> s.addMarkerBookmark);
    public static final ScreenState.State<AtlasScreen> DELETING_MARKER = new ScreenState.ToggleState<AtlasScreen>(s -> s.deleteMarkerBookmark, s -> s.addChild(s.eraser), s -> s.removeChild(s.eraser));
    public static final ScreenState.State<AtlasScreen> HIDING_MARKERS = new ScreenState.ToggleState<AtlasScreen>(s -> s.markerVisibilityBookmark, s -> {
        s.markerVisibilityBookmark.setTitle((Component)Component.m_237115_((String)"gui.antique_atlas.showMarkers"));
        s.markerVisibilityBookmark.setIconTexture(ICON_SHOW_MARKERS);
    }, s -> {
        s.clearTargetBookmarks(s.playerBookmark);
        s.markerVisibilityBookmark.setTitle((Component)Component.m_237115_((String)"gui.antique_atlas.hideMarkers"));
        s.markerVisibilityBookmark.setIconTexture(ICON_HIDE_MARKERS);
    });

    public static void registerOverlay(ResourceLocation id, AtlasOverlay overlay) {
        overlays.put(id, overlay);
    }

    public int bookX();

    public int bookY();

    public int bookWidth();

    public int bookHeight();

    public int mapWidth();

    public int mapHeight();

    public double mapOffsetX();

    public double mapOffsetY();

    public int tilePixels();

    public int tileChunks();

    public int mapScale();

    public Player player();

    public WorldAtlasData worldAtlasData();

    public double getPixelsPerBlock();

    public double guiScale();

    default public int screenXToWorldX(double screenX) {
        return AtlasRenderer.screenXToWorldX(screenX, this.bookX(), this.mapOffsetX(), this.mapWidth(), this.getPixelsPerBlock());
    }

    default public int screenYToWorldZ(double screenY) {
        return AtlasRenderer.screenYToWorldZ(screenY, this.bookY(), this.mapOffsetY(), this.mapHeight(), this.getPixelsPerBlock());
    }

    default public double worldXToScreenX(double x) {
        return AtlasRenderer.worldXToScreenX(x, this.bookX(), this.mapOffsetX(), this.mapWidth(), this.getPixelsPerBlock());
    }

    default public double worldZToScreenY(double z) {
        return AtlasRenderer.worldZToScreenY(z, this.bookY(), this.mapOffsetY(), this.mapHeight(), this.getPixelsPerBlock());
    }

    public static int screenXToWorldX(double screenX, int bookX, double mapOffsetX, int mapWidth, double pixelsPerBlock) {
        double mapX = (int)Math.round(screenX - (double)bookX - 17.0);
        return (int)Math.round((mapX - (double)((float)mapWidth / 2.0f) - mapOffsetX) / pixelsPerBlock);
    }

    public static int screenYToWorldZ(double screenY, int bookY, double mapOffsetY, int mapHeight, double pixelsPerBlock) {
        double mapY = (int)Math.round(screenY - (double)bookY - 11.0);
        return (int)Math.round((mapY - (double)((float)mapHeight / 2.0f) - mapOffsetY) / pixelsPerBlock);
    }

    public static double worldXToScreenX(double x, int bookX, double mapOffsetX, int mapWidth, double pixelsPerBlock) {
        double mapX = x * pixelsPerBlock + mapOffsetX + (double)((float)mapWidth / 2.0f);
        return mapX + (double)bookX + 17.0;
    }

    public static double worldZToScreenY(double z, int bookY, double mapOffsetY, int mapHeight, double pixelsPerBlock) {
        double mapY = z * pixelsPerBlock + mapOffsetY + (double)((float)mapHeight / 2.0f);
        return mapY + (double)bookY + 11.0;
    }

    default public void renderMarker(PoseStack matrices, MultiBufferSource vertexConsumers, Landmark landmark, MarkerTexture texture, float z, int light, BiFunction<Double, Double, Float> alphaGetter, boolean pinned, boolean hovering, float markerScale) {
        float tint;
        BlockPos pos = (BlockPos)landmark.get(LandmarkComponentTypes.POS);
        Integer color = (Integer)landmark.get(LandmarkComponentTypes.COLOR);
        float[] accent = color == null ? null : ColorUtil.componentsFromRgb(color);
        float f = tint = hovering ? 0.8f : 1.0f;
        if (pos == null) {
            Set chunks = RegionPos.regionsToChunks((Map)((Map)landmark.getOrDefault(LandmarkComponentTypes.CHUNKS, new HashMap())));
            for (ChunkPos chunk : chunks) {
                double markerX = this.worldXToScreenX(chunk.m_45604_()) - (double)this.bookX();
                double markerY = this.worldZToScreenY(chunk.m_45605_()) - (double)this.bookY();
                float effectiveScale = (float)((double)this.mapScale() / this.guiScale());
                matrices.m_85836_();
                matrices.m_85837_(markerX, markerY, 0.0);
                matrices.m_85841_(effectiveScale, effectiveScale, 1.0f);
                int size = this.tilePixels() / this.tileChunks();
                int lineSize = this.tilePixels() / 16;
                if (size > 0) {
                    float[] fArray;
                    if (accent == null) {
                        fArray = ColorUtil.componentsFromRgb(0xFFFFFF);
                    } else {
                        float[] fArray2 = new float[3];
                        fArray2[0] = tint * accent[0];
                        fArray2[1] = tint * accent[1];
                        fArray = fArray2;
                        fArray2[2] = tint * accent[2];
                    }
                    float[] fillColor = fArray;
                    float alpha = alphaGetter.apply(markerX, markerY).floatValue();
                    DrawUtil.fill(matrices, vertexConsumers, RenderType.m_269508_(), z, light, 0, 0, size, size, 0.25f * alpha, fillColor);
                    if (lineSize > 0) {
                        if (!chunks.contains(new ChunkPos(chunk.f_45578_ - 1, chunk.f_45579_))) {
                            DrawUtil.fill(matrices, vertexConsumers, RenderType.m_269508_(), z, light, 0, 0, lineSize, size, 0.5f * alpha, fillColor);
                        }
                        if (!chunks.contains(new ChunkPos(chunk.f_45578_, chunk.f_45579_ - 1))) {
                            DrawUtil.fill(matrices, vertexConsumers, RenderType.m_269508_(), z, light, 0, 0, size, lineSize, 0.5f * alpha, fillColor);
                        }
                        if (!chunks.contains(new ChunkPos(chunk.f_45578_ + 1, chunk.f_45579_))) {
                            DrawUtil.fill(matrices, vertexConsumers, RenderType.m_269508_(), z, light, size - lineSize, 0, size, size, 0.5f * alpha, fillColor);
                        }
                        if (!chunks.contains(new ChunkPos(chunk.f_45578_, chunk.f_45579_ + 1))) {
                            DrawUtil.fill(matrices, vertexConsumers, RenderType.m_269508_(), z, light, 0, size - lineSize, size, size, 0.5f * alpha, fillColor);
                        }
                    }
                }
                matrices.m_85849_();
            }
            return;
        }
        double markerX = this.worldXToScreenX(pos.m_123341_()) - (double)this.bookX();
        double markerY = this.worldZToScreenY(pos.m_123343_()) - (double)this.bookY();
        if (pinned) {
            markerX = Mth.m_14008_((double)markerX, (double)17.0, (double)(this.mapWidth() + 17));
            markerY = Mth.m_14008_((double)markerY, (double)11.0, (double)(this.mapHeight() + 11));
        }
        texture.draw(matrices, vertexConsumers, markerX, markerY, z, markerScale, this.tileChunks(), accent, tint, alphaGetter.apply(markerX, markerY).floatValue(), light);
    }

    default public void renderPlayer(PoseStack matrices, MultiBufferSource vertexConsumers, float z, int light, PlayerSummary player, float iconScale, float alpha, boolean hovering, boolean self) {
        double playerOffsetX = this.worldXToScreenX(player.pos().m_7096_()) - (double)this.bookX();
        double playerOffsetY = this.worldZToScreenY(player.pos().m_7094_()) - (double)this.bookY();
        playerOffsetX = Mth.m_14008_((double)playerOffsetX, (double)17.0, (double)(this.mapWidth() + 17));
        playerOffsetY = Mth.m_14008_((double)playerOffsetY, (double)11.0, (double)(this.mapHeight() + 11));
        float tint = (player.online() ? 1.0f : 0.5f) * (hovering ? 0.9f : 1.0f);
        float greenTint = self ? 1.0f : 0.7f;
        int argb = FastColor.ARGB32.m_13660_((int)((int)((double)alpha * 255.0)), (int)((int)(tint * 255.0f)), (int)((int)(tint * greenTint * 255.0f)), (int)((int)(tint * 255.0f)));
        float playerRotation = (float)Math.round(player.yaw() / 360.0f * 16.0f) / 16.0f * 360.0f;
        DrawUtil.drawCenteredWithRotation(matrices, vertexConsumers, PLAYER, playerOffsetX, playerOffsetY, z, iconScale, 7, 8, playerRotation, light, argb);
    }

    default public void renderTiles(PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        int mapStartChunkX = MathUtil.roundToBase(this.screenXToWorldX(this.bookX()) >> 4, this.tileChunks()) - 2 * this.tileChunks();
        int mapStartChunkZ = MathUtil.roundToBase(this.screenYToWorldZ(this.bookY()) >> 4, this.tileChunks()) - 2 * this.tileChunks();
        int mapEndChunkX = MathUtil.roundToBase(this.screenXToWorldX(this.bookX() + this.bookWidth()) >> 4, this.tileChunks()) + 2 * this.tileChunks();
        int mapEndChunkZ = MathUtil.roundToBase(this.screenYToWorldZ(this.bookY() + this.bookHeight()) >> 4, this.tileChunks()) + 2 * this.tileChunks();
        double mapStartScreenX = this.worldXToScreenX(mapStartChunkX << 4);
        double mapStartScreenY = this.worldZToScreenY(mapStartChunkZ << 4);
        TileRenderIterator tiles = new TileRenderIterator(this.worldAtlasData());
        tiles.setScope(new Rect(mapStartChunkX, mapStartChunkZ, mapEndChunkX, mapEndChunkZ));
        tiles.setStep(this.tileChunks());
        int mapX = this.bookX() + 17;
        int mapY = this.bookY() + 11;
        float effectiveScale = (float)((double)this.mapScale() / this.guiScale());
        matrices.m_85836_();
        matrices.m_85837_(mapStartScreenX, mapStartScreenY, 0.0);
        matrices.m_85841_(effectiveScale, effectiveScale, 1.0f);
        Reference2ObjectArrayMap tileTextures = new Reference2ObjectArrayMap();
        for (SubTileQuartet subTiles : tiles) {
            for (SubTile subtile : subTiles) {
                if (subtile == null || subtile.texture == null) continue;
                tileTextures.computeIfAbsent(subtile.texture, k -> new ArrayList()).add(subtile.copy());
            }
        }
        int subTilePixels = this.tilePixels() / 2;
        tileTextures.forEach((texture, subtiles) -> {
            try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, texture.id(), 32, 48, light, true);){
                for (SubTile subtile : subtiles) {
                    int drawX = subtile.x * subTilePixels;
                    int drawY = subtile.y * subTilePixels;
                    if ((double)((float)drawX * effectiveScale) > (double)(mapX + this.mapWidth()) - mapStartScreenX || (double)((float)drawY * effectiveScale) > (double)(mapY + this.mapHeight()) - mapStartScreenY || (double)((float)(drawX + subTilePixels) * effectiveScale) < (double)mapX - mapStartScreenX || (double)((float)(drawY + subTilePixels) * effectiveScale) < (double)mapY - mapStartScreenY) continue;
                    batcher.add(drawX, drawY, 0.0f, subTilePixels, subTilePixels, subtile.getTextureU() * 8, subtile.getTextureV() * 8, 8, 8, -1);
                }
            }
        });
        matrices.m_85849_();
    }
}

