/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.google.common.collect.Multimap;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.StructureTileProvider;
import folk.sisby.antique_atlas.TerrainTileProvider;
import folk.sisby.antique_atlas.TerrainTiling;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.reloader.StructureTileProviders;
import folk.sisby.antique_atlas.reloader.TileTextures;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentMap;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.RegionPos;
import it.unimi.dsi.fastutil.Pair;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;

public class WorldAtlasData {
    public static final Map<ResourceKey<Level>, WorldAtlasData> WORLDS = new HashMap<ResourceKey<Level>, WorldAtlasData>();
    protected final Map<ChunkPos, TileTexture> biomeTiles = new HashMap<ChunkPos, TileTexture>();
    protected final Map<ChunkPos, TileTexture> structureTiles = new HashMap<ChunkPos, TileTexture>();
    protected final Map<UUID, Map<ResourceLocation, Pair<Landmark, MarkerTexture>>> landmarkMarkers = new ConcurrentHashMap<UUID, Map<ResourceLocation, Pair<Landmark, MarkerTexture>>>();
    protected final Map<Landmark, MarkerTexture> structureMarkers = new ConcurrentHashMap<Landmark, MarkerTexture>();
    protected final Rect tileScope = new Rect(0, 0, 0, 0);
    protected final Set<ChunkPos> terrainDequeHash = new HashSet<ChunkPos>();
    protected final Deque<ChunkPos> terrainDeque = new ConcurrentLinkedDeque<ChunkPos>();
    protected boolean isFinished = false;
    protected final Map<ChunkPos, String> debugBiomePredicates = new HashMap<ChunkPos, String>();
    protected final Map<ChunkPos, String> debugStructurePredicates = new HashMap<ChunkPos, String>();
    protected final Map<ChunkPos, TerrainTileProvider> debugBiomes = new HashMap<ChunkPos, TerrainTileProvider>();
    protected final Map<ChunkPos, StructureTileProvider> debugStructures = new HashMap<ChunkPos, StructureTileProvider>();

    public static WorldAtlasData getOrCreate(Level world) {
        return WORLDS.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), k -> new WorldAtlasData());
    }

    public static void onLoad(Level world, WorldSummary summary, LocalPlayer player, Map<RegionPos, BitSet> terrain, Multimap<ResourceKey<Structure>, ChunkPos> structures, Multimap<UUID, ResourceLocation> landmarks) {
        WorldAtlasData data = WorldAtlasData.getOrCreate(world);
        data.onTerrainUpdated(world, summary.terrain(), WorldTerrainSummary.toKeys(terrain, (ChunkPos)player.m_146902_()));
        data.onStructuresAdded(world, summary.structures(), structures);
        data.onLandmarksAdded(world, summary.landmarks(), landmarks);
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Beginning to load terrain for {} - {} chunks available.", (Object)world.m_46472_().m_135782_(), (Object)data.terrainDeque.size());
    }

    public void onTerrainUpdated(Level world, WorldTerrainSummary ignored2, Collection<ChunkPos> chunks) {
        for (ChunkPos pos : chunks) {
            if (this.biomeTiles.containsKey(pos) || this.terrainDequeHash.contains(pos)) continue;
            this.terrainDequeHash.add(pos);
            this.terrainDeque.add(pos);
        }
    }

    public void onStructuresAdded(Level world, WorldStructureSummary ws, Multimap<ResourceKey<Structure>, ChunkPos> summaries) {
        summaries.forEach((key, pos) -> StructureTileProviders.getInstance().resolve(this.structureTiles, this.debugStructures, this.debugStructurePredicates, this.structureMarkers, world, (ResourceKey<Structure>)key, (ChunkPos)pos, ws.get(key, pos), (ResourceKey<StructureType<?>>)ws.getType(key), ws.getTags(key)));
    }

    public void tick(Level world) {
        if (!BiomeTileProviders.getInstance().hasFallbacks()) {
            return;
        }
        for (int i = 0; i < AntiqueAtlas.CONFIG.chunkTickLimit; ++i) {
            Pair<TerrainTileProvider, TileElevation> tile;
            ChunkPos pos = this.terrainDeque.pollFirst();
            this.terrainDequeHash.remove(pos);
            if (pos == null) break;
            Pair<TerrainTileProvider, TileElevation> pair = tile = world.m_46472_() == Level.f_46429_ ? TerrainTiling.terrainToTileNether(world, pos) : TerrainTiling.terrainToTile(world, pos);
            if (tile == null) continue;
            this.tileScope.extendTo(pos.f_45578_, pos.f_45579_);
            this.biomeTiles.put(pos, ((TerrainTileProvider)tile.left()).getTexture(pos, (TileElevation)((Object)tile.right())));
            this.debugBiomes.put(pos, (TerrainTileProvider)tile.left());
            this.debugBiomePredicates.put(pos, tile.right() == null ? null : ((TileElevation)((Object)tile.right())).getName());
        }
        if (!this.isFinished && this.terrainDeque.isEmpty()) {
            this.isFinished = true;
            AntiqueAtlas.LOGGER.info("[Antique Atlas] Finished loading terrain for {} - {} tiles.", (Object)world.m_46472_().m_135782_(), (Object)this.biomeTiles.size());
        }
    }

    public Rect getScope() {
        return this.tileScope;
    }

    public TileTexture getTile(int x, int z) {
        return this.getTile(new ChunkPos(x, z));
    }

    public TileTexture getTile(ChunkPos pos) {
        if (!this.biomeTiles.containsKey(pos)) {
            return AntiqueAtlas.CONFIG.emptyHandling == AntiqueAtlasConfig.EmptyHandling.CLOUDS ? TileTextures.getInstance().getTextures().get(AntiqueAtlas.id("clouds")) : null;
        }
        return this.structureTiles.getOrDefault(pos, this.biomeTiles.get(pos));
    }

    public ResourceLocation getProvider(ChunkPos pos) {
        if (this.structureTiles.containsKey(pos)) {
            return this.debugStructures.get(pos).id();
        }
        return this.debugBiomes.containsKey(pos) ? this.debugBiomes.get(pos).id() : null;
    }

    public String getTilePredicate(ChunkPos pos) {
        if (this.structureTiles.containsKey(pos)) {
            return this.debugStructurePredicates.get(pos);
        }
        return this.debugBiomePredicates.get(pos);
    }

    public void addLandmarkMarker(Landmark landmark, MarkerTexture texture) {
        this.landmarkMarkers.computeIfAbsent(landmark.owner(), t -> new ConcurrentHashMap()).put(landmark.id(), Pair.of((Object)landmark, (Object)texture));
    }

    public static Landmark copyLandmarkWith(Landmark landmark, ResourceLocation id, Consumer<LandmarkComponentMap> modifier) {
        LandmarkComponentMap copy = LandmarkComponentMap.builder().build();
        landmark.components().keySet().forEach(t -> copy.set(t, landmark.components().get(t)));
        modifier.accept(copy);
        return new Landmark(landmark.owner(), id, copy);
    }

    public void addLandmark(Landmark landmark) {
        if (landmark == null) {
            return;
        }
        if (landmark.id().m_135815_().startsWith("grave")) {
            AntiqueAtlasConfig.GraveStyle style = AntiqueAtlas.CONFIG.graveStyle;
            Component name = (Component)landmark.get(LandmarkComponentTypes.NAME);
            if (name == null && style == AntiqueAtlasConfig.GraveStyle.CAUSE) {
                style = AntiqueAtlasConfig.GraveStyle.DIED;
            }
            MutableComponent timeText = Component.m_237113_((String)String.valueOf(1L + (Long)landmark.getOrDefault(LandmarkComponentTypes.TIME, (Object)0L) / 24000L)).m_130940_(ChatFormatting.WHITE);
            String key = "gui.antique_atlas.marker.death.%s".formatted(style.toString().toLowerCase());
            MutableComponent text = switch (style) {
                default -> throw new IncompatibleClassChangeError();
                case AntiqueAtlasConfig.GraveStyle.CAUSE -> Component.m_237110_((String)key, (Object[])new Object[]{name.m_6881_().m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.RED), timeText}).m_130940_(ChatFormatting.GRAY);
                case AntiqueAtlasConfig.GraveStyle.GRAVE, AntiqueAtlasConfig.GraveStyle.ITEMS, AntiqueAtlasConfig.GraveStyle.DIED -> Component.m_237110_((String)key, (Object[])new Object[]{Component.m_237115_((String)"gui.antique_atlas.marker.death.%s.verb".formatted(style.toString().toLowerCase())).m_130940_(ChatFormatting.RED), timeText}).m_130940_(ChatFormatting.GRAY);
                case AntiqueAtlasConfig.GraveStyle.EUPHEMISMS -> Component.m_237110_((String)key, (Object[])new Object[]{Component.m_237115_((String)"gui.antique_atlas.marker.death.%s.verb.%s".formatted(style.toString().toLowerCase(), new Random(((Integer)landmark.getOrDefault(LandmarkComponentTypes.SEED, (Object)0)).intValue()).nextInt(11))).m_130940_(ChatFormatting.RED), timeText}).m_130940_(ChatFormatting.GRAY);
            };
            this.addLandmarkMarker(WorldAtlasData.copyLandmarkWith(landmark, landmark.id(), m -> m.set(LandmarkComponentTypes.NAME, (Object)text)), MarkerTextures.getInstance().fromLandmark(landmark, style == AntiqueAtlasConfig.GraveStyle.ITEMS ? "items" : null));
        } else {
            this.addLandmarkMarker(landmark, MarkerTextures.getInstance().fromLandmark(landmark));
        }
    }

    public void onLandmarksAdded(Level ignored, WorldLandmarks worldLandmarks, Multimap<UUID, ResourceLocation> landmarks) {
        landmarks.forEach((type, pos) -> this.addLandmark(worldLandmarks.get(type, pos)));
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AtlasScreen) {
            AtlasScreen as = (AtlasScreen)screen;
            as.updateBookmarkerList();
        }
    }

    public void onLandmarksRemoved(Level ignored, WorldLandmarks ignored2, Multimap<UUID, ResourceLocation> landmarks) {
        landmarks.forEach((type, pos) -> {
            if (this.landmarkMarkers.containsKey(type)) {
                this.landmarkMarkers.get(type).remove(pos);
                if (this.landmarkMarkers.get(type).isEmpty()) {
                    this.landmarkMarkers.remove(type);
                }
            }
        });
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AtlasScreen) {
            AtlasScreen as = (AtlasScreen)screen;
            as.updateBookmarkerList();
        }
    }

    public boolean deleteLandmark(Level world, Landmark landmark) {
        WorldLandmarks summary = WorldSummary.of((Level)world).landmarks();
        if (summary == null || !WorldLandmarks.canModify((UUID)landmark.owner(), (Level)world, null)) {
            return false;
        }
        summary.remove(world, landmark.owner(), landmark.id());
        return true;
    }

    public Map<Landmark, MarkerTexture> getEditableLandmarks(Level world) {
        HashMap<Landmark, MarkerTexture> map = new HashMap<Landmark, MarkerTexture>();
        this.landmarkMarkers.forEach((type, landmarks) -> landmarks.forEach((pos, pair) -> {
            if (WorldLandmarks.canModify((UUID)((Landmark)pair.left()).owner(), (Level)world, null)) {
                map.put((Landmark)pair.left(), (MarkerTexture)pair.right());
            }
        }));
        return map;
    }

    public Map<Landmark, MarkerTexture> getAllMarkers(int tileChunks) {
        HashMap<Landmark, MarkerTexture> map = new HashMap<Landmark, MarkerTexture>();
        this.landmarkMarkers.forEach((type, landmarks) -> landmarks.forEach((pos, pair) -> map.put((Landmark)pair.left(), (MarkerTexture)pair.right())));
        this.structureMarkers.forEach((landmark, texture) -> {
            if (tileChunks >= texture.nearClip() && tileChunks <= texture.farClip()) {
                map.put((Landmark)landmark, (MarkerTexture)texture);
            }
        });
        return map;
    }

    public MarkerTexture getMarkerTexture(Landmark landmark) {
        return this.landmarkMarkers.containsKey(landmark.owner()) && this.landmarkMarkers.get(landmark.owner()).containsKey(landmark.id()) ? (MarkerTexture)this.landmarkMarkers.get(landmark.owner()).get(landmark.id()).right() : this.structureMarkers.get(landmark);
    }
}

