/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public record TileTexture(ResourceLocation id, boolean innerBorder, Set<TileTexture> tilesTo, Set<TileTexture> tilesToHorizontal, Set<TileTexture> tilesToVertical) {
    public static final TileTexture DEFAULT = TileTexture.empty(AntiqueAtlas.id(AntiqueAtlas.CONFIG.fallbackFailHandling == AntiqueAtlasConfig.FallbackHandling.TEST ? "test" : "missing"), false);

    public static TileTexture empty(ResourceLocation id, boolean innerBorder) {
        return new TileTexture(ResourceLocation.m_214293_((String)id.m_135827_(), (String)"textures/atlas/tile/%s.png".formatted(id.m_135815_())), innerBorder, (Set<TileTexture>)new ReferenceOpenHashSet(), (Set<TileTexture>)new ReferenceOpenHashSet(), (Set<TileTexture>)new ReferenceOpenHashSet());
    }

    public String displayId() {
        ResourceLocation trimmed = this.id.m_247266_(p -> p.substring("textures/atlas/tile/".length(), this.id.m_135815_().length() - 4));
        return this.id.m_135827_().equals("antique_atlas") ? trimmed.m_135815_() : trimmed.toString();
    }

    public boolean tiles(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToHorizontal.contains(other) || this.tilesToVertical.contains(other));
    }

    public boolean tilesHorizontally(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToHorizontal.contains(other));
    }

    public boolean tilesVertically(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToVertical.contains(other));
    }

    public record Builder(ResourceLocation id, boolean innerBorder, Set<ResourceLocation> tilesTo, Set<ResourceLocation> tilesToHorizontal, Set<ResourceLocation> tilesToVertical) {
        public void build(Map<ResourceLocation, TileTexture> emptyTextures) {
            if (!this.tilesTo.isEmpty()) {
                emptyTextures.get((Object)this.id).tilesTo.addAll(this.tilesTo.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            if (!this.tilesToHorizontal.isEmpty()) {
                emptyTextures.get((Object)this.id).tilesToHorizontal.addAll(this.tilesToHorizontal.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            if (!this.tilesToVertical.isEmpty()) {
                emptyTextures.get((Object)this.id).tilesToVertical.addAll(this.tilesToVertical.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
        }
    }
}

