/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import folk.sisby.antique_atlas.FeatureTiles;
import folk.sisby.antique_atlas.TerrainTileProvider;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.RegistryPalette;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class TerrainTiling {
    public static final int EMPTY_PRIORITY = 16;
    public static final int RAVINE_PRIORITY = 12;
    public static final int LAVA_PRIORITY = 6;
    public static final int WATER_PRIORITY = 4;
    public static final int ICE_PRIORITY = 3;
    public static final int BEACH_PRIORITY = 3;
    public static final List<ResourceLocation> CUSTOM_TILES = List.of(FeatureTiles.BEDROCK_ROOF, FeatureTiles.EMPTY, FeatureTiles.END_VOID, FeatureTiles.WATER, FeatureTiles.ICE, FeatureTiles.TILE_RAVINE, FeatureTiles.SWAMP_WATER, FeatureTiles.TILE_LAVA, FeatureTiles.TILE_LAVA_SHORE);
    public static final int NETHER_SCAN_HEIGHT = 50;
    public static final Map<Biome, Integer> priorityCache = new Reference2IntArrayMap();
    public static final Map<Biome, Boolean> swampCache = new Reference2BooleanArrayMap();

    public static int priorityForBiome(Registry<Biome> biomeRegistry, Biome biome) {
        return priorityCache.computeIfAbsent(biome, b -> {
            Holder biomeEntry = biomeRegistry.m_263177_((Object)biome);
            if (biomeEntry.m_203656_(BiomeTags.f_207604_)) {
                return 3;
            }
            if (biomeEntry.m_203656_(BiomeTags.f_207612_)) {
                return 2;
            }
            return 1;
        });
    }

    public static boolean isSwamp(Registry<Biome> biomeRegistry, Biome biome) {
        return swampCache.computeIfAbsent(biome, b -> biomeRegistry.m_263177_(b).m_203656_(ConventionalBiomeTags.SWAMP));
    }

    public static Pair<TerrainTileProvider, TileElevation> frequencyToTexture(int[][] possibleTiles, Registry<Biome> biomeRegistry, IdMap<Biome> biomePalette) {
        int elevationOrdinal = -1;
        int biomeIndex = -1;
        int bestFrequency = 0;
        for (int i = 0; i < possibleTiles.length; ++i) {
            for (int j = 0; j < possibleTiles[i].length; ++j) {
                if (possibleTiles[i][j] <= bestFrequency) continue;
                elevationOrdinal = i;
                biomeIndex = j;
                bestFrequency = possibleTiles[i][j];
            }
        }
        if (bestFrequency == 0) {
            return null;
        }
        int customTileIndex = biomeIndex - possibleTiles[0].length + CUSTOM_TILES.size();
        ResourceLocation providerId = customTileIndex >= 0 ? CUSTOM_TILES.get(customTileIndex) : biomeRegistry.m_7981_((Object)((Biome)biomePalette.m_7942_(biomeIndex)));
        return Pair.of((Object)BiomeTileProviders.getInstance().getTileProvider(providerId), elevationOrdinal == TileElevation.values().length ? null : TileElevation.values()[elevationOrdinal]);
    }

    public static Pair<TerrainTileProvider, TileElevation> terrainToTile(Level world, ChunkPos pos) {
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        int defaultTile = CUSTOM_TILES.indexOf(world.m_6042_().f_63856_() ? FeatureTiles.BEDROCK_ROOF : (world.m_46472_() == Level.f_46430_ ? FeatureTiles.END_VOID : FeatureTiles.EMPTY));
        boolean checkRavines = world.m_46472_() == Level.f_46428_;
        int worldHeight = world.m_151558_();
        WorldTerrainSummary terrain = WorldSummary.of((Level)world).terrain();
        if (terrain == null) {
            return null;
        }
        ChunkSummary chunk = terrain.get(pos);
        if (chunk == null) {
            return null;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LayerSummary.Raw summary = chunk.toSingleLayer(null, null, world.m_151558_());
        RegistryPalette.ValueView biomePalette = terrain.getBiomePalette(pos);
        RegistryPalette.ValueView blockPalette = terrain.getBlockPalette(pos);
        if (summary == null) {
            return Pair.of((Object)BiomeTileProviders.getInstance().getTileProvider(CUSTOM_TILES.get(defaultTile)), null);
        }
        int elevationSize = TileElevation.values().length;
        int elevationCount = elevationSize + 1;
        int biomeCount = biomePalette.m_13562_();
        int baseTileCount = biomeCount + CUSTOM_TILES.size();
        int[][] possibleTiles = new int[elevationCount][baseTileCount];
        for (int i = 0; i < summary.depths().length; ++i) {
            if (!summary.exists().get(i)) {
                int[] nArray = possibleTiles[elevationSize];
                int n = defaultTile;
                nArray[n] = nArray[n] + 16;
                continue;
            }
            int height = worldHeight - summary.depths()[i] + summary.waterDepths()[i];
            Block block = (Block)blockPalette.m_7942_(summary.blocks()[i]);
            Biome biome = (Biome)biomePalette.m_7942_(summary.biomes()[i]);
            if (checkRavines && height - world.m_5736_() < -7) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_RAVINE);
                nArray[n] = nArray[n] + 12;
            } else if (summary.waterDepths()[i] > 0) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(TerrainTiling.isSwamp((Registry<Biome>)biomeRegistry, biome) ? FeatureTiles.SWAMP_WATER : FeatureTiles.WATER);
                nArray[n] = nArray[n] + 4;
            } else if (block == Blocks.f_50126_) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.ICE);
                nArray[n] = nArray[n] + 3;
            } else if (block == Blocks.f_49991_) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_LAVA);
                nArray[n] = nArray[n] + 6;
            }
            int[] nArray = possibleTiles[TileElevation.fromBlocksAboveSea(height - world.m_5736_()).ordinal()];
            int n = summary.biomes()[i];
            nArray[n] = nArray[n] + TerrainTiling.priorityForBiome((Registry<Biome>)biomeRegistry, biome);
        }
        return TerrainTiling.frequencyToTexture(possibleTiles, (Registry<Biome>)biomeRegistry, (IdMap<Biome>)biomePalette);
    }

    public static Pair<TerrainTileProvider, TileElevation> terrainToTileNether(Level world, ChunkPos pos) {
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        int defaultTile = CUSTOM_TILES.indexOf(world.m_6042_().f_63856_() ? FeatureTiles.BEDROCK_ROOF : (world.m_46472_() == Level.f_46430_ ? FeatureTiles.END_VOID : FeatureTiles.EMPTY));
        WorldTerrainSummary terrain = WorldSummary.of((Level)world).terrain();
        if (terrain == null) {
            return null;
        }
        ChunkSummary chunk = terrain.get(pos);
        if (chunk == null) {
            return null;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LayerSummary.Raw lowSummary = chunk.toSingleLayer(null, Integer.valueOf(50), world.m_151558_());
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LayerSummary.Raw fullSummary = chunk.toSingleLayer(null, Integer.valueOf(world.m_141937_() + world.m_6042_().f_63865_() - 1), world.m_151558_());
        RegistryPalette.ValueView biomePalette = terrain.getBiomePalette(pos);
        RegistryPalette.ValueView blockPalette = terrain.getBlockPalette(pos);
        int elevationSize = TileElevation.values().length;
        int elevationCount = elevationSize + 1;
        int biomeCount = biomePalette.m_13562_();
        int baseTileCount = biomeCount + CUSTOM_TILES.size();
        int[][] possibleTiles = new int[elevationCount][baseTileCount];
        if (fullSummary == null) {
            return Pair.of((Object)BiomeTileProviders.getInstance().getTileProvider(CUSTOM_TILES.get(defaultTile)), null);
        }
        int SEA_DEPTH = world.m_151558_() - 31;
        if (lowSummary == null) {
            for (int i = 0; i < fullSummary.depths().length; ++i) {
                if (!fullSummary.exists().get(i)) {
                    int[] nArray = possibleTiles[elevationSize];
                    int n = defaultTile;
                    nArray[n] = nArray[n] + 16;
                    continue;
                }
                Biome biome = (Biome)biomePalette.m_7942_(fullSummary.biomes()[i]);
                int[] nArray = possibleTiles[elevationSize];
                int n = fullSummary.biomes()[i];
                nArray[n] = nArray[n] + TerrainTiling.priorityForBiome((Registry<Biome>)biomeRegistry, biome);
            }
        } else {
            for (int i = 0; i < lowSummary.depths().length; ++i) {
                if (!lowSummary.exists().get(i) || lowSummary.depths()[i] > SEA_DEPTH) {
                    Biome biome = (Biome)biomePalette.m_7942_(fullSummary.biomes()[i]);
                    int[] nArray = possibleTiles[elevationSize];
                    int n = fullSummary.biomes()[i];
                    nArray[n] = nArray[n] + TerrainTiling.priorityForBiome((Registry<Biome>)biomeRegistry, biome);
                    continue;
                }
                Block block = (Block)blockPalette.m_7942_(lowSummary.blocks()[i]);
                if (block == Blocks.f_49991_) {
                    int[] nArray = possibleTiles[elevationSize];
                    int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_LAVA);
                    nArray[n] = nArray[n] + 6;
                    continue;
                }
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_LAVA_SHORE);
                nArray[n] = nArray[n] + 3;
            }
        }
        return TerrainTiling.frequencyToTexture(possibleTiles, (Registry<Biome>)biomeRegistry, (IdMap<Biome>)biomePalette);
    }
}

