/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.google.common.collect.Multimap;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import folk.sisby.antique_atlas.AntiqueAtlasKeybindings;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.gui.core.ScreenState;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.reloader.StructureTileProviders;
import folk.sisby.antique_atlas.reloader.TileTextures;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AntiqueAtlas
implements ClientModInitializer {
    public static final String ID = "antique_atlas";
    public static final String NAME = "Antique Atlas";
    public static final Logger LOGGER = LogManager.getLogger((String)"Antique Atlas");
    public static final AntiqueAtlasConfig CONFIG = (AntiqueAtlasConfig)AntiqueAtlasConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"", (String)"antique-atlas", AntiqueAtlasConfig.class);
    public static final ScreenState<AtlasScreen> lastState = new ScreenState();
    public static final ModelResourceLocation ATLAS_MODEL = new ModelResourceLocation(AntiqueAtlas.id("atlas"), "inventory");
    public static final List<String> ATLAS_NAMES = List.of("Antique Atlas");

    public static ResourceLocation id(String path) {
        return path.contains(":") ? ResourceLocation.m_135820_((String)path) : ResourceLocation.m_214293_((String)ID, (String)path);
    }

    public static ItemStack getHandheldAtlas() {
        ItemStack stack = Items.f_42517_.m_7968_().m_41777_();
        stack.m_41714_((Component)Component.m_237115_((String)"item.antique_atlas.atlas").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false))));
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"item.antique_atlas.atlas.lore").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237110_((String)"item.antique_atlas.atlas.hint", (Object[])new Object[]{Component.m_237115_((String)"item.antique_atlas.atlas")}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
        return stack;
    }

    public static AtlasScreen openAtlasScreen() {
        if (Minecraft.m_91087_().f_91080_ == null && (!AntiqueAtlas.CONFIG.requireItem || Minecraft.m_91087_().f_91074_ != null && AntiqueAtlas.hasHandheldAtlas((Player)Minecraft.m_91087_().f_91074_))) {
            AtlasScreen screen = new AtlasScreen();
            screen.m_7856_();
            screen.prepareToOpen();
            screen.m_86600_();
            Minecraft.m_91087_().m_91152_((Screen)screen);
            return screen;
        }
        return null;
    }

    public static boolean isHandheldAtlas(ItemStack stack) {
        return stack.m_150930_(Items.f_42517_) && ATLAS_NAMES.stream().anyMatch(n -> stack.m_41786_().getString().contains((CharSequence)n));
    }

    public static boolean hasHandheldAtlas(Player player) {
        if (AntiqueAtlas.isHandheldAtlas(player.m_21206_())) {
            return true;
        }
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (!AntiqueAtlas.isHandheldAtlas(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static Map<UUID, PlayerSummary> getOrderedFriends() {
        Map friends = SurveyorClient.getFriends();
        PlayerSummary playerSummary = (PlayerSummary)friends.remove(SurveyorClient.getClientUuid());
        LinkedHashMap<UUID, PlayerSummary> orderedFriends = new LinkedHashMap<UUID, PlayerSummary>(friends);
        if (playerSummary != null) {
            orderedFriends.put(SurveyorClient.getClientUuid(), playerSummary);
        }
        return orderedFriends;
    }

    public void onInitializeClient() {
        AntiqueAtlasKeybindings.init();
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)TileTextures.getInstance());
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)StructureTileProviders.getInstance());
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)BiomeTileProviders.getInstance());
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)MarkerTextures.getInstance());
        SurveyorClientEvents.Register.worldLoad((ResourceLocation)AntiqueAtlas.id("world_data"), WorldAtlasData::onLoad);
        SurveyorClientEvents.Register.terrainUpdated((ResourceLocation)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onTerrainUpdated(w, s, k));
        SurveyorClientEvents.Register.structuresAdded((ResourceLocation)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onStructuresAdded(w, s, (Multimap<ResourceKey<Structure>, ChunkPos>)k));
        SurveyorClientEvents.Register.landmarksAdded((ResourceLocation)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onLandmarksAdded(w, s, (Multimap<UUID, ResourceLocation>)k));
        SurveyorClientEvents.Register.landmarksRemoved((ResourceLocation)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onLandmarksRemoved(w, s, (Multimap<UUID, ResourceLocation>)k));
        ClientTickEvents.END_WORLD_TICK.register(w -> WorldAtlasData.getOrCreate((Level)w).tick((Level)w));
        CommonLifecycleEvents.TAGS_LOADED.register((manager, client) -> BiomeTileProviders.getInstance().registerFallbacks((Registry<Biome>)manager.m_175515_(Registries.f_256952_)));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> BiomeTileProviders.getInstance().clearFallbacks());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> WorldAtlasData.WORLDS.clear());
        ItemProperties.m_174570_((Item)Items.f_42517_, (ResourceLocation)AntiqueAtlas.id("atlas"), (stack, world, entity, seed) -> AntiqueAtlas.isHandheldAtlas(stack) ? 1.0f : 0.0f);
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.f_256869_).register(e -> e.addAfter((ItemLike)Items.f_42676_, new ItemStack[]{AntiqueAtlas.getHandheldAtlas()}));
        WorldSummary.enableTerrain();
        WorldSummary.enableStructures();
        WorldSummary.enableLandmarks();
        FabricLoader.getInstance().getModContainer(ID).ifPresent(c -> ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)AntiqueAtlas.id("shader_patch"), (ModContainer)c, (Component)Component.m_130674_((String)"Shader Patch"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
    }
}

