/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.util;

import com.myangel.playerlocatorplus.util.PlayerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PlayerDataState
extends SavedData {
    private static final String DATA_NAME = "playerlocatorplusreforged_player_data";
    private final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

    public static PlayerDataState get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (PlayerDataState)storage.m_164861_(PlayerDataState::load, PlayerDataState::new, DATA_NAME);
    }

    private static PlayerDataState load(CompoundTag tag) {
        PlayerDataState state = new PlayerDataState();
        for (String key : tag.m_128431_()) {
            CompoundTag playerTag = tag.m_128469_(key);
            PlayerData data = new PlayerData();
            if (playerTag.m_128441_("customColor")) {
                data.setCustomColor(playerTag.m_128451_("customColor"));
            }
            try {
                state.players.put(UUID.fromString(key), data);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return state;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128405_("customColor", entry.getValue().customColor());
            tag.m_128365_(entry.getKey().toString(), (Tag)playerTag);
        }
        return tag;
    }

    public PlayerData get(UUID uuid) {
        return this.players.computeIfAbsent(uuid, id -> {
            this.m_77762_();
            return new PlayerData();
        });
    }

    public void setCustomColor(UUID uuid, int color) {
        PlayerData data = this.get(uuid);
        data.setCustomColor(color);
        this.m_77762_();
    }
}

