/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.server;

import com.myangel.playerlocatorplus.config.ColorMode;
import com.myangel.playerlocatorplus.config.PlayerLocatorConfig;
import com.myangel.playerlocatorplus.config.ServerValues;
import com.myangel.playerlocatorplus.network.LocatorDataPacket;
import com.myangel.playerlocatorplus.network.NetworkHandler;
import com.myangel.playerlocatorplus.network.RelativePlayerLocation;
import com.myangel.playerlocatorplus.network.ServerConfigPacket;
import com.myangel.playerlocatorplus.util.ColorUtils;
import com.myangel.playerlocatorplus.util.PlayerData;
import com.myangel.playerlocatorplus.util.PlayerDataState;
import com.myangel.playerlocatorplus.util.PlayerLocatorTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.joml.Vector3f;

public final class ServerTracker {
    private static final double TWO_PI = Math.PI * 2;
    private static final double HEIGHT_ARROW_THRESHOLD = 4.0;
    private static int tickCounter = 0;
    private static boolean configDirty = true;
    private static Map<UUID, StoredPlayerPosition> previousPositions = Map.of();

    private ServerTracker() {
    }

    public static void markConfigDirty() {
        configDirty = true;
    }

    public static void reset() {
        previousPositions = Map.of();
        tickCounter = 0;
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerValues config = PlayerLocatorConfig.getServerValues();
        if (config.sendServerConfig()) {
            NetworkHandler.sendTo(player2, new ServerConfigPacket(config));
        }
        ServerTracker.fullResend(player2);
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        int interval;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        if (players.isEmpty()) {
            return;
        }
        ServerValues config = PlayerLocatorConfig.getServerValues();
        if (!config.enabled()) {
            if (configDirty && config.sendServerConfig()) {
                ServerTracker.broadcastConfig(players, config);
                configDirty = false;
            }
            previousPositions = Map.of();
            return;
        }
        if (configDirty && config.sendServerConfig()) {
            ServerTracker.broadcastConfig(players, config);
            configDirty = false;
        }
        if (tickCounter++ < (interval = Math.max(0, config.ticksBetweenUpdates()))) {
            return;
        }
        tickCounter = 0;
        Map<UUID, StoredPlayerPosition> currentPositions = ServerTracker.collectPositions(server, config);
        for (ServerPlayer observer : players) {
            boolean fullReset;
            UUID uuid;
            StoredPlayerPosition previousObserver = previousPositions.get(observer.m_20148_());
            StoredPlayerPosition currentObserver = currentPositions.get(observer.m_20148_());
            if (currentObserver == null) continue;
            ArrayList<RelativePlayerLocation> updates = new ArrayList<RelativePlayerLocation>();
            HashSet<UUID> removals = new HashSet<UUID>();
            for (Map.Entry<UUID, StoredPlayerPosition> entry : previousPositions.entrySet()) {
                double previousDistance;
                uuid = entry.getKey();
                if (uuid.equals(observer.m_20148_())) continue;
                StoredPlayerPosition previousTarget = entry.getValue();
                StoredPlayerPosition currentTarget = currentPositions.get(uuid);
                if (currentTarget == null || previousTarget.level != observer.m_9236_()) {
                    removals.add(uuid);
                    continue;
                }
                if (previousObserver != null && previousObserver.level != observer.m_9236_()) {
                    removals.add(uuid);
                    continue;
                }
                if (config.maxDistance() <= 0 || currentTarget.level != observer.m_9236_()) continue;
                double d = previousDistance = previousObserver != null ? previousObserver.position.m_82554_(previousTarget.position) : 0.0;
                double currentDistance = currentObserver.position.m_82554_(currentTarget.position);
                if (!(currentDistance > (double)config.maxDistance()) || !(previousDistance <= (double)config.maxDistance())) continue;
                removals.add(uuid);
            }
            for (Map.Entry<UUID, StoredPlayerPosition> entry : currentPositions.entrySet()) {
                uuid = entry.getKey();
                if (uuid.equals(observer.m_20148_())) continue;
                StoredPlayerPosition currentTarget = entry.getValue();
                if (currentTarget.level != observer.m_9236_()) continue;
                double distance = currentObserver.position.m_82554_(currentTarget.position);
                if (config.maxDistance() > 0 && distance > (double)config.maxDistance()) continue;
                StoredPlayerPosition previousTarget = previousPositions.get(uuid);
                RelativePlayerLocation currentLocation = ServerTracker.createRelativeLocation(uuid, currentObserver, currentTarget, config);
                RelativePlayerLocation previousLocation = null;
                if (previousObserver != null && previousTarget != null && previousTarget.level == previousObserver.level) {
                    previousLocation = ServerTracker.createRelativeLocation(uuid, previousObserver, previousTarget, config);
                }
                if (currentLocation.equals(previousLocation)) continue;
                updates.add(currentLocation);
            }
            boolean bl = fullReset = previousObserver != null && previousObserver.level != observer.m_9236_();
            if (updates.isEmpty() && removals.isEmpty() && !fullReset) continue;
            NetworkHandler.sendTo(observer, new LocatorDataPacket(updates, new ArrayList<UUID>(removals), fullReset));
        }
        previousPositions = currentPositions;
    }

    public static void fullResend(ServerPlayer player) {
        ServerValues config = PlayerLocatorConfig.getServerValues();
        ArrayList<RelativePlayerLocation> positions = new ArrayList<RelativePlayerLocation>();
        StoredPlayerPosition self = new StoredPlayerPosition(player, config);
        for (ServerPlayer other : player.m_284548_().m_6907_()) {
            if (other == player) continue;
            StoredPlayerPosition target = new StoredPlayerPosition(other, config);
            if (self.level != target.level || config.maxDistance() > 0 && self.position.m_82554_(target.position) > (double)config.maxDistance()) continue;
            positions.add(ServerTracker.createRelativeLocation(other.m_20148_(), self, target, config));
        }
        NetworkHandler.sendTo(player, new LocatorDataPacket(config.enabled() ? positions : List.of(), List.of(), true));
    }

    public static void fullResend(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            ServerTracker.fullResend(player);
        }
    }

    public static void sendFakePlayers(ServerPlayer player) {
        Random random = new Random();
        ArrayList<RelativePlayerLocation> locations = new ArrayList<RelativePlayerLocation>();
        for (int i = 0; i < 5; ++i) {
            Vector3f direction = new Vector3f(random.nextFloat(), random.nextFloat() * 0.75f, random.nextFloat());
            locations.add(new RelativePlayerLocation(UUID.randomUUID(), direction, random.nextFloat() * 750.0f, ColorUtils.uuidToColor(UUID.randomUUID())));
        }
        NetworkHandler.sendTo(player, new LocatorDataPacket(locations, List.of(), false));
    }

    private static void broadcastConfig(List<ServerPlayer> players, ServerValues values) {
        ServerConfigPacket packet = new ServerConfigPacket(values);
        for (ServerPlayer player : players) {
            NetworkHandler.sendTo(player, packet);
        }
    }

    private static Map<UUID, StoredPlayerPosition> collectPositions(MinecraftServer server, ServerValues config) {
        HashMap<UUID, StoredPlayerPosition> map = new HashMap<UUID, StoredPlayerPosition>();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (ServerTracker.shouldHide(player, config)) continue;
            map.put(player.m_20148_(), new StoredPlayerPosition(player, config));
        }
        return map;
    }

    private static boolean shouldHide(ServerPlayer player, ServerValues config) {
        BlockItem block;
        Item item;
        if (config.sneakingHides() && player.m_6144_()) {
            return true;
        }
        if (config.invisibilityHides() && player.m_21023_(MobEffects.f_19609_)) {
            return true;
        }
        if (player.m_5833_()) {
            return true;
        }
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (head.m_41619_()) {
            return false;
        }
        if (config.pumpkinHides() && head.m_150930_(Items.f_42047_)) {
            return true;
        }
        if (config.mobHeadsHide() && head.m_204117_(PlayerLocatorTags.HIDING_EQUIPMENT)) {
            return true;
        }
        return config.mobHeadsHide() && (item = head.m_41720_()) instanceof BlockItem && (block = (BlockItem)item).m_40614_() instanceof SkullBlock;
    }

    private static RelativePlayerLocation createRelativeLocation(UUID uuid, StoredPlayerPosition self, StoredPlayerPosition other, ServerValues config) {
        Vec3 delta = other.position.m_82546_(self.position).m_82541_();
        float precision = (float)config.directionPrecision();
        delta = new Vec3((double)((float)Math.round(delta.f_82479_ * (double)precision) / precision), (double)((float)Math.round(delta.f_82480_ * (double)precision) / precision), (double)((float)Math.round(delta.f_82481_ * (double)precision) / precision));
        float distance = 0.0f;
        if (config.sendDistance()) {
            double rawDistance = self.position.m_82554_(other.position);
            distance = (float)(rawDistance < 200.0 ? rawDistance : (double)Math.round(rawDistance / 50.0) * 50.0);
        }
        Vector3f direction = new Vector3f((float)delta.f_82479_, (float)delta.f_82480_, (float)delta.f_82481_);
        return new RelativePlayerLocation(uuid, direction, distance, other.color);
    }

    private static int resolveColor(ServerPlayer player, ServerValues config) {
        return switch (config.colorMode()) {
            default -> throw new IncompatibleClassChangeError();
            case ColorMode.UUID -> ColorUtils.uuidToColor(player.m_20148_());
            case ColorMode.TEAM_COLOR -> {
                Integer teamColor;
                if (player.m_5647_() != null && (teamColor = player.m_5647_().m_7414_().m_126665_()) != null) {
                    yield teamColor;
                }
                yield ColorUtils.uuidToColor(player.m_20148_());
            }
            case ColorMode.CONSTANT -> config.constantColor();
            case ColorMode.CUSTOM -> {
                PlayerData data = PlayerDataState.get(player.f_8924_).get(player.m_20148_());
                yield data.customColor();
            }
        };
    }

    private record StoredPlayerPosition(Vec3 position, ServerLevel level, int color) {
        StoredPlayerPosition(ServerPlayer player, ServerValues config) {
            this(player.m_20182_(), player.m_284548_(), ServerTracker.resolveColor(player, config));
        }
    }
}

