/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.network;

import com.myangel.playerlocatorplus.client.ClientTracker;
import com.myangel.playerlocatorplus.network.RelativePlayerLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record LocatorDataPacket(List<RelativePlayerLocation> locationUpdates, List<UUID> removeUuids, boolean fullReset) {
    public static void encode(LocatorDataPacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.locationUpdates.size());
        for (RelativePlayerLocation update : packet.locationUpdates) {
            update.write(buf);
        }
        buf.m_130130_(packet.removeUuids.size());
        for (UUID uuid : packet.removeUuids) {
            buf.m_130077_(uuid);
        }
        buf.writeBoolean(packet.fullReset);
    }

    public static LocatorDataPacket decode(FriendlyByteBuf buf) {
        int updateCount = buf.m_130242_();
        ArrayList<RelativePlayerLocation> updates = new ArrayList<RelativePlayerLocation>(updateCount);
        for (int i = 0; i < updateCount; ++i) {
            updates.add(RelativePlayerLocation.read(buf));
        }
        int removeCount = buf.m_130242_();
        ArrayList<UUID> remove = new ArrayList<UUID>(removeCount);
        for (int i = 0; i < removeCount; ++i) {
            remove.add(buf.m_130259_());
        }
        boolean fullReset = buf.readBoolean();
        return new LocatorDataPacket(updates, remove, fullReset);
    }

    public static void handle(LocatorDataPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> ClientTracker.handleLocations(packet));
        ctx.setPacketHandled(true);
    }
}

