/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.myangel.playerlocatorplus.client.Animatable;
import com.myangel.playerlocatorplus.client.ClientConfigState;
import com.myangel.playerlocatorplus.client.EffectiveClientConfig;
import com.myangel.playerlocatorplus.client.MathUtils;
import com.myangel.playerlocatorplus.config.ClientValues;
import com.myangel.playerlocatorplus.config.PlayerLocatorConfig;
import com.myangel.playerlocatorplus.network.LocatorDataPacket;
import com.myangel.playerlocatorplus.network.RelativePlayerLocation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class ClientTracker {
    private static final ResourceLocation EXPERIENCE_BAR_BACKGROUND = new ResourceLocation("playerlocatorplusreforged", "textures/gui/sprites/hud/empty_bar.png");
    private static final ResourceLocation PLAYER_MARK = new ResourceLocation("playerlocatorplusreforged", "textures/gui/sprites/hud/player_mark.png");
    private static final ResourceLocation PLAYER_MARK_UP = new ResourceLocation("playerlocatorplusreforged", "textures/gui/sprites/hud/player_mark_up.png");
    private static final ResourceLocation PLAYER_MARK_DOWN = new ResourceLocation("playerlocatorplusreforged", "textures/gui/sprites/hud/player_mark_down.png");
    private static final ResourceLocation PLAYER_MARK_WHITE = new ResourceLocation("playerlocatorplusreforged", "textures/gui/sprites/hud/player_mark_white_outline.png");
    private static final int NAME_PLAQUE_PADDING_X = 4;
    private static final int NAME_PLAQUE_PADDING_Y = 2;
    private static final int NAME_PLAQUE_MARGIN = 2;
    private static final int NAME_PLAQUE_OVERLAP_THRESHOLD = 2;
    private static final float HUD_OFFSET_TOTAL = 14.0f;
    private static final Animatable HUD_OFFSET = new Animatable(0.0f);
    private static final Lock POSITION_LOCK = new ReentrantLock();
    private static final Map<UUID, RelativePlayerLocation> RELATIVE_POSITIONS = new HashMap<UUID, RelativePlayerLocation>();
    private static Vec3 lastUpdatePosition = Vec3.f_82478_;

    private ClientTracker() {
    }

    public static void init() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientTracker::registerOverlay);
        modBus.addListener(ClientTracker::onConfigEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientTracker::onClientDisconnect);
        MinecraftForge.EVENT_BUS.register((Object)new OverlayOffsetHandler());
        ClientConfigState.refreshLocal();
    }

    private static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "playerlocatorplusreforged", (gui, graphics, partialTick, width, height) -> ClientTracker.render(graphics, partialTick, width, height));
    }

    private static void onConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getSpec() == PlayerLocatorConfig.CLIENT_SPEC) {
            ClientConfigState.refreshLocal();
        }
    }

    private static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        POSITION_LOCK.lock();
        try {
            RELATIVE_POSITIONS.clear();
            lastUpdatePosition = Vec3.f_82478_;
        }
        finally {
            POSITION_LOCK.unlock();
        }
        ClientConfigState.clearServerConfig();
    }

    public static void handleLocations(LocatorDataPacket packet) {
        POSITION_LOCK.lock();
        try {
            if (packet.fullReset()) {
                RELATIVE_POSITIONS.clear();
            } else {
                for (UUID uuid : packet.removeUuids()) {
                    RELATIVE_POSITIONS.remove(uuid);
                }
            }
            for (RelativePlayerLocation update : packet.locationUpdates()) {
                RELATIVE_POSITIONS.put(update.playerUuid(), update);
            }
            Minecraft mc = Minecraft.m_91087_();
            lastUpdatePosition = mc.f_91074_ != null ? mc.f_91074_.m_20182_() : Vec3.f_82478_;
        }
        finally {
            POSITION_LOCK.unlock();
        }
    }

    public static float getCurrentHudOffset() {
        return HUD_OFFSET.getCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        boolean shouldHideWhenEmpty;
        Vec3 snapshotLastUpdate;
        Map<UUID, RelativePlayerLocation> snapshot;
        EffectiveClientConfig config = ClientConfigState.effective();
        if (!config.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ClientValues clientValues = config.client();
        if (!clientValues.visible()) {
            return;
        }
        POSITION_LOCK.lock();
        try {
            snapshot = Map.copyOf(RELATIVE_POSITIONS);
            snapshotLastUpdate = lastUpdatePosition;
            shouldHideWhenEmpty = RELATIVE_POSITIONS.isEmpty() && !clientValues.visibleEmpty();
        }
        finally {
            POSITION_LOCK.unlock();
        }
        if (shouldHideWhenEmpty) {
            return;
        }
        if (!ClientTracker.isHudVisible(mc, (Player)player, snapshot, clientValues.visibleEmpty())) {
            return;
        }
        int barWidth = 182;
        int baseX = screenWidth / 2 - 91;
        int baseY = screenHeight - 32 + 3;
        if (player.m_108634_() <= 0.0f && mc.f_91072_ != null && !mc.f_91072_.m_105288_()) {
            ClientTracker.blit(graphics, EXPERIENCE_BAR_BACKGROUND, baseX, baseY, barWidth, 5, -1);
        }
        ArrayList<NamePlaque> namePlaques = new ArrayList<NamePlaque>();
        boolean tabPressed = mc.f_91066_.f_92099_.m_90857_();
        ArrayList<Map.Entry<UUID, RelativePlayerLocation>> entries = new ArrayList<Map.Entry<UUID, RelativePlayerLocation>>(snapshot.entrySet());
        entries.sort(Comparator.comparingDouble(entry -> ((RelativePlayerLocation)entry.getValue()).distance()));
        for (Map.Entry entry2 : entries) {
            boolean showHeadIcon;
            RelativePlayerLocation location;
            UUID uuid = (UUID)entry2.getKey();
            Vec3 directionVec = ClientTracker.computeDirectionVector((Player)player, uuid, location = (RelativePlayerLocation)entry2.getValue(), snapshotLastUpdate, partialTick);
            if (directionVec == null) continue;
            double horizontalFov = MathUtils.calculateHorizontalFov(((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue(), screenWidth, screenHeight);
            Vec3 viewVec = player.m_20252_(partialTick);
            double relativeAngle = ClientTracker.angleBetween(directionVec.f_82479_, directionVec.f_82481_, viewVec.f_82479_, viewVec.f_82481_);
            double progress = (relativeAngle + horizontalFov / 2.0) / horizontalFov;
            if (Double.isNaN(progress) || progress < 0.0 || progress > 1.0) continue;
            int markerX = (int)((double)baseX + progress * (double)barWidth) - 4;
            float opacity = ClientTracker.computeMarkerOpacity(config, location.distance());
            int alpha = Mth.m_14045_((int)((int)(opacity * 255.0f)), (int)0, (int)255);
            int color = alpha << 24 | location.color() & 0xFFFFFF;
            Optional playerInfo = Optional.ofNullable(mc.m_91403_()).flatMap(connection -> Optional.ofNullable(connection.m_104949_(uuid)));
            boolean bl = showHeadIcon = clientValues.alwaysShowHeads() || clientValues.showHeadsOnTab() && tabPressed;
            if (playerInfo.isPresent() && showHeadIcon) {
                ClientTracker.blit(graphics, PLAYER_MARK_WHITE, markerX, baseY - 1, 7, 7, color);
                ClientTracker.drawPlayerHead(graphics, ((PlayerInfo)playerInfo.get()).m_105337_(), markerX + 1, baseY, 5);
            } else {
                ClientTracker.blit(graphics, PLAYER_MARK, markerX, baseY - 1, 7, 7, color);
            }
            if (clientValues.showHeight()) {
                double normalizedY = directionVec.m_82541_().f_82480_;
                int arrowColor = alpha << 24 | 0xFFFFFF;
                if (normalizedY > 0.5) {
                    ClientTracker.blit(graphics, PLAYER_MARK_UP, markerX + 1, baseY - 5, 5, 4, arrowColor);
                } else if (normalizedY < -0.5) {
                    ClientTracker.blit(graphics, PLAYER_MARK_DOWN, markerX + 1, baseY + 7, 5, 4, arrowColor);
                }
            }
            if (!playerInfo.isPresent() || !clientValues.showNamesOnTab() || !tabPressed) continue;
            namePlaques.add(new NamePlaque(markerX, ((PlayerInfo)playerInfo.get()).m_105312_().getName(), progress));
        }
        HUD_OFFSET.setTargetValue(tabPressed && clientValues.showNamesOnTab() && !namePlaques.isEmpty() ? 14.0f : 0.0f);
        HUD_OFFSET.updateValues(mc.m_91297_());
        float offset = HUD_OFFSET.getCurrentValue();
        float f = offset / 14.0f;
        if (!namePlaques.isEmpty() && f > 0.0f) {
            ClientTracker.renderNamePlaques(graphics, namePlaques, baseY, f, offset);
        }
    }

    private static boolean isHudVisible(Minecraft mc, Player player, Map<UUID, RelativePlayerLocation> snapshot, boolean visibleEmpty) {
        boolean anyOther;
        if (mc.f_91066_.f_92062_) {
            return false;
        }
        if (!visibleEmpty && snapshot.isEmpty() && mc.m_91403_() != null && !(anyOther = mc.m_91403_().m_105142_().stream().anyMatch(info -> !info.m_105312_().getId().equals(player.m_20148_())))) {
            return false;
        }
        return mc.f_91072_ == null || mc.f_91072_.m_105295_() != GameType.SPECTATOR || mc.f_91065_.m_93085_().m_94768_();
    }

    private static Vec3 computeDirectionVector(Player self, UUID targetUuid, RelativePlayerLocation location, Vec3 lastUpdatePos, float partialTick) {
        Player other = self.m_9236_().m_46003_(targetUuid);
        if (other != null) {
            Vec3 otherPos = other.m_20318_(partialTick);
            Vec3 selfPos = self.m_20318_(partialTick);
            return otherPos.m_82546_(selfPos);
        }
        if (location.distance() <= 0.0f) {
            return new Vec3((double)location.direction().x(), (double)location.direction().y(), (double)location.direction().z());
        }
        Vec3 projected = lastUpdatePos.m_82549_(new Vec3((double)location.direction().x(), (double)location.direction().y(), (double)location.direction().z()).m_82490_((double)location.distance()));
        Vec3 selfPos = self.m_20318_(partialTick);
        return projected.m_82546_(selfPos);
    }

    private static float computeMarkerOpacity(EffectiveClientConfig config, float distance) {
        ClientValues client = config.client();
        if (!client.fadeMarkers()) {
            return 1.0f;
        }
        double fadeStart = client.fadeStart();
        double fadeEnd = client.fadeEnd();
        if (fadeEnd <= fadeStart) {
            return 1.0f;
        }
        double dist = Mth.m_14008_((double)distance, (double)fadeStart, (double)fadeEnd);
        double progress = 1.0 - (dist - fadeStart) / (fadeEnd - fadeStart);
        double minOpacity = client.fadeEndOpacity();
        return (float)(minOpacity + (1.0 - minOpacity) * progress);
    }

    private static void renderNamePlaques(GuiGraphics graphics, List<NamePlaque> plaques, int barY, float fadeProgress, float offset) {
        int plaqueWidth;
        int textWidth;
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        List<NamePlaque> sorted = plaques.stream().sorted(Comparator.comparingDouble(p -> Math.abs(p.progress - 0.5))).toList();
        ArrayList<NamePlaque> visible = new ArrayList<NamePlaque>();
        for (NamePlaque plaque : sorted) {
            textWidth = font.m_92895_(plaque.playerName);
            plaqueWidth = textWidth + 8;
            int xStart = plaque.x - plaqueWidth / 2 + 4;
            int xEnd = xStart + plaqueWidth;
            boolean overlaps = visible.stream().anyMatch(other -> other.rangeStart() - 2 <= xEnd && other.rangeEnd() + 2 >= xStart);
            if (overlaps) continue;
            visible.add(plaque.withRange(xStart, xEnd));
        }
        for (NamePlaque plaque : visible) {
            textWidth = font.m_92895_(plaque.playerName);
            plaqueWidth = textWidth + 8;
            Objects.requireNonNull(font);
            int plaqueHeight = 9 + 4;
            int x = plaque.x - plaqueWidth / 2 + 4;
            int y = barY - plaqueHeight - 2;
            int bgAlpha = (int)(128.0f * fadeProgress);
            int textAlpha = (int)(255.0f * fadeProgress);
            if (bgAlpha > 0) {
                graphics.m_280509_(x, y, x + plaqueWidth, y + plaqueHeight, bgAlpha << 24);
            }
            if (textAlpha <= 3) continue;
            graphics.m_280056_(font, plaque.playerName, x + 4, y + 2, textAlpha << 24 | 0xFFFFFF, false);
        }
    }

    private static double angleBetween(double x1, double z1, double x2, double z2) {
        double angle1 = Math.atan2(z1, x1);
        double angle2 = Math.atan2(z2, x2);
        return Math.toDegrees(angle1 - angle2);
    }

    private static void blit(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height, int color) {
        float a = (float)(color >>> 24 & 0xFF) / 255.0f;
        float r = (float)(color >>> 16 & 0xFF) / 255.0f;
        float g = (float)(color >>> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void drawPlayerHead(GuiGraphics graphics, ResourceLocation texture, int x, int y, int size) {
        RenderSystem.enableBlend();
        graphics.m_280411_(texture, x, y, size, size, 8.0f, 8.0f, 8, 8, 64, 64);
        graphics.m_280411_(texture, x, y, size, size, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    private static final class OverlayOffsetHandler {
        private OverlayOffsetHandler() {
        }

        @SubscribeEvent
        public void onOverlayPre(RenderGuiOverlayEvent.Pre event) {
            float offset = ClientTracker.getCurrentHudOffset();
            if (offset <= 0.0f) {
                return;
            }
            ResourceLocation id = event.getOverlay().id();
            if (this.offsetTargets(id)) {
                event.getGuiGraphics().m_280168_().m_85836_();
                event.getGuiGraphics().m_280168_().m_252880_(0.0f, -offset, 0.0f);
            }
        }

        @SubscribeEvent
        public void onOverlayPost(RenderGuiOverlayEvent.Post event) {
            float offset = ClientTracker.getCurrentHudOffset();
            if (offset <= 0.0f) {
                return;
            }
            ResourceLocation id = event.getOverlay().id();
            if (this.offsetTargets(id)) {
                event.getGuiGraphics().m_280168_().m_85849_();
            }
        }

        private boolean offsetTargets(ResourceLocation id) {
            return id.equals((Object)VanillaGuiOverlay.PLAYER_HEALTH.id()) || id.equals((Object)VanillaGuiOverlay.FOOD_LEVEL.id()) || id.equals((Object)VanillaGuiOverlay.AIR_LEVEL.id()) || id.equals((Object)VanillaGuiOverlay.MOUNT_HEALTH.id());
        }
    }

    private record NamePlaque(int x, String playerName, double progress, int rangeStart, int rangeEnd) {
        NamePlaque(int x, String playerName, double progress) {
            this(x, playerName, progress, 0, 0);
        }

        NamePlaque withRange(int start, int end) {
            return new NamePlaque(this.x, this.playerName, this.progress, start, end);
        }
    }
}

