/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.registry;

import com.mrbysco.raided.registry.RaidedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RaidRegHelper<T extends Raider> {
    protected final String name;
    protected final RegistryObject<EntityType<? extends T>> entityType;
    protected final RegistryObject<Item> spawnEgg;
    protected RegistryObject<SoundEvent> AMBIENT;
    protected RegistryObject<SoundEvent> DEATH;
    protected RegistryObject<SoundEvent> HURT;
    protected RegistryObject<SoundEvent> CELEBRATE;
    protected RegistryObject<SoundEvent> CASTING;

    @NotNull
    public String getName() {
        return this.name;
    }

    public EntityType<? extends T> getEntityType() {
        return (EntityType)this.entityType.get();
    }

    public RegistryObject<Item> getSpawnEgg() {
        return this.spawnEgg;
    }

    public SoundEvent getAmbient() {
        return this.AMBIENT == null ? null : (SoundEvent)this.AMBIENT.get();
    }

    public SoundEvent getDeath() {
        return this.DEATH == null ? null : (SoundEvent)this.DEATH.get();
    }

    public SoundEvent getHurt() {
        return this.HURT == null ? null : (SoundEvent)this.HURT.get();
    }

    public SoundEvent getCelebrate() {
        return this.CELEBRATE == null ? null : (SoundEvent)this.CELEBRATE.get();
    }

    public SoundEvent getCasting() {
        return this.CASTING == null ? null : (SoundEvent)this.CASTING.get();
    }

    public RaidRegHelper(String name, EntityType.Builder<T> builder, int backgroundColor, int highlightColor, boolean casting) {
        this.name = name;
        this.entityType = RaidedRegistry.ENTITY_TYPES.register(name, () -> builder.m_20712_(name));
        this.spawnEgg = RaidedRegistry.ITEMS.register(name + "_spawn_egg", () -> new ForgeSpawnEggItem(this.entityType, backgroundColor, highlightColor, new Item.Properties()));
        this.AMBIENT = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".ambient", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("raided", "entity." + name + ".ambient")));
        this.DEATH = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".death", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("raided", "entity." + name + ".death")));
        this.HURT = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".hurt", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("raided", "entity." + name + ".hurt")));
        this.CELEBRATE = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".celebrate", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("raided", "entity." + name + ".celebrate")));
        if (casting) {
            this.CASTING = RaidedRegistry.SOUND_EVENTS.register("entity." + name + ".casting", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("raided", "entity." + name + ".casting")));
        }
    }

    public RaidRegHelper(String name, EntityType.Builder<T> builder, int backgroundColor, int highlightColor) {
        this(name, builder, backgroundColor, highlightColor, false);
    }
}

