/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.raided.entity.Incinerator;
import java.util.Arrays;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

public class IncineratorModel<T extends Incinerator>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private static final int STICK_COUNT = 4;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart leftArmLower;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart blazeHead;
    private final ModelPart tankRope1;
    private final ModelPart tankRope2;
    private final ModelPart[] blazeSticks;

    public IncineratorModel(ModelPart modelPart) {
        this.root = modelPart.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.body = this.root.m_171324_("body");
        this.leftArm = this.root.m_171324_("left_arm");
        this.leftArmLower = this.leftArm.m_171324_("left_arm_lower");
        this.rightArm = this.root.m_171324_("right_arm");
        this.leftLeg = this.root.m_171324_("left_leg");
        this.rightLeg = this.root.m_171324_("right_leg");
        ModelPart tank = this.root.m_171324_("tank");
        this.blazeHead = tank.m_171324_("blaze_head");
        this.tankRope1 = this.root.m_171324_("tank_rope1");
        this.tankRope2 = this.tankRope1.m_171324_("tank_rope2");
        this.blazeSticks = new ModelPart[4];
        Arrays.setAll(this.blazeSticks, index -> tank.m_171324_(IncineratorModel.getStickName(index)));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-27.0f, (float)0.0f));
        head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        head.m_171599_("cigar", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-0.5f, -0.5f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(28, 18).m_171488_(-7.0f, -27.0f, -3.5f, 14.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("layer", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-7.5f, -0.5f, -4.0f, 15.0f, 20.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-27.0f, (float)0.0f));
        body.m_171599_("gauge", CubeListBuilder.m_171558_().m_171514_(46, 42).m_171488_(-2.5f, -2.5f, -1.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)-21.5f, (float)-3.5f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(70, 27).m_171488_(0.0f, -2.0f, -3.5f, 5.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-25.0f, (float)0.0f));
        leftArm.m_171599_("left_arm_lower", CubeListBuilder.m_171558_().m_171514_(70, 54).m_171488_(-2.51f, 0.0f, -7.0f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.m_171599_("flamethrower1", CubeListBuilder.m_171558_().m_171514_(114, 32).m_171488_(-2.51f, 2.0f, 0.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.m_171599_("flamethrower2", CubeListBuilder.m_171558_().m_171514_(114, 47).m_171488_(-1.5f, 5.0f, 1.0f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.m_171599_("flamethrower3", CubeListBuilder.m_171558_().m_171514_(114, 60).m_171488_(-1.0f, 8.0f, -4.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)6.0f, (float)3.5f));
        leftArm.m_171599_("flamethrower4", CubeListBuilder.m_171558_().m_171514_(114, 66).m_171488_(2.49f, 3.0f, 1.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)6.0f, (float)3.5f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)-25.0f, (float)0.0f));
        rightArm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(70, 27).m_171488_(-5.0f, -3.0f, -3.5f, 5.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        rightArm.m_171599_("right_arm_lower", CubeListBuilder.m_171558_().m_171514_(70, 54).m_171488_(-2.49f, 0.0f, -7.0f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)6.0f, (float)3.5f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)-10.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-3.5f, 0.0f, -3.5f, 7.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)-10.0f, (float)0.0f));
        PartDefinition tank = root.m_171599_("tank", CubeListBuilder.m_171558_().m_171514_(94, 0).m_171488_(-8.0f, -8.0f, 0.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)4.5f));
        tank.m_171599_("tank2", CubeListBuilder.m_171558_().m_171514_(94, 32).m_171488_(0.0f, -4.0f, -4.0f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)8.0f));
        tank.m_171599_("tank3", CubeListBuilder.m_171558_().m_171514_(94, 48).m_171488_(-2.0f, -4.0f, -4.0f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.0f, (float)0.0f, (float)8.0f));
        tank.m_171599_("tank4", CubeListBuilder.m_171558_().m_171514_(94, 64).m_171488_(-1.0f, -4.0f, -3.0f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.0f, (float)-3.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        tank.m_171599_("blaze_head", CubeListBuilder.m_171558_().m_171514_(158, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)8.0f));
        PartDefinition tankRope1 = root.m_171599_("tank_rope1", CubeListBuilder.m_171558_().m_171514_(114, 72).m_171488_(0.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)11.0f, (float)-16.0f, (float)12.5f));
        tankRope1.m_171599_("tank_rope2", CubeListBuilder.m_171558_().m_171514_(114, 72).m_171488_(0.0f, -1.0f, -2.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)1.0f));
        CubeListBuilder stickCube = CubeListBuilder.m_171558_().m_171514_(158, 16).m_171481_(-1.0f, -4.0f, 6.0f, 2.0f, 8.0f, 2.0f);
        for (int i = 0; i < 4; ++i) {
            tank.m_171599_(IncineratorModel.getStickName(i), stickCube, PartPose.m_171419_((float)0.0f, (float)0.0f, (float)8.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    private static String getStickName(int index) {
        return "stick" + index;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = entityIn.m_6844_(EquipmentSlot.HEAD);
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        if (itemstack.m_41619_()) {
            this.leftArm.f_104203_ = 0.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            if (this.f_102608_ > -9990.0f) {
                this.holdingMelee();
            }
            this.rightArm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f;
            this.rightArm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
            this.leftArm.f_104203_ -= this.degToRad(15.0f);
            this.leftArm.f_104203_ = -this.degToRad(30.0f);
            this.leftArm.f_104204_ = 0.0f;
            this.tankRope1.f_104204_ = this.degToRad(45.0f);
            this.tankRope1.f_104205_ = this.degToRad(90.0f);
            this.tankRope2.f_104204_ = this.degToRad(90.0f);
        }
        if (((Incinerator)((Object)entityIn)).isThrowing()) {
            this.animationThrow();
        }
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.leftLeg.f_104204_ = 0.0f;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104205_ = 0.0f;
        this.rightLeg.f_104205_ = 0.0f;
        float f = ageInTicks * (float)Math.PI * -0.1f;
        for (int i = 0; i < 4; ++i) {
            this.blazeSticks[i].f_104201_ = 2.0f + Mth.m_14089_((float)(((float)(i * 2) + ageInTicks) * 0.25f));
            this.blazeSticks[i].f_104200_ = Mth.m_14089_((float)f) * 6.0f;
            this.blazeSticks[i].f_104202_ = Mth.m_14031_((float)f) * 6.0f;
            f += 1.0f;
        }
        this.blazeHead.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.blazeHead.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (entityIn.m_20159_()) {
            this.rightLeg.f_104203_ += -0.62831855f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = 0.31415927f;
            this.leftLeg.f_104205_ = 0.07853982f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = -0.31415927f;
            this.rightLeg.f_104205_ = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.leftArm.f_104203_ = (float)((double)this.leftArm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.leftArm.f_104203_ += this.body.f_104204_ * 2.0f;
        this.leftArm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.leftArm.f_104204_ = -this.degToRad(30.0f);
        this.leftArmLower.f_104203_ = -this.degToRad(60.0f);
        this.tankRope1.f_104204_ = -this.degToRad(60.0f);
        this.tankRope1.f_104205_ = -this.degToRad(90.0f);
        this.tankRope2.f_104204_ = -this.degToRad(60.0f);
    }

    protected float degToRad(float degrees) {
        return degrees * (float)Math.PI / 180.0f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).m_104299_(poseStack);
    }
}

