/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.ingredients;

import com.google.gson.JsonObject;
import dev.xkmc.l2library.serial.ingredients.BaseIngredient;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

@SerialClass
public class EnchantmentIngredient
extends BaseIngredient<EnchantmentIngredient> {
    public static final BaseIngredient.Serializer<EnchantmentIngredient> INSTANCE = new BaseIngredient.Serializer<EnchantmentIngredient>(EnchantmentIngredient.class, new ResourceLocation("l2library", "enchantment"));
    @SerialClass.SerialField
    public Enchantment enchantment;
    @SerialClass.SerialField
    public int min_level;

    @Deprecated
    public EnchantmentIngredient() {
    }

    public EnchantmentIngredient(Enchantment enchantment, int minLevel) {
        super(Stream.of(new EnchValue(enchantment, minLevel)));
        this.enchantment = enchantment;
        this.min_level = minLevel;
    }

    @Override
    protected EnchantmentIngredient validate() {
        return new EnchantmentIngredient(this.enchantment, this.min_level);
    }

    @Override
    public boolean test(ItemStack stack) {
        return EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(this.enchantment, 0) >= this.min_level;
    }

    @Override
    public BaseIngredient.Serializer<EnchantmentIngredient> getSerializer() {
        return INSTANCE;
    }

    private record EnchValue(Enchantment ench, int min) implements Ingredient.Value
    {
        public Collection<ItemStack> m_6223_() {
            return IntStream.range(this.min, this.ench.m_6586_() + 1).mapToObj(i -> EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(this.ench, i))).toList();
        }

        public JsonObject m_6544_() {
            throw new IllegalStateException("This value should not be serialized as such");
        }
    }
}

