/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.conditions;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public record DoubleValueCondition(String path, ArrayList<String> line, double low, double high) implements ICondition
{
    public static final ResourceLocation ID = new ResourceLocation("l2library", "double_config");

    public static DoubleValueCondition of(String file, ForgeConfigSpec.ConfigValue<Double> config, double low, double high) {
        return new DoubleValueCondition(file, new ArrayList<String>(config.getPath()), low, high);
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        Double val;
        ModConfig file = (ModConfig)ConfigTracker.INSTANCE.fileMap().get(this.path);
        if (file == null) {
            return false;
        }
        Object line = file.getConfigData().get(this.line());
        if (line == null) {
            return false;
        }
        return line instanceof Double && this.low <= (val = (Double)line) && val <= this.high;
    }
}

