/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.ITickableElement;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.style.IStyled;
import com.minelittlepony.common.client.gui.style.Style;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Button
extends AbstractButton
implements IBounded,
ITextContext,
IStyled<Button>,
ITickableElement {
    private Style style = new Style();
    private final Bounds bounds;
    private static final Consumer<Button> NONE = v -> {};
    @NotNull
    private Consumer<Button> action = NONE;
    @NotNull
    private Consumer<Button> update = NONE;
    @Nullable
    private Tooltip prevTooltip;

    public Button(int x, int y) {
        this(x, y, 200, 20);
    }

    public Button(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.f_237098_);
        this.bounds = new Bounds(y, x, width, height);
    }

    public Button onClick(@NotNull Consumer<? extends Button> callback) {
        this.action = Objects.requireNonNull(callback);
        return this;
    }

    public Button onUpdate(@NotNull Consumer<? extends Button> callback) {
        this.update = Objects.requireNonNull(callback);
        return this;
    }

    public Button setEnabled(boolean enable) {
        this.f_93623_ = enable;
        return this;
    }

    public Button setVisible(boolean visible) {
        this.f_93624_ = visible;
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public Button setStyle(Style style) {
        this.style = style;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.bounds.copy(bounds);
        this.m_252865_(bounds.left);
        this.m_253211_(bounds.top);
        this.m_93674_(bounds.width);
        this.setHeight(bounds.height);
    }

    public void m_252865_(int x) {
        this.bounds.left = x;
        super.m_252865_(x);
    }

    public void m_253211_(int y) {
        this.bounds.top = y;
        super.m_253211_(y);
    }

    public void m_93674_(int width) {
        this.bounds.width = width;
        super.m_93674_(width);
    }

    public void setHeight(int height) {
        this.bounds.height = height;
        this.f_93619_ = height;
    }

    public void m_168797_(NarrationElementOutput narrationMsg) {
        this.getStyle().getTooltip().ifPresent(tooltip -> tooltip.m_142291_(narrationMsg));
    }

    public void m_5691_() {
        this.action.accept(this);
    }

    @Override
    public void tick() {
        this.update.accept(this);
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.m_5953_(mouseX, mouseY);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && this.getBounds().contains(mouseX, mouseY);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float tickDelta) {
        if (!this.f_93624_) {
            return;
        }
        this.getStyle().getTooltip().ifPresentOrElse(tooltip -> {
            if (tooltip != this.prevTooltip) {
                this.prevTooltip = tooltip;
                this.m_257544_(tooltip.toTooltip());
            }
        }, () -> this.m_257544_(null));
        super.m_88315_(context, mouseX, mouseY, tickDelta);
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float tickDelta) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.renderButtonBlit(context, this.m_252754_(), this.m_252907_(), this.m_274533_(), this.m_5711_(), this.f_93619_);
        this.renderBackground(context, mc, mouseX, mouseY);
        this.m_93666_(this.getStyle().getText());
        this.drawIcon(context, mouseX, mouseY, tickDelta);
        int foreColor = this.getStyle().getColor();
        if (!this.f_93623_) {
            foreColor = 0xA0A0A0;
        } else if (this.m_274382_()) {
            foreColor = 0xFFFFA0;
        }
        this.renderForground(context, mc, mouseX, mouseY, foreColor | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    protected ClientTooltipPositioner m_262860_() {
        ClientTooltipPositioner original = super.m_262860_();
        return (screenWidth, screenHeight, x, y, width, height) -> {
            Vector2ic pos = original.m_262814_(screenWidth, screenHeight, x, y, width, height);
            return new Vector2i(pos.x() + this.getStyle().toolTipX, pos.y() + this.getStyle().toolTipY);
        };
    }

    protected void drawIcon(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        if (this.getStyle().hasIcon()) {
            this.getStyle().getIcon().render(context, this.m_252754_(), this.m_252907_(), mouseX, mouseY, partialTicks);
        }
    }

    protected void renderForground(GuiGraphics context, Minecraft mc, int mouseX, int mouseY, int foreColor) {
        this.m_280139_(context, mc.f_91062_, foreColor);
    }

    protected void renderBackground(GuiGraphics context, Minecraft mc, int mouseX, int mouseY) {
    }

    public void m_280139_(GuiGraphics context, Font textRenderer, int color) {
        Bounds bounds = this.getBounds();
        int left = this.getStyle().getIcon().getBounds().right();
        Button.m_280138_((GuiGraphics)context, (Font)textRenderer, (Component)this.m_6035_(), (int)(bounds.left + left), (int)bounds.top, (int)(bounds.right() - 2), (int)bounds.bottom(), (int)color);
    }

    protected final void renderButtonBlit(GuiGraphics context, int x, int y, int state, int blockWidth, int blockHeight) {
        context.m_280027_(f_93617_, x, y, blockWidth, blockHeight, 20, 4, 200, 20, 0, state);
    }
}

