/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.config;

import folk.sisby.kaleido.api.WrappedConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.IntegerRange;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueList;
import folk.sisby.kaleido.lib.quiltconfig.impl.Comments;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.config.SystemMode;
import java.util.List;

public class SurveyorConfig
extends WrappedConfig {
    @Comments(value={@Comment(value={"Terrain system - records layers of blocks and biomes for maps to render"}), @Comment(value={"DISABLED prevents loading, FROZEN loads but prevents updates, DYNAMIC loads with addons or on servers, ENABLED always loads"})})
    public SystemMode terrain = SystemMode.DYNAMIC;
    @Comments(value={@Comment(value={"Structure system - records structure identifiers and piece data for specialized maps and utilities to render"}), @Comment(value={"DISABLED prevents loading, FROZEN loads but prevents updates, DYNAMIC loads with addons or on servers, ENABLED always loads"})})
    public SystemMode structures = SystemMode.DYNAMIC;
    @Comments(value={@Comment(value={"Landmark system - a generic record of both player-owned waypoints and server-owned POIs, accessible via API"}), @Comment(value={"DISABLED prevents loading, FROZEN loads but prevents updates, DYNAMIC loads with addons or on servers, ENABLED always loads"})})
    public SystemMode landmarks = SystemMode.DYNAMIC;
    @Comments(value={@Comment(value={"Logs structure discovery to the action bar."}), @Comment(value={"E.g. 'Discovered Village Plains at [91, 63, -54]'"})})
    public boolean discoveryMessages = false;
    @Comments(value={@Comment(value={"Force-enables the following commands."}), @Comment(value={"waypoints/landmarks raw | prints the raw SNBT of a landmark"})})
    public boolean debugCommands = false;
    @Comments(value={@Comment(value={"Ignores chunk changes that don't affect the amount of air in the chunk"}), @Comment(value={"Saves on performance, a little inaccurate sometimes."})})
    public boolean lazyClientUpdating = true;
    @Comments(value={@Comment(value={"Ignores known landmarks when syncing landmarks to the client"}), @Comment(value={"A temporary fix until landmarks have some kind of revision counter"})})
    public boolean forceUpdateLandmarks = true;
    public Networking networking = new Networking();
    public Builtins builtins = new Builtins();

    public static final class Networking
    implements WrappedConfig.Section {
        @Comments(value={@Comment(value={"[Server] Whether to place every player in a single share group"}), @Comment(value={"Disables /surveyor share and /surveyor unshare"})})
        public boolean globalSharing = false;
        @Comments(value={@Comment(value={"How much terrain data to send to clients"}), @Comment(value={"SERVER sends server-known data, GROUP sends group-known data, SOLO sends player-known data, NONE sends no data"})})
        public NetworkMode terrain = NetworkMode.GROUP;
        @Comments(value={@Comment(value={"How much structure data to send to clients"}), @Comment(value={"SERVER sends server-known data, GROUP sends group-known data, SOLO sends player-known data, NONE sends no data"}), @Comment(value={"When NONE, clients will never see structures"})})
        public NetworkMode structures = NetworkMode.GROUP;
        @Comments(value={@Comment(value={"Which landmarks to sync between client and server"}), @Comment(value={"SERVER sync server-known landmarks, GROUP sends group-known landmarks, SOLO sends player-known landmarks, NONE sends no landmarks"})})
        public NetworkMode landmarks = NetworkMode.GROUP;
        @Comments(value={@Comment(value={"Which waypoints (player-created landmarks) to sync between client and server"}), @Comment(value={"When SERVER, players can see (but not edit) all waypoints, including potentially offensive names"}), @Comment(value={"When GROUP, players can see (but not edit) waypoints created by players in their share group"}), @Comment(value={"When SOLO, player-created waypoints will be stored on the server as a backup"}), @Comment(value={"When NONE, waypoint data will never be synced (e.g. for privacy)"})})
        public NetworkMode waypoints = NetworkMode.GROUP;
        @Comments(value={@Comment(value={"[Server] How much player position data to send to clients"}), @Comment(value={"SERVER sends all players positions, GROUP sends just group players, SOLO sends nothing, NONE sends nothing"}), @Comment(value={"Players will only see the offline positions of their group members, or players who disconnected while they were online."})})
        public NetworkMode positions = NetworkMode.SERVER;
        @Comment(value={"[Server] Ticks per terrain region load for batch update - lower is more frequent"})
        @IntegerRange(min=1L, max=200L)
        public int terrainTicks = 20;
        @Comment(value={"[Server] Ticks per position update - lower is more frequent"})
        @IntegerRange(min=1L, max=200L)
        public int positionTicks = 1;
    }

    public static final class Builtins
    implements WrappedConfig.Section {
        @Comment(value={"Which block entities to preserve data for when creating block landmarks."})
        public List<String> allowedBlockEntities = ValueList.create((Object)"", (Object[])new String[]{"minecraft:banner"});
        @Comment(value={"Which points of interest to automatically add block landmarks for."})
        public List<String> poiLandmarks = ValueList.create((Object)"", (Object[])new String[]{"minecraft:lodestone"});
        @Comments(value={@Comment(value={"Whether to automatically add specialised nether portal POI landmarks."}), @Comment(value={"Creates one landmark for each nether portal, instead of one per portal block."})})
        public boolean netherPortalLandmarks = true;
        @Comment(value={"Whether to automatically add player death waypoints"})
        public boolean playerDeathWaypoints = true;
    }
}

