/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorCommands;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SurveyorClientCommands {
    private static int getLandmarks(WorldSummary summary, SurveyorExploration exploration, Consumer<Component> feedback, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Map landmarks = summary.landmarks().asMap(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), SurveyorClient.getExploration());
        if (landmarks.isEmpty()) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"There are no landmarks in this world!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"World %s:".formatted(global ? "Landmarks" : "Waypoints"))));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)Component.m_237113_((String)"%s:".formatted(landmark.id().m_135827_())).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)landmark.id().m_135815_())).m_7220_((Component)(!landmark.components().contains(LandmarkComponentTypes.NAME) ? Component.m_130674_((String)"") : Component.m_237113_((String)": \"").m_7220_((Component)landmark.components().get(LandmarkComponentTypes.NAME).m_6881_().m_130938_(s -> s.m_178520_(landmark.components().contains(LandmarkComponentTypes.COLOR) ? 0xFFFFFF & landmark.components().get(LandmarkComponentTypes.COLOR) : ChatFormatting.GREEN.m_126665_()))).m_7220_((Component)Component.m_237113_((String)"\"")))));
        }
        return landmarks.size();
    }

    private static int viewLandmark(WorldSummary summary, Consumer<Component> feedback, ResourceLocation id, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"No landmark exists of that id!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id);
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)(landmark.owner().equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)": ")));
        landmark.toText().forEach(t -> feedback.accept((Component)SurveyorCommands.indent().m_7220_(t)));
        return 1;
    }

    private static int rawLandmark(WorldSummary summary, Consumer<Component> feedback, ResourceLocation id, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"No landmark exists of that id!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id);
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)(landmark.owner().equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237113_((String)landmark.toNbt().toString()).m_130940_(ChatFormatting.AQUA)));
        return 1;
    }

    private static int removeLandmark(WorldSummary summary, Level world, Consumer<Component> feedback, ResourceLocation type, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), type)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"No landmark exists of that id!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), type);
        summary.landmarks().remove(world, global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), type);
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"%s %s removed successfully!".formatted(landmark.owner().equals(WorldLandmarks.GLOBAL) ? "Landmark" : "Waypoint")).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int addBlockLandmark(WorldSummary summary, Level world, Consumer<Component> feedback, BlockPos pos, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        ResourceLocation id = Surveyor.id("block/%s/%s/%s".formatted(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        if (summary.landmarks().contains(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"A landmark with this ID already exists! Replacing...").m_130940_(ChatFormatting.YELLOW)));
        }
        summary.landmarks().put(world, Landmark.create(global ? WorldLandmarks.GLOBAL : SurveyorClient.getClientUuid(), id, builder -> LandmarkComponentTypes.forBlock(builder, (LevelAccessor)world, pos)));
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"Added new %s %s!".formatted(global ? "Landmark" : "Waypoint", id)).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    public static <T> T map(CommandContext<FabricClientCommandSource> context, SurveyorCommandExecutor<T> executor, boolean feedback) {
        LocalPlayer player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        SurveyorExploration exploration = SurveyorClient.getExploration();
        try {
            return executor.execute(WorldSummary.of((Level)((FabricClientCommandSource)context.getSource()).getWorld()), player, ((FabricClientCommandSource)context.getSource()).getWorld(), exploration, t -> ((FabricClientCommandSource)context.getSource()).sendFeedback(t));
        }
        catch (Exception e) {
            if (feedback) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((Component)Component.m_237113_((String)"Command failed! Check log for details.").m_130940_(ChatFormatting.RED));
            }
            if (feedback) {
                Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            }
            return null;
        }
    }

    public static int execute(CommandContext<FabricClientCommandSource> context, SurveyorCommandExecutor<Integer> executor) {
        return Objects.requireNonNullElse(SurveyorClientCommands.map(context, executor, true), 0);
    }

    private static CommandSourceStack sourceForPos(FabricClientCommandSource source) {
        return new CommandSourceStack(null, source.getPosition(), source.getRotation(), null, 0, null, null, null, source.getEntity());
    }

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"waypointsc").requires(c -> !c.getClient().m_91090_() && c.getClient().m_91403_().m_105146_().findNode(List.of("surveyor")) == null)).requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.getLandmarks(w, e, f, false)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"new").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.literal((String)"block").then(ClientCommandManager.argument((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.addBlockLandmark(w, (Level)sw, f, ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), false))))))).then(ClientCommandManager.literal((String)"view").then(ClientCommandManager.argument((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_((Iterable)SurveyorClientCommands.map((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> w.landmarks() == null ? new HashSet() : w.landmarks().asMap(SurveyorClient.getClientUuid(), p.m_20310_(2) ? null : e).keySet(), false), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.viewLandmark(w, f, (ResourceLocation)c.getArgument("id", ResourceLocation.class), false)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"raw").requires(c -> Surveyor.CONFIG.debugCommands)).then(ClientCommandManager.argument((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_((Iterable)SurveyorClientCommands.map((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> w.landmarks() == null ? new HashSet() : w.landmarks().asMap(SurveyorClient.getClientUuid(), p.m_20310_(2) ? null : e).keySet(), false), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.rawLandmark(w, f, (ResourceLocation)c.getArgument("id", ResourceLocation.class), false)))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_((Iterable)SurveyorClientCommands.map((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> w.landmarks() == null ? new HashSet() : w.landmarks().asMap(SurveyorClient.getClientUuid(), p.m_20310_(2) ? null : e).keySet(), false), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (w, p, sw, e, f) -> SurveyorClientCommands.removeLandmark(w, (Level)sw, f, (ResourceLocation)c.getArgument("id", ResourceLocation.class), false))))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(WorldSummary var1, LocalPlayer var2, ClientLevel var3, SurveyorExploration var4, Consumer<Component> var5);
    }
}

