/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.Sets;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.client.SurveyorNetworkHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.world.entity.player.Player;

public class NetworkHandlerSummary {
    private final ClientPacketListener handler;
    private final Map<UUID, PlayerSummary> offlineSummaries;

    public NetworkHandlerSummary(ClientPacketListener handler) {
        this.handler = handler;
        this.offlineSummaries = new HashMap<UUID, PlayerSummary>();
    }

    public static NetworkHandlerSummary of(ClientPacketListener handler) {
        return ((SurveyorNetworkHandler)handler).surveyor$getSummary();
    }

    public void mergeSummaries(Map<UUID, PlayerSummary> summaries) {
        this.offlineSummaries.putAll(summaries);
    }

    public void matchSummaries(Map<UUID, PlayerSummary> summaries) {
        this.offlineSummaries.clear();
        this.offlineSummaries.putAll(summaries);
    }

    public Map<UUID, PlayerSummary> players(Set<UUID> group) {
        HashMap<UUID, PlayerSummary> outMap = new HashMap<UUID, PlayerSummary>();
        for (UUID uuid : Sets.union(group, this.offlineSummaries.keySet())) {
            Player player = this.handler.m_105147_().m_46003_(uuid);
            if (player != null) {
                outMap.put(uuid, new PlayerSummary.PlayerEntitySummary(player));
                continue;
            }
            outMap.put(uuid, this.offlineSummaries.get(uuid));
        }
        return outMap;
    }
}

