/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentType;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.TextUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class SurveyorCommands {
    private static final Multimap<UUID, UUID> requests = HashMultimap.create();

    public static MutableComponent prefix() {
        return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED));
    }

    public static MutableComponent indent() {
        return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"|| ").m_130940_(ChatFormatting.DARK_RED));
    }

    private static void informGroup(ServerPlayer player, Set<PlayerSummary> group, Consumer<Component> feedback) {
        feedback.accept((Component)Component.m_237113_((String)"You're sharing your map with ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"%d".formatted(group.size() - 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).m_130940_(ChatFormatting.GOLD)));
        feedback.accept((Component)TextUtil.highlightStrings(group.stream().map(PlayerSummary::username).filter(u -> !u.equals(player.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.GOLD));
    }

    private static boolean playerMissing(@Nullable ServerPlayer player, Consumer<Component> feedback) {
        if (player == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"Can't run this command as a non-player!")));
            return true;
        }
        return false;
    }

    private static int informGlobal(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback) {
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The server has global sharing enabled!").m_130940_(ChatFormatting.YELLOW)));
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You can't leave or modify the global sharing group!").m_130940_(ChatFormatting.YELLOW)));
        if (SurveyorCommands.playerMissing(player, feedback)) {
            return 0;
        }
        SurveyorCommands.informGroup(player, ServerSummary.of(server).groupPlayers(Surveyor.getUuid(player), player.m_20194_()), feedback);
        return 0;
    }

    private static int info(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback) {
        Set<PlayerSummary> group = player == null ? null : ServerSummary.of(server).groupPlayers(Surveyor.getUuid(player), player.m_20194_());
        SurveyorExploration groupExploration = player == null ? null : SurveyorExploration.ofShared(player);
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        int chunks = exploration == null ? 0 : exploration.chunkCount();
        int structures = exploration == null ? 0 : exploration.structureCount();
        for (ServerLevel world : server.m_129785_()) {
            WorldLandmarks worldLandmarks = WorldSummary.of((Level)world).landmarks();
            if (worldLandmarks != null) {
                worldLandmarks.asMap(exploration).forEach((type, inner) -> inner.forEach((id, landmark) -> (landmark.owner().equals(WorldLandmarks.GLOBAL) ? landmarks : waypoints).add(landmark)));
                if (groupExploration != null) {
                    worldLandmarks.asMap(groupExploration).forEach((type, inner) -> inner.forEach((id, landmark) -> (landmark.owner().equals(WorldLandmarks.GLOBAL) ? groupLandmarks : groupWaypoints).add(landmark)));
                }
            }
            if (exploration != null) continue;
            WorldTerrainSummary terrainSummary = WorldSummary.of((Level)world).terrain();
            WorldStructureSummary structureSummary = WorldSummary.of((Level)world).structures();
            if (terrainSummary != null) {
                chunks += terrainSummary.bitSet(null).values().stream().mapToInt(BitSet::cardinality).sum();
            }
            if (structureSummary == null) continue;
            structures += structureSummary.keySet(null).size();
        }
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)(player == null ? "Surveyor Data Summary:" : "Map Exploration Summary:"))));
        feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)Component.m_237113_((String)(player == null ? "Mapped " : "You've explored ")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(chunks)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" total chunks!").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)(group == null || group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupExploration.chunkCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.AQUA)))));
        feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)Component.m_237113_((String)(player == null ? "Mapped " : "You've discovered ")).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(structures)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" structures!").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)(group == null || group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupExploration.structureCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.LIGHT_PURPLE)))));
        feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)Component.m_237113_((String)(player == null ? "Mapped " : "You've discovered ")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(landmarks.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" landmarks!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)(group == null || group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupLandmarks.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.GREEN)))));
        feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)Component.m_237113_((String)(player == null ? "Recorded " : "...and created ")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(waypoints.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" waypoints!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)(group == null || group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupWaypoints.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.GREEN)))));
        if (group != null && group.size() > 1) {
            SurveyorCommands.informGroup(player, group, feedback);
        }
        return 1;
    }

    private static int share(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, String username) {
        if (SurveyorCommands.playerMissing(player, feedback)) {
            return 0;
        }
        ServerSummary serverSummary = ServerSummary.of(server);
        ServerPlayer sharePlayer = server.m_6846_().m_11255_(username);
        if (sharePlayer == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"Can't find an online player named ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)username).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (sharePlayer == player) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You can't share map exploration with yourself!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (requests.containsEntry((Object)Surveyor.getUuid(player), (Object)Surveyor.getUuid(sharePlayer))) {
            if (serverSummary.groupSize(Surveyor.getUuid(player)) > 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) > 1) {
                feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You're in a group! leave your group first with:").m_130940_(ChatFormatting.YELLOW)));
                feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"/surveyor unshare").m_130940_(ChatFormatting.GOLD)));
                return 0;
            }
            requests.removeAll((Object)Surveyor.getUuid(player));
            ServerSummary.of(player.m_20194_()).joinGroup(Surveyor.getUuid(player), Surveyor.getUuid(sharePlayer), player.m_20194_());
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You're now sharing map exploration with ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).m_130940_(ChatFormatting.GREEN)));
            feedback.accept((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.m_20194_()).stream().map(PlayerSummary::username).filter(u -> !u.equals(player.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.GREEN));
            for (ServerPlayer friend : serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.m_20194_())) {
                friend.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" is now sharing their map with you.").m_130940_(ChatFormatting.AQUA)));
                friend.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You're now sharing map exploration with ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).m_130940_(ChatFormatting.AQUA)));
                friend.m_213846_((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.m_20194_()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.AQUA));
            }
            return 1;
        }
        if (!requests.containsEntry((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player))) {
            requests.put((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player));
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"Share request sent to ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)sharePlayer.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.GREEN)));
            sharePlayer.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" wants to share map exploration!").m_130940_(ChatFormatting.AQUA)));
            if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) <= 1) {
                feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"If accepted, you'll share your map exploration.").m_130940_(ChatFormatting.GREEN)));
                sharePlayer.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"To share your explored map area, enter:").m_130940_(ChatFormatting.AQUA)));
            } else if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1) {
                feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"If accepted, you'll share with their group of ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.GREEN)));
                sharePlayer.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"To share your group of ").m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)", enter:").m_130940_(ChatFormatting.AQUA)));
            } else {
                feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"If accepted, they'll share with your group of ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.GREEN)));
                sharePlayer.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"To share with their group of ").m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)", enter:").m_130940_(ChatFormatting.AQUA)));
            }
            sharePlayer.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"/surveyor share %s".formatted(player.m_36316_().getName())).m_130940_(ChatFormatting.GOLD)));
            return 1;
        }
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You've already sent this player a share request!").m_130940_(ChatFormatting.YELLOW)));
        return 0;
    }

    private static int unshare(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback) {
        if (SurveyorCommands.playerMissing(player, feedback)) {
            return 0;
        }
        ServerSummary serverSummary = ServerSummary.of(server);
        int shareNumber = serverSummary.groupSize(Surveyor.getUuid(player)) - 1;
        if (shareNumber == 0) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You're not sharing map exploration with anyone!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Set<ServerPlayer> friends = serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.m_20194_());
        ServerSummary.of(player.m_20194_()).leaveGroup(Surveyor.getUuid(player), player.m_20194_());
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"Stopped sharing map exploration with ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(shareNumber)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(shareNumber > 1 ? " players." : " player.")).m_130940_(ChatFormatting.GREEN)));
        for (ServerPlayer friend : friends) {
            int groupSize = serverSummary.groupSize(Surveyor.getUuid(friend)) - 1;
            friend.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" is no longer sharing with you.").m_130940_(ChatFormatting.AQUA)));
            friend.m_213846_((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You're now sharing map exploration with ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupSize)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(groupSize == 0 ? " players." : (groupSize > 1 ? " players:" : " player:"))).m_130940_(ChatFormatting.AQUA)));
            if (groupSize <= 0) continue;
            friend.m_213846_((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(friend), friend.m_20194_()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.AQUA));
        }
        return 1;
    }

    private static int getLandmarks(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, boolean global) {
        Object landmarks;
        LinkedHashMap<ResourceLocation, Collection<Landmark>> dimensionLandmarks = new LinkedHashMap<ResourceLocation, Collection<Landmark>>();
        boolean op = player == null || player.m_20310_(2);
        for (ServerLevel world : server.m_129785_()) {
            WorldSummary summary = WorldSummary.of((Level)world);
            if (summary.landmarks() == null) {
                feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
                return 0;
            }
            landmarks = summary.landmarks().asMap(op ? null : (Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player)));
            if (global) {
                if (!landmarks.containsKey(WorldLandmarks.GLOBAL)) continue;
                dimensionLandmarks.put(world.m_46472_().m_135782_(), landmarks.get(WorldLandmarks.GLOBAL).values());
                continue;
            }
            landmarks.remove(WorldLandmarks.GLOBAL);
            dimensionLandmarks.put(world.m_46472_().m_135782_(), landmarks.values().stream().flatMap(m -> m.values().stream()).toList());
        }
        int numLandmarks = dimensionLandmarks.values().stream().mapToInt(Collection::size).sum();
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"%s %d %s:".formatted(op ? "There are" : "You've discovered", numLandmarks, global ? "Landmarks" : "Waypoints"))));
        for (ResourceLocation dim : dimensionLandmarks.keySet()) {
            landmarks = (Collection)dimensionLandmarks.get(dim);
            if (!landmarks.isEmpty()) {
                feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)SurveyorCommands.indent()).m_7220_((Component)Component.m_237113_((String)"%s:".formatted(WordUtils.capitalize((String)dim.m_135815_().replaceAll("[/_-]", " "))))));
            }
            Iterator iterator = landmarks.iterator();
            while (iterator.hasNext()) {
                Landmark landmark = (Landmark)iterator.next();
                MutableComponent idText = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"%s:".formatted(landmark.id().m_135827_())).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)landmark.id().m_135815_()));
                Integer color = landmark.get(LandmarkComponentTypes.COLOR);
                String command = global ? "/landmarks view %s %s".formatted(dim, landmark.id()) : "/waypoints view %s %s%s".formatted(dim, landmark.id(), player != null && landmark.owner().equals(Surveyor.getUuid(player)) ? "" : " " + String.valueOf(landmark.owner()));
                feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)(player == null || global ? Component.m_237119_() : Component.m_237113_((String)"%s | ".formatted(Optional.ofNullable(ServerSummary.of(server).getPlayer(landmark.owner(), server)).map(PlayerSummary::username).orElse(landmark.owner().toString()))).m_130940_(ChatFormatting.GRAY))).m_7220_((Component)(player == null && landmark.contains(LandmarkComponentTypes.NAME) ? idText.m_6881_().m_130946_(" ") : Component.m_237119_())).m_7220_((Component)(landmark.contains(LandmarkComponentTypes.NAME) ? Component.m_237113_((String)"\"").m_7220_(landmark.get(LandmarkComponentTypes.NAME)).m_130946_("\"") : idText).m_6881_().m_130938_(arg_0 -> SurveyorCommands.lambda$getLandmarks$13(color, player, global, landmark, (Component)idText, command, arg_0))));
            }
        }
        return numLandmarks;
    }

    private static int viewLandmark(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, ServerLevel world, UUID owner, ResourceLocation id, boolean raw) {
        boolean cantModify;
        WorldSummary summary = WorldSummary.of((Level)world);
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"No landmark exists of that id!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        boolean bl = cantModify = player != null && !player.m_20310_(2) && !landmark.owner().equals(Surveyor.getUuid(player));
        String command = landmark.owner().equals(WorldLandmarks.GLOBAL) ? "/landmarks remove %s %s".formatted(world.m_46472_().m_135782_(), landmark.id()) : "/waypoints remove %s %s%s".formatted(world.m_46472_().m_135782_(), landmark.id(), player == null || !landmark.owner().equals(Surveyor.getUuid(player)) ? " " + String.valueOf(landmark.owner()) : "");
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)(cantModify ? Component.m_237119_() : Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"<").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"remove").m_130940_(ChatFormatting.AQUA).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)command).m_130940_(ChatFormatting.AQUA))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)))).m_7220_((Component)Component.m_237113_((String)">").m_130940_(ChatFormatting.GRAY)))));
        if (raw) {
            feedback.accept((Component)SurveyorCommands.indent().m_7220_((Component)Component.m_237113_((String)landmark.toNbt().toString())));
        } else {
            landmark.toText().forEach(t -> feedback.accept((Component)SurveyorCommands.indent().m_7220_(t)));
        }
        return 1;
    }

    private static int removeLandmark(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, ServerLevel world, UUID owner, ResourceLocation id) {
        WorldSummary summary = WorldSummary.of((Level)world);
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"No landmark exists of that id!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (Level)world, player)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You don't have permission to modify that landmark!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        summary.landmarks().remove((Level)world, owner, id);
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)" removed successfully!").m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int trimLandmark(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, ServerLevel world, UUID owner, ResourceLocation id, ResourceLocation componentType) {
        WorldSummary summary = WorldSummary.of((Level)world);
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"No landmark exists of that id!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (Level)world, player)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You don't have permission to modify that landmark!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        landmark.components().remove(LandmarkComponentType.getType(componentType));
        summary.landmarks().put((Level)world, landmark);
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)" trimmed successfully!").m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int appendColor(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, ServerLevel world, UUID owner, ResourceLocation id, String colorString) {
        WorldSummary summary = WorldSummary.of((Level)world);
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark landmark = summary.landmarks().get(owner, id);
        if (landmark == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"No landmark exists of that id!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!WorldLandmarks.canModify(landmark.owner(), (Level)world, player)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You don't have permission to modify that landmark!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        TextColor color = TextColor.m_131268_((String)colorString);
        if (color == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"Not a valid color! Use color names or hex codes").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        landmark.components().set(LandmarkComponentTypes.COLOR, color.m_131265_());
        summary.landmarks().put((Level)world, landmark);
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)(owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint ")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)" appended successfully!").m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int addBlockLandmark(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, ServerLevel world, UUID owner, BlockPos pos) {
        WorldSummary summary = WorldSummary.of((Level)world);
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (Level)world, player)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You don't have permission to add that landmark!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        ResourceLocation id = Surveyor.id("block/%s/%s/%s".formatted(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        if (summary.landmarks().contains(owner, id)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"A landmark with this ID already exists! Replacing...").m_130940_(ChatFormatting.YELLOW)));
        }
        summary.landmarks().put((Level)world, Landmark.create(owner, id, builder -> LandmarkComponentTypes.forBlock(builder, (LevelAccessor)world, pos)));
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)("Added new " + (owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint "))).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)"!").m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int addIdLandmark(MinecraftServer server, @Nullable ServerPlayer player, @Nullable SurveyorExploration exploration, Consumer<Component> feedback, ServerLevel world, UUID owner, ResourceLocation id, BlockPos pos, ItemInput stack, Component name, Component lore) {
        ItemStack icon;
        try {
            icon = stack.m_120980_(1, false);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        WorldSummary summary = WorldSummary.of((Level)world);
        if (summary.landmarks() == null) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!WorldLandmarks.canModify(owner, (Level)world, player)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"You don't have permission to add that landmark!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (summary.landmarks().contains(owner, id)) {
            feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"A landmark with this ID already exists! Replacing...").m_130940_(ChatFormatting.YELLOW)));
        }
        summary.landmarks().put((Level)world, Landmark.create(owner, id, builder -> builder.add(LandmarkComponentTypes.POS, pos).add(LandmarkComponentTypes.STACK, icon).add(LandmarkComponentTypes.NAME, name).add(LandmarkComponentTypes.LORE, lore == null ? null : List.of(lore))));
        feedback.accept((Component)SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)("Added new " + (owner.equals(WorldLandmarks.GLOBAL) ? "Landmark " : "Waypoint "))).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)id.toString())).m_7220_((Component)Component.m_237113_((String)"!").m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestLandmarks(CommandContext<CommandSourceStack> c, SuggestionsBuilder b, boolean global) {
        ServerLevel world;
        ServerPlayer player = ((CommandSourceStack)c.getSource()).m_230896_();
        if (player == null) {
            return b.buildFuture();
        }
        boolean op = player.m_20310_(2);
        SurveyorExploration exploration = op ? null : (Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player));
        try {
            world = DimensionArgument.m_88808_(c, (String)"dim");
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        WorldLandmarks landmarks = WorldSummary.of((Level)world).landmarks();
        if (landmarks == null) {
            return b.buildFuture();
        }
        return SharedSuggestionProvider.m_82926_(global ? landmarks.asMap(WorldLandmarks.GLOBAL, exploration).keySet() : landmarks.asMap(exploration).values().stream().flatMap(m -> m.keySet().stream()).toList(), (SuggestionsBuilder)b);
    }

    private static CompletableFuture<Suggestions> suggestOwners(CommandContext<CommandSourceStack> c, SuggestionsBuilder b) {
        ResourceLocation id;
        ServerLevel world;
        ServerPlayer player = ((CommandSourceStack)c.getSource()).m_230896_();
        if (player == null) {
            return b.buildFuture();
        }
        boolean op = player.m_20310_(2);
        SurveyorExploration exploration = op ? null : (Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player));
        try {
            world = DimensionArgument.m_88808_(c, (String)"dim");
            id = (ResourceLocation)c.getArgument("id", ResourceLocation.class);
        }
        catch (CommandSyntaxException e2) {
            throw new RuntimeException(e2);
        }
        WorldLandmarks landmarks = WorldSummary.of((Level)world).landmarks();
        if (landmarks == null) {
            return b.buildFuture();
        }
        return SharedSuggestionProvider.m_82970_(landmarks.asMap(exploration).entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey(id)).map(e -> ((UUID)e.getKey()).toString()).toList(), (SuggestionsBuilder)b);
    }

    public static <T> T map(CommandContext<CommandSourceStack> context, SurveyorCommandExecutor<T> executor, boolean feedback) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        SurveyorExploration exploration = player == null ? null : SurveyorExploration.of(player);
        try {
            return executor.execute(((CommandSourceStack)context.getSource()).m_81377_(), player, exploration, t -> ((CommandSourceStack)context.getSource()).m_288197_(() -> t, false));
        }
        catch (Exception e) {
            if (feedback) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"Command failed! Check log for details.").m_130940_(ChatFormatting.RED)), false);
            }
            if (feedback) {
                Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            }
            return null;
        }
    }

    public static int execute(CommandContext<CommandSourceStack> context, SurveyorCommandExecutor<Integer> executor) {
        return Objects.requireNonNullElse(SurveyorCommands.map(context, executor, true), 0);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"surveyor").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, SurveyorCommands::info))).then(Surveyor.CONFIG.networking.globalSharing ? Commands.m_82127_((String)"share").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, SurveyorCommands::informGlobal)) : Commands.m_82127_((String)"share").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11314_().stream().filter(p -> ((CommandSourceStack)c.getSource()).m_230896_() != p).map(p -> p.m_36316_().getName()), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> SurveyorCommands.share(s, p, e, f, (String)c.getArgument("player", String.class))))))).then(Surveyor.CONFIG.networking.globalSharing ? Commands.m_82127_((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, SurveyorCommands::informGlobal)) : Commands.m_82127_((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, SurveyorCommands::unshare))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> SurveyorCommands.getLandmarks(s, p, e, f, true)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"new").requires(c -> c.m_6761_(2) && Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.m_82127_((String)"block").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addBlockLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                return 0;
            }
            return SurveyorCommands.addBlockLandmark(s, p, e, f, p.m_284548_(), WorldLandmarks.GLOBAL, ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()));
        }))))).then(Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"icon", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"lore", (ArgumentType)ComponentArgument.m_87114_()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addIdLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (ResourceLocation)c.getArgument("id", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()), ItemArgument.m_120963_((CommandContext)c, (String)"icon"), Component.m_130674_((String)((String)c.getArgument("name", String.class))), (Component)c.getArgument("lore", Component.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"append").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).then(Commands.m_82127_((String)"surveyor:color").then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.greedyString()).suggests((c, s) -> SharedSuggestionProvider.m_82970_((Iterable)ChatFormatting.m_126653_((boolean)true, (boolean)false), (SuggestionsBuilder)s)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.appendColor(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (ResourceLocation)c.getArgument("id", ResourceLocation.class), (String)c.getArgument("color", String.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"trim").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).then(Commands.m_82129_((String)"component", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(LandmarkComponentType.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.trimLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (ResourceLocation)c.getArgument("id", ResourceLocation.class), (ResourceLocation)c.getArgument("component", ResourceLocation.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(Commands.m_82127_((String)"view").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (ResourceLocation)c.getArgument("id", ResourceLocation.class), false);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"raw").requires(c -> Surveyor.CONFIG.debugCommands)).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (ResourceLocation)c.getArgument("id", ResourceLocation.class), true);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(c -> c.m_6761_(2) && Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.removeLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), WorldLandmarks.GLOBAL, (ResourceLocation)c.getArgument("id", ResourceLocation.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"waypoints").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> SurveyorCommands.getLandmarks(s, p, e, f, false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"new").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.m_82127_((String)"block").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)UuidArgument.m_113850_()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.m_6761_(2))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addBlockLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), UuidArgument.m_113853_((CommandContext)c, (String)"owner"), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                    return 0;
                }
                return SurveyorCommands.addBlockLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                return 0;
            }
            return SurveyorCommands.addBlockLandmark(s, p, e, f, p.m_284548_(), Surveyor.getUuid(p), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()));
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"id").then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"icon", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"lore", (ArgumentType)ComponentArgument.m_87114_()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.addIdLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), UuidArgument.m_113853_((CommandContext)c, (String)"uuid"), (ResourceLocation)c.getArgument("id", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()), ItemArgument.m_120963_((CommandContext)c, (String)"icon"), Component.m_130674_((String)((String)c.getArgument("name", String.class))), (Component)c.getArgument("lore", Component.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))))))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"icon", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registryAccess)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"lore", (ArgumentType)ComponentArgument.m_87114_()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                    return 0;
                }
                return SurveyorCommands.addIdLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()), ItemArgument.m_120963_((CommandContext)c, (String)"icon"), Component.m_130674_((String)((String)c.getArgument("name", String.class))), (Component)c.getArgument("lore", Component.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"append").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).then(Commands.m_82127_((String)"surveyor:color").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.greedyString()).suggests((c, s) -> SharedSuggestionProvider.m_82970_((Iterable)ChatFormatting.m_126653_((boolean)true, (boolean)false), (SuggestionsBuilder)s)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)UuidArgument.m_113850_()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.m_6761_(2))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.appendColor(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), UuidArgument.m_113853_((CommandContext)c, (String)"owner"), (ResourceLocation)c.getArgument("id", ResourceLocation.class), (String)c.getArgument("color", String.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                    return 0;
                }
                return SurveyorCommands.appendColor(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class), (String)c.getArgument("color", String.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                return 0;
            }
            return SurveyorCommands.appendColor(s, p, e, f, p.m_284548_(), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class), (String)c.getArgument("color", String.class));
        }))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"trim").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"component", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(LandmarkComponentType.keySet(), (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)UuidArgument.m_113850_()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.m_6761_(2))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.trimLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), UuidArgument.m_113853_((CommandContext)c, (String)"owner"), (ResourceLocation)c.getArgument("id", ResourceLocation.class), (ResourceLocation)c.getArgument("component", ResourceLocation.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                    return 0;
                }
                return SurveyorCommands.trimLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class), (ResourceLocation)c.getArgument("component", ResourceLocation.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            if (p == null) {
                f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                return 0;
            }
            return SurveyorCommands.trimLandmark(s, p, e, f, p.m_284548_(), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class), (ResourceLocation)c.getArgument("component", ResourceLocation.class));
        })))))).then(Commands.m_82127_((String)"view").then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, false)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)UuidArgument.m_113850_()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.m_6761_(2))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), UuidArgument.m_113853_((CommandContext)c, (String)"owner"), (ResourceLocation)c.getArgument("id", ResourceLocation.class), false);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                    return 0;
                }
                return SurveyorCommands.viewLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class), false);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"raw").requires(c -> Surveyor.CONFIG.debugCommands)).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, true)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)UuidArgument.m_113850_()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.m_6761_(2))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.viewLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), UuidArgument.m_113853_((CommandContext)c, (String)"owner"), (ResourceLocation)c.getArgument("id", ResourceLocation.class), true);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                    return 0;
                }
                return SurveyorCommands.viewLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class), true);
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SurveyorCommands.suggestLandmarks((CommandContext<CommandSourceStack>)c, b, false)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"owner", (ArgumentType)UuidArgument.m_113850_()).suggests(SurveyorCommands::suggestOwners).requires(c -> c.m_6761_(2))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                return SurveyorCommands.removeLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), UuidArgument.m_113853_((CommandContext)c, (String)"owner"), (ResourceLocation)c.getArgument("id", ResourceLocation.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        })))).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, p, e, f) -> {
            try {
                if (p == null) {
                    f.accept(SurveyorCommands.prefix().m_7220_((Component)Component.m_237113_((String)"missing UUID argument for server console").m_130940_(ChatFormatting.RED)));
                    return 0;
                }
                return SurveyorCommands.removeLandmark(s, p, e, f, DimensionArgument.m_88808_((CommandContext)c, (String)"dim"), Surveyor.getUuid(p), (ResourceLocation)c.getArgument("id", ResourceLocation.class));
            }
            catch (CommandSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }))))));
    }

    private static /* synthetic */ Style lambda$getLandmarks$13(Integer color, ServerPlayer player, boolean global, Landmark landmark, Component idText, String command, Style s) {
        return s.m_178520_(color == null ? 0xFFFFFF : 0xFFFFFF & color).m_131144_(player == null ? null : new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237119_().m_7220_((Component)(global || landmark.owner().equals(Surveyor.getUuid(player)) ? Component.m_237119_() : Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"owner: ").m_130940_(ChatFormatting.AQUA)).m_130946_(landmark.owner().toString()).m_130946_("\n"))).m_7220_((Component)Component.m_237113_((String)"id: ").m_130940_(ChatFormatting.AQUA)).m_7220_(idText).m_130946_("\n").m_7220_(ComponentUtils.m_178433_(landmark.toText(), (Component)Component.m_130674_((String)"\n"))).m_130946_("\n").m_7220_((Component)Component.m_237113_((String)command).m_130940_(ChatFormatting.AQUA)))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(MinecraftServer var1, @Nullable ServerPlayer var2, @Nullable SurveyorExploration var3, Consumer<Component> var4);
    }
}

