/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorServer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.packet.S2CGroupAmendedPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.util.RegionPos;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public final class ServerSummary {
    public static final String KEY_GROUPS = "groups";
    public static final UUID HOST = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private final Map<UUID, PlayerSummary> offlineSummaries;
    private final Map<UUID, Set<UUID>> shareGroups;
    private boolean dirty = false;

    public ServerSummary(Map<UUID, PlayerSummary> offlineSummaries, @Nullable Map<UUID, Set<UUID>> shareGroups) {
        this.offlineSummaries = offlineSummaries;
        this.shareGroups = shareGroups;
    }

    public static ServerSummary of(MinecraftServer server) {
        return ((SurveyorServer)server).surveyor$getSummary();
    }

    public static Map<UUID, Set<UUID>> loadShareGroups(MinecraftServer server) {
        File folder = Surveyor.getSavePath((ResourceKey<Level>)Level.f_46428_, server);
        CompoundTag sharingNbt = new CompoundTag();
        File sharingFile = new File(folder, "sharing.dat");
        if (sharingFile.exists()) {
            try {
                sharingNbt = NbtIo.m_128937_((File)sharingFile);
            }
            catch (IOException | ReportedException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading sharing file.", e);
            }
        }
        ConcurrentHashMap<UUID, Set<UUID>> shareGroups = new ConcurrentHashMap<UUID, Set<UUID>>();
        sharingNbt.m_128437_(KEY_GROUPS, 9).stream().map(l -> ((ListTag)l).stream().map(s -> UUID.fromString(s.m_7916_())).collect(Collectors.toCollection(HashSet::new))).forEach(set -> {
            for (UUID uuid : set) {
                shareGroups.put(uuid, (Set<UUID>)set);
            }
        });
        return shareGroups;
    }

    public static ServerSummary load(MinecraftServer server) {
        Map<UUID, Set<UUID>> shareGroups = Surveyor.CONFIG.networking.globalSharing ? null : ServerSummary.loadShareGroups(server);
        File playerFolder = server.m_129843_(LevelResource.f_78176_).toFile();
        ConcurrentHashMap<UUID, PlayerSummary> offlineSummaries = new ConcurrentHashMap<UUID, PlayerSummary>();
        CompoundTag hostData = server.m_129910_().m_6614_();
        UUID hostProfile = Optional.ofNullable(server.m_236731_()).map(GameProfile::getId).orElse(null);
        if (hostData != null) {
            if (hostProfile != null) {
                hostData.m_128359_("username", server.m_236731_().getName());
            }
            offlineSummaries.put(HOST, new PlayerSummary.OfflinePlayerSummary(HOST, hostData, false));
        }
        for (File file : Optional.ofNullable(playerFolder.listFiles((dir, name) -> name.endsWith(".dat"))).orElse(new File[0])) {
            UUID uuid;
            try {
                uuid = UUID.fromString(file.getName().substring(0, file.getName().length() - ".dat".length()));
                if (uuid.equals(hostProfile)) {
                }
            }
            catch (IllegalArgumentException ex) {}
            continue;
            if (shareGroups != null && !shareGroups.containsKey(uuid)) continue;
            try {
                CompoundTag playerNbt = NbtIo.m_128937_((File)file);
                offlineSummaries.put(uuid, new PlayerSummary.OfflinePlayerSummary(uuid, playerNbt, false));
            }
            catch (IOException | ReportedException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading offline player data for {}!", (Object)uuid, (Object)e);
            }
        }
        if (shareGroups != null) {
            for (UUID uuid : shareGroups.keySet()) {
                if (offlineSummaries.containsKey(uuid)) continue;
                Surveyor.LOGGER.warn("[Surveyor] Player data was missing for shared player {}! Removing from groups...", (Object)uuid);
                shareGroups.get(uuid).remove(uuid);
                shareGroups.remove(uuid);
            }
        }
        return new ServerSummary(offlineSummaries, shareGroups);
    }

    public static void onPlayerJoin(ServerGamePacketListenerImpl handler, PacketSender sender, MinecraftServer server) {
        ServerPlayer player = handler.m_142253_();
        ServerSummary serverSummary = ServerSummary.of(server);
        UUID uuid = Surveyor.getUuid(player);
        boolean known = serverSummary.offlineSummaries.containsKey(uuid);
        if (!known) {
            serverSummary.createPlayer(player);
        }
        if (serverSummary.getGroup(uuid).size() > 1) {
            SurveyorExploration groupExploration = serverSummary.groupExploration(uuid, server);
            Map<UUID, PlayerSummary> groupSummaries = serverSummary.getGroupSummaries(uuid, server);
            new S2CGroupChangedPacket(groupSummaries, groupExploration.terrain().getOrDefault(player.m_9236_().m_46472_(), new HashMap()), groupExploration.structures().getOrDefault(player.m_9236_().m_46472_(), new HashMap())).send(player);
            new S2CGroupUpdatedPacket(groupSummaries).send(player);
        }
        if (!known && Surveyor.CONFIG.networking.globalSharing) {
            new S2CGroupAmendedPacket(uuid).send(player, server, server.m_6846_().m_11314_(), NetworkMode.GROUP);
        }
    }

    public static void onTick(MinecraftServer server) {
        if (server.m_129921_() % Surveyor.CONFIG.networking.positionTicks != 0) {
            return;
        }
        ServerSummary serverSummary = ServerSummary.of(server);
        for (Set<UUID> group : serverSummary.getPositionGroups()) {
            HashMap<UUID, PlayerSummary> onlinePlayers = new HashMap<UUID, PlayerSummary>();
            for (UUID uuid : group) {
                ServerPlayer player = server.m_6846_().m_11259_(uuid);
                if (player == null) continue;
                onlinePlayers.put(uuid, PlayerSummary.of(player));
            }
            if (onlinePlayers.size() <= 1) continue;
            new S2CGroupUpdatedPacket(onlinePlayers).send(null, server, onlinePlayers.keySet().stream().map(arg_0 -> ((PlayerList)server.m_6846_()).m_11259_(arg_0)).toList(), Surveyor.CONFIG.networking.positions);
        }
    }

    public void save(MinecraftServer server, boolean force, boolean suppressLogs) {
        if (!this.isDirty() && StreamSupport.stream(server.m_129785_().spliterator(), false).map(WorldSummary::of).noneMatch(WorldSummary::isDirty)) {
            return;
        }
        if (!suppressLogs) {
            Surveyor.LOGGER.info("[Surveyor] Saving server data...");
        }
        for (ServerLevel world : server.m_129785_()) {
            if (world.f_8564_ && !force) continue;
            WorldSummary.of((Level)world).save((Level)world, Surveyor.getSavePath((ResourceKey<Level>)world.m_46472_(), server), suppressLogs);
        }
        File folder = Surveyor.getSavePath((ResourceKey<Level>)Level.f_46428_, server);
        if (this.isDirty()) {
            File sharingFile = new File(folder, "sharing.dat");
            try {
                NbtIo.m_128944_((CompoundTag)this.writeNbt(new CompoundTag()), (File)sharingFile);
                this.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing sharing file.", (Throwable)e);
            }
        }
        if (!suppressLogs) {
            Surveyor.LOGGER.info("[Surveyor] Finished saving server data.");
        }
    }

    private CompoundTag writeNbt(CompoundTag nbt) {
        if (this.shareGroups != null) {
            nbt.m_128365_(KEY_GROUPS, (Tag)new ListTag(this.shareGroups.values().stream().filter(s -> s.size() > 1).map(s -> new ListTag(s.stream().map(u -> StringTag.m_129297_((String)u.toString())).toList(), 8)).toList(), 9));
        }
        return nbt;
    }

    public PlayerSummary getPlayer(UUID uuid, MinecraftServer server) {
        ServerPlayer player = Surveyor.getPlayer(server, uuid);
        if (player != null) {
            return PlayerSummary.of(player);
        }
        return this.offlineSummaries.get(uuid);
    }

    public SurveyorExploration getExploration(UUID player, MinecraftServer server) {
        PlayerSummary summary = this.getPlayer(player, server);
        return summary == null ? null : summary.exploration();
    }

    public void createPlayer(ServerPlayer player) {
        this.offlineSummaries.put(Surveyor.getUuid(player), new PlayerSummary.OfflinePlayerSummary(player));
    }

    public void updatePlayer(UUID uuid, CompoundTag nbt, boolean online, MinecraftServer server) {
        PlayerSummary.OfflinePlayerSummary newSummary = new PlayerSummary.OfflinePlayerSummary(uuid, nbt, online);
        this.offlineSummaries.put(uuid, newSummary);
        S2CGroupUpdatedPacket.of(uuid, newSummary).send(null, server, server.m_6846_().m_11314_(), Surveyor.CONFIG.networking.positions);
    }

    public Set<Set<UUID>> getPositionGroups() {
        return Surveyor.CONFIG.networking.positions.atLeast(NetworkMode.SERVER) ? Set.of(this.offlineSummaries.keySet()) : (Surveyor.CONFIG.networking.positions.atMost(NetworkMode.SOLO) ? Set.of() : this.getGroups());
    }

    public Set<Set<UUID>> getGroups() {
        return this.shareGroups == null ? new HashSet<HashSet<UUID>>(Set.of(new HashSet<UUID>(this.offlineSummaries.keySet()))) : new HashSet<Set<UUID>>(this.shareGroups.values());
    }

    public Set<UUID> getGroup(UUID player) {
        return this.shareGroups == null ? new HashSet<UUID>(this.offlineSummaries.keySet()) : this.shareGroups.computeIfAbsent(player, p -> new HashSet<UUID>(Set.of(p)));
    }

    public Map<UUID, PlayerSummary> getAllSummaries(MinecraftServer server) {
        HashMap<UUID, PlayerSummary> map = new HashMap<UUID, PlayerSummary>();
        for (UUID u : this.offlineSummaries.keySet()) {
            if (this.getPlayer(u, server) == null) continue;
            map.put(u, this.getPlayer(u, server));
        }
        return map;
    }

    public Map<UUID, PlayerSummary> getGroupSummaries(UUID player, MinecraftServer server) {
        HashMap<UUID, PlayerSummary> map = new HashMap<UUID, PlayerSummary>();
        for (UUID u : this.getGroup(player)) {
            if (this.getPlayer(u, server) == null) continue;
            map.put(u, this.getPlayer(u, server));
        }
        return map;
    }

    public void joinGroup(UUID player1, UUID player2, MinecraftServer server) {
        if (this.shareGroups == null) {
            return;
        }
        if (this.getGroup(player1).size() > 1 && this.getGroup(player2).size() > 1) {
            throw new IllegalStateException("Can't merge two groups!");
        }
        if (this.getGroup(player1).size() > 1) {
            this.getGroup(player1).add(player2);
            this.shareGroups.put(player2, this.getGroup(player1));
        } else {
            this.getGroup(player2).add(player1);
            this.shareGroups.put(player1, this.getGroup(player2));
        }
        SurveyorExploration groupExploration = this.groupExploration(player1, server);
        for (ServerPlayer friend : this.groupServerPlayers(player1, server)) {
            new S2CGroupChangedPacket(this.getGroupSummaries(player1, server), groupExploration.terrain().getOrDefault(friend.m_9236_().m_46472_(), new HashMap()), groupExploration.structures().getOrDefault(friend.m_9236_().m_46472_(), new HashMap())).send(friend);
            WorldLandmarks landmarks = WorldSummary.of(friend.m_9236_()).landmarks();
            if (landmarks == null || Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.SOLO)) continue;
            Multimap<UUID, ResourceLocation> sharedLandmarks = landmarks.keySet(groupExploration);
            landmarks.keySet(SurveyorExploration.of(friend)).forEach((arg_0, arg_1) -> sharedLandmarks.remove(arg_0, arg_1));
            if (!sharedLandmarks.isEmpty()) {
                SyncLandmarksAddedPacket.of(sharedLandmarks, landmarks).send(friend);
            }
            Multimap<UUID, ResourceLocation> removedLandmarks = landmarks.removed();
            removedLandmarks.keySet().removeIf(uuid -> !groupExploration.sharedPlayers().contains(uuid));
            if (removedLandmarks.isEmpty()) continue;
            new SyncLandmarksRemovedPacket(removedLandmarks).send(friend);
        }
        this.dirty();
    }

    public void leaveGroup(UUID player, MinecraftServer server) {
        if (this.shareGroups == null) {
            return;
        }
        this.getGroup(player).remove(player);
        SurveyorExploration groupExploration = this.groupExploration(player, server);
        for (ServerPlayer friend : this.groupOtherServerPlayers(player, server)) {
            new S2CGroupChangedPacket(this.getGroupSummaries(Surveyor.getUuid(friend), server), groupExploration.terrain().getOrDefault(friend.m_9236_().m_46472_(), new HashMap()), groupExploration.structures().getOrDefault(friend.m_9236_().m_46472_(), new HashMap())).send(friend);
        }
        this.shareGroups.put(player, new HashSet());
        this.getGroup(player).add(player);
        ServerPlayer serverPlayer = Surveyor.getPlayer(server, player);
        if (serverPlayer != null) {
            new S2CGroupChangedPacket(this.getGroupSummaries(player, server), new HashMap<RegionPos, BitSet>(), new HashMap<ResourceKey<Structure>, LongSet>()).send(serverPlayer);
        }
        this.dirty();
    }

    public int groupSize(UUID player) {
        return this.getGroup(player).size();
    }

    public Set<PlayerSummary> groupPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().map(u -> this.getPlayer((UUID)u, server)).collect(Collectors.toSet());
    }

    public SurveyorExploration groupExploration(UUID player, MinecraftServer server) {
        return PlayerSummary.OfflinePlayerSummary.OfflinePlayerExploration.ofMerged(this.getGroup(player).stream().map(u -> this.getExploration((UUID)u, server)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public Set<ServerPlayer> groupServerPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().map(uuid -> Surveyor.getPlayer(server, uuid)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<ServerPlayer> allOtherServerPlayers(UUID player, MinecraftServer server) {
        return server.m_6846_().m_11314_().stream().filter(p -> !Surveyor.getUuid(p).equals(player)).collect(Collectors.toSet());
    }

    public Set<ServerPlayer> groupOtherServerPlayers(UUID player, MinecraftServer server) {
        return this.getGroup(player).stream().filter(u -> !u.equals(player)).map(arg_0 -> ((PlayerList)server.m_6846_()).m_11259_(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean isDirty() {
        return this.dirty && this.shareGroups != null;
    }

    private void dirty() {
        this.dirty = true;
    }
}

