/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init.explosion;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public record VanillaExplosionContext(@Nullable Entity entity, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator calculator, boolean fire, Explosion.BlockInteraction type) {
    public VanillaExplosionContext(Level level, @Nullable Entity entity, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator calculator, boolean fire, Level.ExplosionInteraction type) {
        this(entity, source, calculator, fire, VanillaExplosionContext.getType(level, entity, type));
    }

    private static Explosion.BlockInteraction getType(Level level, @Nullable Entity entity, Level.ExplosionInteraction type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> level.m_255157_(GameRules.f_254629_);
            case Level.ExplosionInteraction.MOB -> {
                LivingEntity le;
                if (ForgeEventFactory.getMobGriefingEvent((Level)level, entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null)) {
                    yield level.m_255157_(GameRules.f_254692_);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> level.m_255157_(GameRules.f_254705_);
        };
    }
}

