/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.capability.player;

import dev.xkmc.l2library.capability.entity.GeneralCapabilityHolder;
import dev.xkmc.l2library.capability.entity.GeneralCapabilityTemplate;
import dev.xkmc.l2library.capability.player.PlayerCapabilityNetworkHandler;
import dev.xkmc.l2library.capability.player.PlayerCapabilitySerializer;
import dev.xkmc.l2library.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerCapabilityHolder<T extends PlayerCapabilityTemplate<T>>
extends GeneralCapabilityHolder<Player, T> {
    public static final Map<ResourceLocation, PlayerCapabilityHolder<?>> INTERNAL_MAP = new ConcurrentHashMap();
    public final PlayerCapabilityNetworkHandler<T> network;
    @OnlyIn(value=Dist.CLIENT)
    private CompoundTag revive_cache;

    public PlayerCapabilityHolder(ResourceLocation id, Capability<T> capability, Class<T> cls, Supplier<T> sup, Function<PlayerCapabilityHolder<T>, PlayerCapabilityNetworkHandler<T>> network) {
        super(id, capability, cls, sup, Player.class, e -> true);
        this.network = network.apply(this);
        INTERNAL_MAP.put(id, this);
    }

    @Override
    public T get(Player e) {
        GeneralCapabilityTemplate data;
        LazyOptional lazyCap = e.getCapability(this.capability);
        if (lazyCap.resolve().isEmpty()) {
            e.reviveCaps();
            data = ((PlayerCapabilityTemplate)e.getCapability(this.capability).resolve().get()).check();
            e.invalidateCaps();
        } else {
            data = ((PlayerCapabilityTemplate)lazyCap.resolve().get()).check();
        }
        return (T)data;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void cacheSet(CompoundTag tag, boolean force) {
        LocalPlayer pl = Proxy.getClientPlayer();
        if (!force && pl != null && pl.getCapability(this.capability).cast().resolve().isPresent()) {
            T m = this.get((Player)pl);
            ((PlayerCapabilityTemplate)m).preInject();
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)tag, (Class)this.holder_class, (Object)m, f -> true));
            ((PlayerCapabilityTemplate)m).init();
        } else {
            this.revive_cache = tag;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public CompoundTag getCache(Player pl) {
        CompoundTag tag = this.revive_cache;
        this.revive_cache = null;
        if (tag == null) {
            tag = TagCodec.toTag((CompoundTag)new CompoundTag(), this.get(pl));
        }
        return tag;
    }

    public PlayerCapabilitySerializer<T> generateSerializer(Player player) {
        return new PlayerCapabilitySerializer(player, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateTracked(CompoundTag tag, @Nullable Player pl) {
        if (!(pl instanceof RemotePlayer)) {
            return;
        }
        RemotePlayer player = (RemotePlayer)pl;
        if (player.getCapability(this.capability).cast().resolve().isPresent()) {
            T m = this.get((Player)player);
            ((PlayerCapabilityTemplate)m).preInject();
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)tag, (Class)this.holder_class, (Object)m, SerialClass.SerialField::toTracking));
            ((PlayerCapabilityTemplate)m).init();
        }
    }
}

