/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.overlay;

import dev.xkmc.l2library.init.L2LibraryConfig;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class OverlayUtil
implements ClientTooltipPositioner {
    public int bg = OverlayUtil.getBGColor();
    public int bs = 0x505000FF;
    public int be = 1344798847;
    public int tc = -1;
    protected final GuiGraphics g;
    protected final int x0;
    protected final int y0;
    protected final int maxW;

    private static int getBGColor() {
        return (int)Math.round((Double)L2LibraryConfig.CLIENT.infoAlpha.get() * 255.0) << 24 | 0x100010;
    }

    public OverlayUtil(GuiGraphics g, int x0, int y0, int maxW) {
        this.g = g;
        this.x0 = x0;
        this.y0 = y0;
        this.maxW = maxW < 0 ? this.getMaxWidth() : maxW;
    }

    public int getMaxWidth() {
        return this.g.m_280182_() / 4;
    }

    public void renderLongText(Font font, List<Component> list) {
        List<ClientTooltipComponent> ans = list.stream().flatMap(text -> font.m_92923_((FormattedText)text, this.maxW).stream()).map(ClientTooltipComponent::m_169948_).toList();
        this.renderTooltipInternal(font, ans);
    }

    public void renderTooltipInternal(Font font, List<ClientTooltipComponent> list) {
        ClientTooltipComponent c;
        int i;
        if (list.isEmpty()) {
            return;
        }
        int w = 0;
        int h = list.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent c2 : list) {
            int wi = c2.m_142069_(font);
            if (wi > w) {
                w = wi;
            }
            h += c2.m_142103_();
        }
        int wf = w;
        int hf = h;
        Vector2ic pos = this.m_262814_(this.g.m_280182_(), this.g.m_280206_(), this.x0, this.y0, wf, hf);
        int xf = pos.x();
        int yf = pos.y();
        this.g.m_280168_().m_85836_();
        int z = 400;
        this.g.m_286007_(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)this.g, (int)xf, (int)yf, (int)wf, (int)hf, (int)z, (int)this.bg, (int)this.bg, (int)this.bs, (int)this.be));
        this.g.m_280168_().m_252880_(0.0f, 0.0f, (float)z);
        int yi = yf;
        for (i = 0; i < list.size(); ++i) {
            c = list.get(i);
            c.m_142440_(font, xf, yi, this.g.m_280168_().m_85850_().m_252922_(), this.g.m_280091_());
            yi += c.m_142103_() + (i == 0 ? 2 : 0);
        }
        yi = yf;
        for (i = 0; i < list.size(); ++i) {
            c = list.get(i);
            c.m_183452_(font, xf, yi, this.g);
            yi += c.m_142103_() + (i == 0 ? 2 : 0);
        }
        this.g.m_280168_().m_85849_();
    }

    public Vector2ic m_262814_(int gw, int gh, int x, int y, int tw, int th) {
        if (x < 0) {
            x = Math.round((float)gw / 8.0f);
        }
        if (y < 0) {
            y = Math.round((float)(gh - th) / 2.0f);
        }
        return new Vector2i(x, y);
    }

    public static void fillRect(GuiGraphics g, int x, int y, int w, int h, int col) {
        g.m_280509_(x, y, x + w, y + h, col);
    }

    public static void drawRect(GuiGraphics g, int x, int y, int w, int h, int col) {
        OverlayUtil.fillRect(g, x - 1, y - 1, w + 2, 1, col);
        OverlayUtil.fillRect(g, x - 1, y - 1, 1, h + 2, col);
        OverlayUtil.fillRect(g, x - 1, y + h, w + 2, 1, col);
        OverlayUtil.fillRect(g, x + w, y - 1, 1, h + 2, col);
    }
}

