/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.clumps.mixin;

import com.blamejared.clumps.ClumpsCommon;
import com.blamejared.clumps.api.events.IRepairEvent;
import com.blamejared.clumps.api.events.IValueEvent;
import com.blamejared.clumps.helper.IClumpedOrb;
import com.blamejared.clumps.mixin.ExperienceOrbAccess;
import com.blamejared.clumps.platform.Services;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ExperienceOrb.class}, priority=1001)
public abstract class MixinExperienceOrb
extends Entity
implements IClumpedOrb {
    @Shadow
    private int f_147072_;
    @Shadow
    private int f_20767_;
    @Shadow
    private int f_20770_;
    @Unique
    public Map<Integer, Integer> clumps$clumpedMap;
    @Unique
    public Map.Entry<EquipmentSlot, ItemStack> clumps$currentEntry;

    @Shadow
    protected abstract int m_147092_(Player var1, int var2);

    @Shadow
    private static boolean m_147088_(ExperienceOrb experienceOrb, int id, int value) {
        return false;
    }

    @Shadow
    protected abstract int m_20798_(int var1);

    @Shadow
    protected abstract int m_20793_(int var1);

    public MixinExperienceOrb(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"canMerge(Lnet/minecraft/world/entity/ExperienceOrb;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canMerge(ExperienceOrb experienceOrb, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(experienceOrb.m_6084_() && !this.m_7306_((Entity)experienceOrb) ? 1 : 0));
    }

    @Inject(method={"canMerge(Lnet/minecraft/world/entity/ExperienceOrb;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canMerge(ExperienceOrb experienceOrb, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)experienceOrb.m_6084_());
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playerTouch(Player player, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            if (ClumpsCommon.pickupXPEvent.test(player, (ExperienceOrb)this)) {
                return;
            }
            player.f_36101_ = 0;
            player.m_7938_((Entity)this, 1);
            if (this.f_20770_ != 0 || this.clumps$resolve()) {
                AtomicInteger toGive = new AtomicInteger();
                this.clumps$getClumpedMap().forEach((value, amount) -> {
                    Either<IValueEvent, Integer> result = Services.EVENT.fireValueEvent(player, (int)value);
                    int actualValue = (Integer)result.map(IValueEvent::getValue, UnaryOperator.identity());
                    for (int i = 0; i < amount; ++i) {
                        int leftOver = (Integer)Services.EVENT.fireRepairEvent(player, actualValue).map(IRepairEvent::getValue, UnaryOperator.identity());
                        if (leftOver == actualValue) {
                            leftOver = this.m_147092_(player, actualValue);
                        }
                        if (leftOver <= 0) continue;
                        toGive.addAndGet(leftOver);
                    }
                });
                if (toGive.get() > 0) {
                    player.m_6756_(toGive.get());
                }
            }
            this.m_146870_();
            ci.cancel();
        }
    }

    @ModifyVariable(index=3, method={"repairPlayerItems"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getRandomItemWith(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Map$Entry;"))
    public Map.Entry<EquipmentSlot, ItemStack> clumps$captureCurrentEntry(Map.Entry<EquipmentSlot, ItemStack> entry) {
        this.clumps$currentEntry = entry;
        return entry;
    }

    @Inject(method={"repairPlayerItems"}, cancellable=true, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getRandomItemWith(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Map$Entry;")})
    public void clumps$repairPlayerItems(Player player, int actualValue, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)Optional.ofNullable(this.clumps$currentEntry).map(Map.Entry::getValue).map(foundItem -> {
            BiFunction<ItemStack, Integer, Float> repairRatio = Services.PLATFORM.getRepairRatio((itemStack, integer) -> Float.valueOf(this.m_20798_((int)integer)));
            int toRepair = Math.min(repairRatio.apply((ItemStack)foundItem, actualValue).intValue(), foundItem.m_41773_());
            foundItem.m_41721_(foundItem.m_41773_() - toRepair);
            int used = actualValue - this.m_20793_(toRepair);
            return used > 0 ? this.m_147092_(player, used) : 0;
        }).orElse(actualValue));
    }

    @Inject(method={"merge(Lnet/minecraft/world/entity/ExperienceOrb;)V"}, at={@At(value="INVOKE", target="net/minecraft/world/entity/ExperienceOrb.discard()V", shift=At.Shift.BEFORE)}, cancellable=true)
    public void merge(ExperienceOrb secondaryOrb, CallbackInfo ci) {
        Map<Integer, Integer> otherMap = ((IClumpedOrb)secondaryOrb).clumps$getClumpedMap();
        this.f_147072_ = this.clumps$getClumpedMap().values().stream().reduce(Integer::sum).orElse(1);
        this.f_20767_ = Math.min(this.f_20767_, ((ExperienceOrbAccess)secondaryOrb).clumps$getAge());
        this.clumps$setClumpedMap(Stream.of(this.clumps$getClumpedMap(), otherMap).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)));
        secondaryOrb.m_146870_();
        ci.cancel();
    }

    @Inject(method={"tryMergeToExisting(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void tryMergeToExisting(ServerLevel serverLevel, Vec3 vec3, int value, CallbackInfoReturnable<Boolean> cir) {
        AABB aABB = AABB.m_165882_((Vec3)vec3, (double)1.0, (double)1.0, (double)1.0);
        int id = serverLevel.m_213780_().m_188503_(40);
        List list = serverLevel.m_142425_(EntityTypeTest.m_156916_(ExperienceOrb.class), aABB, experienceOrbx -> MixinExperienceOrb.m_147088_(experienceOrbx, id, value));
        if (!list.isEmpty()) {
            ExperienceOrb experienceOrb = (ExperienceOrb)list.get(0);
            Map<Integer, Integer> clumpedMap = ((IClumpedOrb)experienceOrb).clumps$getClumpedMap();
            ((IClumpedOrb)experienceOrb).clumps$setClumpedMap(Stream.of(clumpedMap, Collections.singletonMap(value, 1)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)));
            ((ExperienceOrbAccess)experienceOrb).clumps$setCount(clumpedMap.values().stream().reduce(Integer::sum).orElse(1));
            ((ExperienceOrbAccess)experienceOrb).clumps$setAge(0);
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.clumps$clumpedMap != null) {
            CompoundTag map = new CompoundTag();
            this.clumps$getClumpedMap().forEach((value, count) -> map.m_128405_(String.valueOf(value), count.intValue()));
            compoundTag.m_128365_("clumpedMap", (Tag)map);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (compoundTag.m_128441_("clumpedMap")) {
            CompoundTag clumpedMap = compoundTag.m_128469_("clumpedMap");
            for (String s : clumpedMap.m_128431_()) {
                map.put(Integer.parseInt(s), clumpedMap.m_128451_(s));
            }
        } else {
            map.put(this.f_20770_, this.f_147072_);
        }
        this.clumps$setClumpedMap(map);
    }

    @Override
    public Map<Integer, Integer> clumps$getClumpedMap() {
        if (this.clumps$clumpedMap == null) {
            this.clumps$clumpedMap = new HashMap<Integer, Integer>();
            this.clumps$clumpedMap.put(this.f_20770_, 1);
        }
        return this.clumps$clumpedMap;
    }

    @Override
    public void clumps$setClumpedMap(Map<Integer, Integer> map) {
        this.clumps$clumpedMap = map;
        this.clumps$resolve();
    }

    @Override
    public boolean clumps$resolve() {
        this.f_20770_ = this.clumps$getClumpedMap().entrySet().stream().map(entry -> (Integer)entry.getKey() * (Integer)entry.getValue()).reduce(Integer::sum).orElse(1);
        return this.f_20770_ > 0;
    }
}

