/*
 * Decompiled with CFR 0.152.
 */
package com.myangel.playerlocatorplus.util;

import java.util.Random;
import java.util.UUID;

public final class ColorUtils {
    private ColorUtils() {
    }

    public static int uuidToColor(UUID uuid) {
        Random random = new Random(uuid.getMostSignificantBits() ^ uuid.getLeastSignificantBits());
        float hue = random.nextFloat() * 360.0f;
        float saturation = random.nextFloat() / 4.0f + 0.75f;
        float lightness = random.nextFloat() / 2.0f + 0.5f;
        return ColorUtils.hslToColor(hue, saturation, lightness);
    }

    private static int hslToColor(float h, float s, float l) {
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float m = l - 0.5f * c;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        int hueSegment = (int)(h / 60.0f);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (hueSegment) {
            case 0: {
                r = c + m;
                g = x + m;
                b = m;
                break;
            }
            case 1: {
                r = x + m;
                g = c + m;
                b = m;
                break;
            }
            case 2: {
                r = m;
                g = c + m;
                b = x + m;
                break;
            }
            case 3: {
                r = m;
                g = x + m;
                b = c + m;
                break;
            }
            case 4: {
                r = x + m;
                g = m;
                b = c + m;
                break;
            }
            case 5: 
            case 6: {
                r = c + m;
                g = m;
                b = x + m;
            }
        }
        int ri = Math.min(255, Math.max(0, Math.round(r * 255.0f)));
        int gi = Math.min(255, Math.max(0, Math.round(g * 255.0f)));
        int bi = Math.min(255, Math.max(0, Math.round(b * 255.0f)));
        return ri << 16 | gi << 8 | bi;
    }
}

