/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.core;

import folk.sisby.antique_atlas.gui.core.ToggleButtonComponent;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ScreenState<T> {
    protected final BiConsumer<State<T>, State<T>> onChangedState;
    protected volatile State<T> currentState;

    public ScreenState(BiConsumer<State<T>, State<T>> onChangedState) {
        this.onChangedState = onChangedState;
    }

    public ScreenState() {
        this.onChangedState = null;
    }

    public State<T> current() {
        return this.currentState;
    }

    public boolean is(State<T> state) {
        return this.current() == state;
    }

    public void switchTo(State<T> state, T screen) {
        if (this.currentState != null) {
            this.currentState.onExitState(screen);
        }
        if (this.onChangedState != null) {
            this.onChangedState.accept(this.currentState, state);
        }
        this.currentState = state;
        if (state != null) {
            state.onEnterState(screen);
        }
    }

    public static interface State<T> {
        public void onEnterState(T var1);

        public void onExitState(T var1);
    }

    public record ToggleState<T>(Function<T, ToggleButtonComponent> toggleButton, Consumer<T> onEnterState, Consumer<T> onExitState) implements State<T>
    {
        public ToggleState(Function<T, ToggleButtonComponent> toggleButton) {
            this(toggleButton, null, null);
        }

        public ToggleState() {
            this(null, null, null);
        }

        @Override
        public void onEnterState(T screen) {
            if (this.toggleButton != null) {
                this.toggleButton.apply(screen).setSelected(true);
            }
            if (this.onEnterState != null) {
                this.onEnterState.accept(screen);
            }
        }

        @Override
        public void onExitState(T screen) {
            if (this.toggleButton != null) {
                this.toggleButton.apply(screen).setSelected(false);
            }
            if (this.onExitState != null) {
                this.onExitState.accept(screen);
            }
        }
    }
}

