/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.core;

import com.mojang.blaze3d.systems.RenderSystem;
import folk.sisby.antique_atlas.gui.core.Component;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class BlinkingTextureComponent
extends Component {
    protected ResourceLocation texture;
    protected final long blinkTime;
    protected final float visibleAlpha;
    protected final float invisibleAlpha;
    protected long lastTickTime;
    protected boolean isVisible;

    public BlinkingTextureComponent(long blinkTime, float visibleAlpha, float invisibleAlpha) {
        this.blinkTime = blinkTime;
        this.visibleAlpha = visibleAlpha;
        this.invisibleAlpha = invisibleAlpha;
    }

    public BlinkingTextureComponent() {
        this(500L, 1.0f, 0.25f);
    }

    public void setTexture(ResourceLocation texture, int width, int height) {
        this.texture = texture;
        this.setSize(width, height);
        this.lastTickTime = 0L;
        this.isVisible = false;
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        long currentTime = System.currentTimeMillis();
        if (this.lastTickTime + this.blinkTime < currentTime) {
            this.lastTickTime = currentTime;
            this.isVisible = !this.isVisible;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.isVisible ? this.visibleAlpha : this.invisibleAlpha));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        this.drawImage(context);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawImage(GuiGraphics context) {
        context.m_280163_(this.texture, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
    }
}

