/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.TileTexture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;

public record StructureTileProvider(ResourceLocation id, int priority, Map<ChunkMatcher, List<TileTexture>> matchers) {
    public static final BiMap<ResourceLocation, ChunkMatcher> CHUNK_MATCHERS = HashBiMap.create();

    public StructureTileProvider(ResourceLocation id, int priority, List<TileTexture> textures) {
        this(id, priority, Map.of(ChunkMatcher::center, textures));
    }

    public StructureTileProvider(ResourceLocation id, int priority, ChunkMatcher matcher, List<TileTexture> textures) {
        this(id, priority, Map.of(matcher, textures));
    }

    public static ChunkMatcher getChunkMatcher(ResourceLocation id) {
        return (ChunkMatcher)CHUNK_MATCHERS.get((Object)id);
    }

    public Map<ChunkPos, TileTexture> getTextures(Function<ChunkMatcher, Collection<ChunkPos>> matcherFunction, Map<ChunkPos, String> tilePredicates) {
        HashMap<ChunkPos, TileTexture> outMap = new HashMap<ChunkPos, TileTexture>();
        this.matchers.forEach((matcher, textures) -> {
            for (ChunkPos pos : (Collection)matcherFunction.apply((ChunkMatcher)matcher)) {
                tilePredicates.put(pos, Objects.toString(CHUNK_MATCHERS.inverse().get(matcher), null));
                int variation = (int)(Mth.m_14130_((int)pos.f_45578_, (int)pos.f_45579_, (int)(pos.f_45578_ * pos.f_45579_)) & Integer.MAX_VALUE);
                outMap.put(pos, (TileTexture)textures.get(variation % textures.size()));
            }
        });
        return outMap;
    }

    public Map<ChunkPos, TileTexture> getTextures(Level world, BoundingBox box, Map<ChunkPos, String> tilePredicates) {
        return this.getTextures(matcher -> matcher.matches(world, box), tilePredicates);
    }

    public Map<ChunkPos, TileTexture> getTextures(Level world, BoundingBox box, List<JigsawJunction> junctions, Map<ChunkPos, String> tilePredicates) {
        return this.getTextures(matcher -> matcher.matches(world, box, junctions), tilePredicates);
    }

    public Set<TileTexture> allTextures() {
        HashSet<TileTexture> outSet = new HashSet<TileTexture>();
        this.matchers.values().forEach(outSet::addAll);
        return outSet;
    }

    static {
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center"), ChunkMatcher::center);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_above_ground"), ChunkMatcher::aboveGround);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_top_above_ground"), ChunkMatcher::topAboveGround);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_horizontal"), ChunkMatcher::centerIfHorizontal);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_vertical"), ChunkMatcher::centerIfVertical);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("bridge_horizontal"), ChunkMatcher::bridgeHorizontal);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("bridge_vertical"), ChunkMatcher::bridgeVertical);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("path_straight_horizontal"), ChunkJunctionMatcher::straightHorizontal);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("path_straight_vertical"), ChunkJunctionMatcher::straightVertical);
    }

    public static interface ChunkMatcher {
        public Collection<ChunkPos> matches(Level var1, BoundingBox var2);

        default public Collection<ChunkPos> matches(Level world, BoundingBox box, List<JigsawJunction> junctions) {
            return this.matches(world, box);
        }

        public static Collection<ChunkPos> center(Level world, BoundingBox box) {
            return Collections.singleton(new ChunkPos(box.m_162394_()));
        }

        public static Collection<ChunkPos> topAboveGround(Level world, BoundingBox box) {
            if (world.m_5736_() <= box.m_162400_()) {
                return Collections.singleton(new ChunkPos(box.m_162394_()));
            }
            return Collections.emptyList();
        }

        public static Collection<ChunkPos> aboveGround(Level world, BoundingBox box) {
            BlockPos center = new BlockPos((Vec3i)box.m_162394_());
            if (world.m_5736_() - 4 <= center.m_123342_()) {
                return Collections.singleton(new ChunkPos(center));
            }
            return Collections.emptyList();
        }

        public static Collection<ChunkPos> bridgeHorizontal(Level world, BoundingBox box) {
            HashSet<ChunkPos> matches = new HashSet<ChunkPos>();
            if (box.m_71056_() > 16) {
                int chunkZ = box.m_162394_().m_123343_() >> 4;
                for (int x = box.m_162395_(); x < box.m_162399_(); x += 16) {
                    matches.add(new ChunkPos(x >> 4, chunkZ));
                }
            }
            return matches;
        }

        public static Collection<ChunkPos> bridgeVertical(Level world, BoundingBox box) {
            HashSet<ChunkPos> matches = new HashSet<ChunkPos>();
            if (box.m_71058_() > 16) {
                int chunkX = box.m_162394_().m_123341_() >> 4;
                for (int z = box.m_162398_(); z < box.m_162401_(); z += 16) {
                    matches.add(new ChunkPos(chunkX, z >> 4));
                }
            }
            return matches;
        }

        public static Collection<ChunkPos> centerIfHorizontal(Level world, BoundingBox box) {
            if (box.m_71056_() > box.m_71058_()) {
                return Collections.singleton(new ChunkPos(box.m_162394_()));
            }
            return Collections.emptySet();
        }

        public static Collection<ChunkPos> centerIfVertical(Level world, BoundingBox box) {
            if (box.m_71058_() > box.m_71056_()) {
                return Collections.singleton(new ChunkPos(box.m_162394_()));
            }
            return Collections.emptySet();
        }
    }

    public static interface ChunkJunctionMatcher
    extends ChunkMatcher {
        @Override
        default public Collection<ChunkPos> matches(Level world, BoundingBox box) {
            return this.matches(world, box, List.of());
        }

        @Override
        public Collection<ChunkPos> matches(Level var1, BoundingBox var2, List<JigsawJunction> var3);

        public static Collection<ChunkPos> straightHorizontal(Level world, BoundingBox box, List<JigsawJunction> junctions) {
            if (junctions.size() == 2 && (junctions.get(0).m_210258_() == junctions.get(1).m_210258_() || junctions.get(0).m_210252_() != junctions.get(1).m_210252_())) {
                return List.of(new ChunkPos(box.m_162394_()));
            }
            return List.of();
        }

        public static Collection<ChunkPos> straightVertical(Level world, BoundingBox box, List<JigsawJunction> junctions) {
            if (junctions.size() == 2 && (junctions.get(0).m_210252_() == junctions.get(1).m_210252_() || junctions.get(0).m_210258_() != junctions.get(1).m_210258_())) {
                return List.of(new ChunkPos(new BlockPos((junctions.get(0).m_210252_() + junctions.get(1).m_210252_()) / 2, 0, (junctions.get(0).m_210258_() + junctions.get(1).m_210258_()) / 2)));
            }
            return List.of();
        }
    }
}

