/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;

public record RegionPos(int x, int z) {
    public static final Codec<RegionPos> CODEC = Codec.STRING.xmap(RegionPos::of, RegionPos::toString);
    public static final int CHUNK_POWER = 5;
    public static final int CHUNK_SIZE = 32;
    public static final int CHUNK_AREA = 1024;
    public static final int BLOCK_POWER = 9;
    public static final int BLOCK_SIZE = 512;
    public static final int BLOCK_AREA = 262144;

    public static int regionRelative(int xz) {
        return xz & 0x1F;
    }

    public static int regionToChunk(int xz) {
        return xz << 5;
    }

    public static int chunkToRegion(int xz) {
        return xz >> 5;
    }

    public static int regionToBlock(int xz) {
        return xz << 9;
    }

    public static int blockToRegion(int xz) {
        return xz >> 9;
    }

    public static int chunkToBit(int relativeChunkX, int relativeChunkZ) {
        return (relativeChunkX << 5) + relativeChunkZ;
    }

    public static int chunkToBit(ChunkPos pos) {
        return RegionPos.chunkToBit(RegionPos.regionRelative(pos.f_45578_), RegionPos.regionRelative(pos.f_45579_));
    }

    public static int bitToX(int bit) {
        return bit >> 5;
    }

    public static int bitToZ(int bit) {
        return bit & 0x1F;
    }

    public static RegionPos of(BlockPos pos) {
        return new RegionPos(RegionPos.blockToRegion(pos.m_123341_()), RegionPos.blockToRegion(pos.m_123343_()));
    }

    public static RegionPos of(ChunkPos pos) {
        return new RegionPos(RegionPos.chunkToRegion(pos.f_45578_), RegionPos.chunkToRegion(pos.f_45579_));
    }

    public static RegionPos of(long pos) {
        return new RegionPos((int)pos, (int)(pos >> 32));
    }

    public static RegionPos of(String pos) {
        return new RegionPos(Integer.parseInt(pos.split(",")[0]), Integer.parseInt(pos.split(",")[1]));
    }

    @Override
    @NotNull
    public String toString() {
        return this.x + "," + this.z;
    }

    public int chunkX() {
        return RegionPos.regionToChunk(this.x);
    }

    public int chunkZ() {
        return RegionPos.regionToChunk(this.z);
    }

    public int blockX() {
        return RegionPos.regionToBlock(this.x);
    }

    public int blockZ() {
        return RegionPos.regionToBlock(this.z);
    }

    public long toLong() {
        return ChunkPos.m_45589_((int)this.x, (int)this.z);
    }

    public ChunkPos toChunk() {
        return new ChunkPos(this.chunkX(), this.chunkZ());
    }

    public BlockPos toBlock(int y) {
        return new BlockPos(this.blockX(), y, this.blockZ());
    }

    public ChunkPos toChunk(int relativeChunkX, int relativeChunkZ) {
        return new ChunkPos(this.chunkX() + relativeChunkX, this.chunkZ() + relativeChunkZ);
    }

    public ChunkPos toChunk(int bit) {
        return this.toChunk(RegionPos.bitToX(bit), RegionPos.bitToZ(bit));
    }

    public Set<ChunkPos> toChunks(BitSet bits) {
        return bits.stream().mapToObj(this::toChunk).collect(Collectors.toSet());
    }

    public Set<ChunkPos> toChunks() {
        return IntStream.range(0, 256).mapToObj(this::toChunk).collect(Collectors.toSet());
    }

    public void forXZ(BiConsumer<Integer, Integer> action) {
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                action.accept(x, z);
            }
        }
    }

    public static Map<RegionPos, BitSet> chunksToRegions(Iterable<ChunkPos> chunks) {
        LinkedHashMap<RegionPos, BitSet> map = new LinkedHashMap<RegionPos, BitSet>();
        chunks.forEach(chunk -> map.computeIfAbsent(RegionPos.of(chunk), r -> new BitSet(1024)).set(RegionPos.chunkToBit(chunk)));
        return map;
    }

    public static Set<ChunkPos> regionsToChunks(Map<RegionPos, BitSet> chunks) {
        LinkedHashSet<ChunkPos> outSet = new LinkedHashSet<ChunkPos>();
        chunks.entrySet().stream().flatMap(e -> ((RegionPos)e.getKey()).toChunks((BitSet)e.getValue()).stream()).forEach(outSet::add);
        return outSet;
    }
}

