/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.util.RegionPos;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.chunk.ChunkAccess;

public class ChunkUtil {
    public static Integer airCount(ChunkAccess chunk) {
        return Arrays.stream(chunk.m_7103_()).mapToInt(s -> 4096 - s.f_62969_).sum();
    }

    public static Map<RegionPos, File> getRegionFiles(File folder, String prefix) {
        HashMap<RegionPos, File> files = new HashMap<RegionPos, File>();
        for (File file : Objects.requireNonNullElse(folder.listFiles(), new File[0])) {
            String[] split = file.getName().split("\\.");
            if (split.length != 4 || !split[0].equals(prefix) || !split[3].equals("dat")) continue;
            try {
                files.put(new RegionPos(Integer.parseInt(split[1]), Integer.parseInt(split[2])), file);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return files;
    }

    public static Map<RegionPos, CompoundTag> getRegionNbt(File folder, String prefix) {
        Map<RegionPos, File> regionFiles = ChunkUtil.getRegionFiles(folder, prefix);
        HashMap<RegionPos, CompoundTag> regions = new HashMap<RegionPos, CompoundTag>();
        for (RegionPos regionPos : regionFiles.keySet()) {
            CompoundTag regionCompound = null;
            try {
                regionCompound = NbtIo.m_128937_((File)regionFiles.get(regionPos));
            }
            catch (IOException | ReportedException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading region nbt file {}.", (Object)regionFiles.get(regionPos).getName(), (Object)e);
            }
            if (regionCompound == null) continue;
            regions.put(regionPos, regionCompound);
        }
        return regions;
    }
}

