/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.DimensionSupport;
import folk.sisby.surveyor.util.RegionPos;
import folk.sisby.surveyor.util.RegistryPalette;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class RegionSummary {
    public static final String KEY_BIOMES = "biomes";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_BIOME_WATER = "biomeWater";
    public static final String KEY_BIOME_FOLIAGE = "biomeFoliage";
    public static final String KEY_BIOME_GRASS = "biomeGrass";
    public static final String KEY_BLOCK_COLORS = "blockColors";
    public static final String KEY_CHUNKS = "chunks";
    protected final RegionPos regionPos;
    protected final File saveFile;
    protected final RegistryAccess manager;
    @Nullable
    protected RegistryPalette<Biome> biomePalette;
    @Nullable
    protected RegistryPalette<Block> blockPalette;
    @Nullable
    protected ChunkSummary[][] chunks;
    @Nullable
    protected BitSet bitSet;
    protected boolean dirty = false;
    protected boolean saving = false;

    private RegionSummary(RegistryAccess manager, File saveFile, RegionPos regionPos, ChunkSummary[][] chunks, BitSet bitSet, RegistryPalette<Biome> biomePalette, RegistryPalette<Block> blockPalette) {
        this.manager = manager;
        this.biomePalette = biomePalette;
        this.blockPalette = blockPalette;
        this.saveFile = saveFile;
        this.regionPos = regionPos;
        this.chunks = chunks;
        this.bitSet = bitSet;
        if (bitSet == null) {
            this.readNbt(regionPos, true);
        }
    }

    public static <T, O> List<O> mapIterable(Iterable<T> palette, Function<T, O> mapper) {
        ArrayList<O> list = new ArrayList<O>();
        for (T value : palette) {
            list.add(mapper.apply(value));
        }
        return list;
    }

    public static RegionSummary fromEmpty(File folder, RegionPos rPos, RegistryAccess manager) {
        return new RegionSummary(manager, new File(folder, "c.%d.%d.dat".formatted(rPos.x(), rPos.z())), rPos, new ChunkSummary[32][32], new BitSet(1024), new RegistryPalette<Biome>(manager.m_175515_(Registries.f_256952_)), new RegistryPalette<Block>(manager.m_175515_(Registries.f_256747_)));
    }

    public static RegionSummary fromFile(File file, RegistryAccess manager, RegionPos rPos) {
        return new RegionSummary(manager, file, rPos, null, null, null, null);
    }

    protected void readNbt(RegionPos pos, boolean bitsOnly) {
        Registry biomeRegistry = this.manager.m_175515_(Registries.f_256952_);
        Registry blockRegistry = this.manager.m_175515_(Registries.f_256747_);
        CompoundTag nbt = new CompoundTag();
        try {
            nbt = NbtIo.m_128937_((File)this.saveFile);
        }
        catch (IOException | ReportedException e) {
            Surveyor.LOGGER.error("[Surveyor] Error reading region summary file {}.", (Object)this.saveFile.getName(), (Object)e);
        }
        CompoundTag chunksCompound = nbt.m_128469_(KEY_CHUNKS);
        this.bitSet = new BitSet(1024);
        if (bitsOnly) {
            for (String posKey : chunksCompound.m_128431_()) {
                int x = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[0]));
                int z = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[1]));
                this.bitSet.set(RegionPos.chunkToBit(x, z));
            }
            return;
        }
        this.biomePalette = new RegistryPalette(this.manager.m_175515_(Registries.f_256952_));
        this.blockPalette = new RegistryPalette(this.manager.m_175515_(Registries.f_256747_));
        this.chunks = new ChunkSummary[32][32];
        ListTag biomeList = nbt.m_128437_(KEY_BIOMES, 8);
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap(biomeList.size());
        for (int i = 0; i < biomeList.size(); ++i) {
            ResourceLocation biomeId = new ResourceLocation(biomeList.get(i).m_7916_());
            Biome biome = (Biome)biomeRegistry.m_7745_(biomeId);
            Biome newBiome = biome == null ? (Biome)biomeRegistry.m_6246_(Biomes.f_48173_) : biome;
            int newIndex = this.biomePalette.findOrAdd(newBiome);
            if (biome != null && newIndex == i) continue;
            if (biome == null) {
                Surveyor.LOGGER.warn("[Surveyor] Remapping biome palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, biomeId, i, biomeRegistry.m_7981_((Object)newBiome), newIndex});
            }
            biomeRemap.put(i, newIndex);
            this.dirty();
        }
        ListTag blockList = nbt.m_128437_(KEY_BLOCKS, 8);
        Int2IntArrayMap blockRemap = new Int2IntArrayMap(blockList.size());
        for (int i = 0; i < blockList.size(); ++i) {
            ResourceLocation blockId = new ResourceLocation(blockList.get(i).m_7916_());
            Block block = (Block)blockRegistry.m_7745_(blockId);
            Block newBlock = block == null ? Blocks.f_50016_ : block;
            int newIndex = this.blockPalette.findOrAdd(newBlock);
            if (block != null && newIndex == i) continue;
            if (block == null) {
                Surveyor.LOGGER.warn("[Surveyor] Remapping block palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, blockList.get(i).m_7916_(), i, blockRegistry.m_7981_((Object)newBlock), newIndex});
            }
            blockRemap.put(i, newIndex);
            this.dirty();
        }
        if (this.biomePalette.view().m_13562_() == 0 || this.blockPalette.view().m_13562_() == 0) {
            Surveyor.LOGGER.warn("[Surveyor] Palette was empty in region {}, skipping data load!", (Object)this.regionPos);
            return;
        }
        for (String posKey : chunksCompound.m_128431_()) {
            int x = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[0]));
            int z = RegionPos.regionRelative(Integer.parseInt(posKey.split(",")[1]));
            ChunkSummary summary = new ChunkSummary(chunksCompound.m_128469_(posKey));
            this.set(x, z, summary);
            if (biomeRemap.isEmpty() && blockRemap.isEmpty()) continue;
            summary.remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
        }
    }

    public boolean contains(ChunkPos pos) {
        return this.bitSet().get(RegionPos.chunkToBit(pos));
    }

    public ChunkSummary get(ChunkPos pos) {
        if (!this.contains(pos)) {
            return null;
        }
        return this.get(RegionPos.regionRelative(pos.f_45578_), RegionPos.regionRelative(pos.f_45579_));
    }

    @Nullable
    protected ChunkSummary get(int x, int z) {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        return this.chunks[x][z];
    }

    protected void set(int x, int z, ChunkSummary summary) {
        if (this.chunks == null || this.bitSet == null) {
            this.readNbt(this.regionPos, false);
        }
        this.chunks[x][z] = summary;
        this.bitSet.set(RegionPos.chunkToBit(x, z), summary != null);
    }

    public BitSet bitSet() {
        if (this.bitSet == null) {
            this.readNbt(this.regionPos, true);
        }
        return (BitSet)this.bitSet.clone();
    }

    public void putChunk(Level world, LevelChunk chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        if (world.m_141928_() == 0) {
            return;
        }
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        this.set(RegionPos.regionRelative(chunk.m_7697_().f_45578_), RegionPos.regionRelative(chunk.m_7697_().f_45579_), new ChunkSummary(world, chunk, DimensionSupport.getSummaryLayers(world), this.biomePalette, this.blockPalette, !(world instanceof ServerLevel)));
        this.dirty();
    }

    public boolean isUnloaded(Level world) {
        return this.regionPos.toChunks().stream().noneMatch(c -> world.m_7232_(c.f_45578_, c.f_45579_));
    }

    public void save(boolean unload) {
        if (this.saving) {
            return;
        }
        if (!this.isDirty()) {
            if (unload) {
                this.chunks = null;
            }
            return;
        }
        CompoundTag nbt = new CompoundTag();
        Registry biomeRegistry = this.manager.m_175515_(Registries.f_256952_);
        Registry blockRegistry = this.manager.m_175515_(Registries.f_256747_);
        nbt.m_128365_(KEY_BIOMES, (Tag)new ListTag(RegionSummary.mapIterable(this.biomePalette.view(), b -> StringTag.m_129297_((String)biomeRegistry.m_7981_(b).toString())), 8));
        nbt.m_128365_(KEY_BLOCKS, (Tag)new ListTag(RegionSummary.mapIterable(this.blockPalette.view(), b -> StringTag.m_129297_((String)blockRegistry.m_7981_(b).toString())), 8));
        nbt.m_128408_(KEY_BIOME_WATER, RegionSummary.mapIterable(this.biomePalette.view(), Biome::m_47560_));
        nbt.m_128408_(KEY_BIOME_FOLIAGE, RegionSummary.mapIterable(this.biomePalette.view(), Biome::m_47542_));
        nbt.m_128408_(KEY_BIOME_GRASS, RegionSummary.mapIterable(this.biomePalette.view(), b -> b.m_47464_(0.0, 0.0)));
        nbt.m_128408_(KEY_BLOCK_COLORS, RegionSummary.mapIterable(this.blockPalette.view(), b -> b.m_284356_().f_283871_));
        CompoundTag chunksCompound = new CompoundTag();
        this.regionPos.forXZ((x, z) -> {
            ChunkSummary chunk = this.get((int)x, (int)z);
            if (chunk != null) {
                ChunkPos pos = this.regionPos.toChunk((int)x, (int)z);
                chunksCompound.m_128365_("%s,%s".formatted(pos.f_45578_, pos.f_45579_), (Tag)chunk.writeNbt(new CompoundTag()));
            }
        });
        nbt.m_128365_(KEY_CHUNKS, (Tag)chunksCompound);
        this.dirty = false;
        this.saving = true;
        Util.m_183992_().execute(() -> {
            try {
                NbtIo.m_128944_((CompoundTag)nbt, (File)this.saveFile);
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing region summary file {}.", (Object)this.saveFile.getName(), (Object)e);
            }
            finally {
                if (unload && !this.dirty) {
                    this.chunks = null;
                }
                this.saving = false;
            }
        });
    }

    public BitSet readUpdatePacket(S2CUpdateRegionPacket packet) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return new BitSet();
        }
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        if (packet.biomePalette().isEmpty() || packet.blockPalette().isEmpty()) {
            return new BitSet();
        }
        Registry biomeRegistry = this.manager.m_175515_(Registries.f_256952_);
        Registry blockRegistry = this.manager.m_175515_(Registries.f_256747_);
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.biomePalette().size(); ++i) {
            biomeRemap.put(i, this.biomePalette.findOrAdd((Biome)biomeRegistry.m_7942_(packet.biomePalette().get(i).intValue())));
        }
        Int2IntArrayMap blockRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.blockPalette().size(); ++i) {
            blockRemap.put(i, this.blockPalette.findOrAdd((Block)blockRegistry.m_7942_(packet.blockPalette().get(i).intValue())));
        }
        int[] indices = packet.set().stream().toArray();
        for (int i = 0; i < packet.chunks().size(); ++i) {
            ChunkSummary summary = packet.chunks().get(i);
            summary.remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
            this.set(RegionPos.bitToX(indices[i]), RegionPos.bitToZ(indices[i]), summary);
        }
        this.dirty();
        return packet.set();
    }

    public S2CUpdateRegionPacket createUpdatePacket(boolean shared, RegionPos rPos, BitSet set) {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        BitSet realSet = (BitSet)set.clone();
        realSet.and(this.bitSet);
        return new S2CUpdateRegionPacket(shared, rPos, RegionSummary.mapIterable(this.biomePalette, i -> i), RegionSummary.mapIterable(this.blockPalette, i -> i), realSet, realSet.stream().mapToObj(i -> this.get(RegionPos.bitToX(i), RegionPos.bitToZ(i))).toList());
    }

    public RegistryPalette.ValueView getBiomePalette() {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        return this.biomePalette.view();
    }

    public RegistryPalette.ValueView getBlockPalette() {
        if (this.chunks == null) {
            this.readNbt(this.regionPos, false);
        }
        return this.blockPalette.view();
    }

    public boolean isLoaded() {
        return this.chunks != null;
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.terrain != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }
}

