/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.packet.SyncPacket;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public record SyncLandmarksAddedPacket(Map<UUID, Map<ResourceLocation, Landmark>> landmarks) implements SyncPacket
{
    public static final ResourceLocation ID = Surveyor.id("landmarks_added");

    public static SyncLandmarksAddedPacket of(Multimap<UUID, ResourceLocation> keySet, WorldLandmarks summary) {
        return summary.createUpdatePacket(keySet);
    }

    public static SyncLandmarksAddedPacket read(FriendlyByteBuf buf) {
        return new SyncLandmarksAddedPacket((Map)((Pair)WorldLandmarks.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow()).getFirst());
    }

    @Override
    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130079_((CompoundTag)WorldLandmarks.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.landmarks).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow());
    }

    @Override
    public Collection<FriendlyByteBuf> toBufs() {
        ArrayList<FriendlyByteBuf> bufs = new ArrayList<FriendlyByteBuf>();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.writeBuf(buf);
        if (buf.readableBytes() < 0x100000) {
            bufs.add(buf);
        } else {
            Multimap<UUID, ResourceLocation> keySet = MapUtil.keyMultiMap(this.landmarks);
            if (keySet.size() == 1) {
                Surveyor.LOGGER.error("Couldn't create a landmark update packet for {} at {} - an individual landmark would be too large to send!", keySet.keys().stream().findFirst().orElseThrow(), keySet.values().stream().findFirst().orElseThrow());
                return List.of();
            }
            HashMultimap firstHalf = HashMultimap.create();
            HashMultimap secondHalf = HashMultimap.create();
            keySet.forEach((arg_0, arg_1) -> SyncLandmarksAddedPacket.lambda$toBufs$0((Multimap)firstHalf, keySet, (Multimap)secondHalf, arg_0, arg_1));
            bufs.addAll(new SyncLandmarksAddedPacket(MapUtil.splitByKeyMap(this.landmarks, firstHalf)).toBufs());
            bufs.addAll(new SyncLandmarksAddedPacket(MapUtil.splitByKeyMap(this.landmarks, secondHalf)).toBufs());
        }
        return bufs;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    private static /* synthetic */ void lambda$toBufs$0(Multimap firstHalf, Multimap keySet, Multimap secondHalf, UUID key, ResourceLocation pos) {
        if (firstHalf.size() < keySet.size() / 2) {
            firstHalf.put((Object)key, (Object)pos);
        } else {
            secondHalf.put((Object)key, (Object)pos);
        }
    }
}

