/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.mixin;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorWorld;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class MixinServerWorld
implements SurveyorWorld {
    @Unique
    private WorldSummary surveyor$summary = null;

    @Override
    public WorldSummary surveyor$getSummary() {
        return this.surveyor$summary;
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/world/level/storage/ServerLevelData;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/world/level/dimension/LevelStem;Lnet/minecraft/server/level/progress/ChunkProgressListener;ZJLjava/util/List;ZLnet/minecraft/world/RandomSequences;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/dimension/LevelStem;f_63976_()Lnet/minecraft/world/level/chunk/ChunkGenerator;")})
    public void loadSummary(CallbackInfo ci) {
        ServerLevel self = (ServerLevel)this;
        this.surveyor$summary = WorldSummary.load((Level)self, Surveyor.getSavePath((ResourceKey<Level>)self.m_46472_(), self.m_7654_()), false);
        SurveyorEvents.Invoke.worldLoad(self);
    }

    @Inject(method={"m_215076_(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Holder;)V"}, at={@At(value="HEAD")})
    public void onPointOfInterestAdded(BlockPos blockPos, Holder<PoiType> poiType, CallbackInfo ci) {
        ServerLevel self = (ServerLevel)this;
        WorldSummary summary = WorldSummary.of((Level)self);
        if (summary.landmarks() == null) {
            return;
        }
        if (poiType.m_203543_().isEmpty() || !Surveyor.CONFIG.builtins.poiLandmarks.contains(((ResourceKey)poiType.m_203543_().get()).m_135782_().toString())) {
            return;
        }
        ResourceLocation poi = ((ResourceKey)poiType.m_203543_().get()).m_135782_();
        summary.landmarks().put((Level)self, Landmark.global(ResourceLocation.m_214293_((String)poi.m_135827_(), (String)"poi/%s/%s/%s/%s".formatted(poi.m_135815_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())), builder -> LandmarkComponentTypes.forBlock(builder, (LevelAccessor)self, blockPos)));
    }

    @Inject(method={"m_207559_(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    public void onPointOfInterestRemoved(BlockPos blockPos, CallbackInfo ci) {
        ServerLevel self = (ServerLevel)this;
        WorldSummary summary = WorldSummary.of((Level)self);
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().removeAll((Level)self, l -> l.owner().equals(WorldLandmarks.GLOBAL) && l.id().m_135815_().startsWith("poi") && l.components().contains(LandmarkComponentTypes.POS) && l.components().get(LandmarkComponentTypes.POS).equals((Object)blockPos));
    }
}

