/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.mixin;

import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorPlayer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.util.TextUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class MixinServerPlayerEntity
implements SurveyorPlayer {
    @Unique
    PlayerSummary.ServerPlayerEntitySummary surveyor$summary = null;

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerLevel;Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    public void init(MinecraftServer server, ServerLevel world, GameProfile profile, CallbackInfo ci) {
        ServerPlayer self = (ServerPlayer)this;
        this.surveyor$summary = new PlayerSummary.ServerPlayerEntitySummary(self);
    }

    @Inject(method={"m_7380_(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void writeSurveyorData(CompoundTag nbt, CallbackInfo ci) {
        ServerPlayer self = (ServerPlayer)this;
        this.surveyor$summary.writeNbt(nbt);
        ServerSummary.of(self.m_20194_()).updatePlayer(Surveyor.getUuid(self), nbt, false, self.m_20194_());
    }

    @Inject(method={"m_7378_(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readSurveyorData(CompoundTag nbt, CallbackInfo ci) {
        this.surveyor$summary.read(nbt);
    }

    @Inject(method={"m_9156_(Lnet/minecraft/network/protocol/game/ServerboundClientInformationPacket;)V"}, at={@At(value="HEAD")})
    public void setSurveyorViewDistance(ServerboundClientInformationPacket packet, CallbackInfo ci) {
        this.surveyor$summary.setViewDistance(packet.f_133864_());
    }

    @Inject(method={"m_6667_(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatTracker;m_19296_()V")})
    public void onDeath(DamageSource damageSource, CallbackInfo ci) {
        if (!Surveyor.CONFIG.builtins.playerDeathWaypoints) {
            return;
        }
        ServerPlayer self = (ServerPlayer)this;
        WorldLandmarks summary = WorldSummary.of((Level)self.m_284548_()).landmarks();
        if (summary == null) {
            return;
        }
        summary.put((Level)self.m_284548_(), Landmark.createIncremental(summary, Surveyor.getUuid(self), Surveyor.id("grave"), builder -> builder.add(LandmarkComponentTypes.POS, self.m_20183_()).add(LandmarkComponentTypes.NAME, TextUtil.stripInteraction(self.m_21231_().m_19293_())).add(LandmarkComponentTypes.TIME, self.m_9236_().m_46468_()).add(LandmarkComponentTypes.SEED, self.m_217043_().m_188502_())));
    }

    @Inject(method={"m_9015_(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="TAIL")})
    public void copyFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        this.surveyor$summary.copyFrom(PlayerSummary.of(oldPlayer));
    }

    @Override
    public PlayerSummary surveyor$getSummary() {
        return this.surveyor$summary;
    }
}

