/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark.component;

import com.mojang.serialization.Codec;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.component.LandmarkComponentMap;
import folk.sisby.surveyor.landmark.component.LandmarkComponentType;
import folk.sisby.surveyor.util.RegionPos;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.MapColor;

public class LandmarkComponentTypes {
    public static final LandmarkComponentType<BlockPos> POS = LandmarkComponentTypes.register("pos", BlockPos.f_121852_, (T p) -> Component.m_237113_((String)"[").m_7220_((Component)Component.m_237113_((String)p.m_123344_()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"]")));
    public static final LandmarkComponentType<Component> NAME = LandmarkComponentTypes.register("name", ExtraCodecs.f_252442_, (T t) -> Component.m_237113_((String)"\"").m_7220_((Component)t.m_6881_().m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\"")));
    public static final LandmarkComponentType<List<Component>> LORE = LandmarkComponentTypes.register("lore", Codec.list((Codec)ExtraCodecs.f_252442_), (T l) -> ComponentUtils.m_178436_((Collection)l, (Component)Component.m_237113_((String)"\" | \""), t -> t.m_6881_().m_130940_(ChatFormatting.GREEN)));
    public static final LandmarkComponentType<Integer> COLOR = LandmarkComponentTypes.register("color", Codec.INT, (T i) -> Component.m_237113_((String)"#").m_6270_(Style.f_131099_.m_178520_(0xFFFFFF & i)).m_7220_((Component)Component.m_237113_((String)Integer.toHexString(0xFFFFFF & i).toUpperCase()).m_130940_(ChatFormatting.GOLD)));
    public static final LandmarkComponentType<Long> TIME = LandmarkComponentTypes.register("time", Codec.LONG, (T tick) -> Component.m_130674_((String)"Day %d, %d:%02d".formatted(1L + tick / 24000L, (6000L + tick) % 24000L / 1000L, tick % 1000L > 500L ? 30 : 0)));
    public static final LandmarkComponentType<Integer> SEED = LandmarkComponentTypes.register("seed", Codec.INT, (T i) -> Component.m_237113_((String)String.valueOf(i)).m_130940_(ChatFormatting.GOLD));
    public static final LandmarkComponentType<BoundingBox> BOX = LandmarkComponentTypes.register("box", BoundingBox.f_162354_, (T b) -> Component.m_237113_((String)"[").m_7220_((Component)Component.m_237113_((String)new BlockPos(b.m_162395_(), b.m_162396_(), b.m_162398_()).m_123344_()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"]->[")).m_7220_((Component)Component.m_237113_((String)new BlockPos(b.m_162399_(), b.m_162400_(), b.m_162401_()).m_123344_()).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"]")));
    public static final LandmarkComponentType<ItemStack> STACK = LandmarkComponentTypes.register("stack", ItemStack.f_41582_, (T s) -> Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"[")).m_7220_((Component)s.m_41720_().m_41466_().m_6881_().m_130940_(s.m_41791_().f_43022_)).m_7220_((Component)Component.m_237113_((String)"]")).m_7220_((Component)(s.m_41788_() ? Component.m_237113_((String)" - \"").m_7220_((Component)s.m_41786_().m_6881_().m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\"")) : Component.m_237113_((String)""))));
    public static final LandmarkComponentType<Map<RegionPos, BitSet>> CHUNKS = LandmarkComponentTypes.register("chunks", Codec.unboundedMap(RegionPos.CODEC, (Codec)ExtraCodecs.f_252419_), (T m) -> Component.m_237113_((String)"%d chunks".formatted(m.values().stream().mapToInt(BitSet::cardinality).sum())).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)RegionPos.regionsToChunks(m).stream().map(ChunkPos::toString).collect(Collectors.joining(", ")))))));

    public static LandmarkComponentMap.Builder forBlock(LandmarkComponentMap.Builder builder, LevelAccessor world, BlockPos pos) {
        int color;
        BlockState state = world.m_8055_(pos);
        ItemStack stack = state.m_60734_().m_7397_((BlockGetter)world, pos, world.m_8055_(pos));
        BlockEntity entity = world.m_7702_(pos);
        if (entity != null && BuiltInRegistries.f_257049_.m_7854_((Object)entity.m_58903_()).map(t -> Surveyor.CONFIG.builtins.allowedBlockEntities.contains(t.toString())).orElse(false).booleanValue()) {
            BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)entity.m_58903_(), (CompoundTag)entity.m_187482_());
        }
        builder.add(NAME, !stack.m_41619_() ? stack.m_41786_() : state.m_60734_().m_49954_());
        if (!stack.m_41619_()) {
            builder.add(STACK, stack);
        }
        if ((color = state.m_284242_((BlockGetter)world, pos).m_284280_(MapColor.Brightness.HIGH)) != 0) {
            builder.add(COLOR, color);
        }
        builder.add(POS, pos);
        return builder;
    }

    private static <T> LandmarkComponentType<T> register(String path, Codec<T> codec, Function<T, Component> viewer) {
        return LandmarkComponentTypes.register(Surveyor.id(path), codec, viewer);
    }

    public static <T> LandmarkComponentType<T> register(ResourceLocation id, Codec<T> codec, Function<T, Component> viewer) {
        LandmarkComponentType<T> type = new LandmarkComponentType<T>(id, codec, viewer);
        LandmarkComponentType.register(type);
        return type;
    }

    public static void touch() {
    }
}

