/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.util.DispatchMapCodec;
import folk.sisby.surveyor.util.MapUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WorldLandmarks {
    public static final UUID GLOBAL = UUID.fromString("99999999-9999-9999-9999-999999999999");
    public static final String KEY_LANDMARKS = "landmarks";
    public static final String KEY_REMOVED = "removed";
    public static final Codec<Map<UUID, Map<ResourceLocation, Landmark>>> CODEC = DispatchMapCodec.of(UUIDUtil.f_260719_, uuid -> DispatchMapCodec.of(ResourceLocation.f_135803_, id -> Landmark.createCodec(uuid, id)));
    public static final Codec<Multimap<UUID, ResourceLocation>> REMOVED_CODEC = Codec.unboundedMap((Codec)UUIDUtil.f_260719_, (Codec)Codec.list((Codec)ResourceLocation.f_135803_)).xmap(MapUtil::asMultiMap, MapUtil::asListMap);
    public static final int[] XAERO_COLORS = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -22016, -5592406, -11184811, -11184641, -11141291, -11141121, -65536, -43521, -171, -1};
    protected final ResourceKey<Level> worldKey;
    protected final Map<UUID, Map<ResourceLocation, Landmark>> landmarks = new ConcurrentHashMap<UUID, Map<ResourceLocation, Landmark>>();
    @Nullable
    protected final Multimap<UUID, ResourceLocation> removed;
    protected boolean dirty;

    public WorldLandmarks(ResourceKey<Level> worldKey, Map<UUID, Map<ResourceLocation, Landmark>> landmarks, Multimap<UUID, ResourceLocation> removed, boolean dirty) {
        this.worldKey = worldKey;
        this.landmarks.putAll(landmarks);
        Multimap<UUID, ResourceLocation> multimap = this.removed = removed == null ? null : Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(removed));
        if (this.removed != null) {
            this.landmarks.forEach((uuid, map) -> map.keySet().forEach(id -> removed.remove(uuid, id)));
        }
        this.dirty = dirty;
    }

    public static WorldLandmarks load(Level world, File folder, boolean isClient) {
        CompoundTag landmarkNbt = new CompoundTag();
        File landmarksFile = new File(folder, "landmarks.dat");
        if (landmarksFile.exists()) {
            try {
                landmarkNbt = NbtIo.m_128937_((File)landmarksFile);
            }
            catch (IOException | ReportedException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading landmarks file for {}.", (Object)world.m_46472_().m_135782_(), (Object)e);
            }
        }
        WorldLandmarks worldLandmarks = WorldLandmarks.fromNbt(world, landmarkNbt, landmarksFile, isClient);
        if (!isClient) {
            worldLandmarks.tryMigrateXaeros(world, false);
        }
        return worldLandmarks;
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        nbt.m_128365_(KEY_LANDMARKS, (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.landmarks).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow());
        if (this.removed != null) {
            nbt.m_128365_(KEY_REMOVED, (Tag)REMOVED_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.removed).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow());
        }
        return nbt;
    }

    public static WorldLandmarks fromNbt(Level world, CompoundTag nbt, File landmarksFile, boolean isClient) {
        CompoundTag landmarks = nbt.m_128469_(KEY_LANDMARKS);
        boolean dirty = false;
        HashMap<UUID, Map<ResourceLocation, Landmark>> outMap = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
        Multimap removedMap = null;
        if (landmarks.m_128431_().stream().anyMatch(k -> k.contains(":"))) {
            Surveyor.LOGGER.warn("[Surveyor] Partially recovering landmarks from 0.X");
            try {
                Files.copy(landmarksFile.toPath(), landmarksFile.toPath().resolveSibling("landmarks.dat_v0"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Surveyor failed to back up v0 landmarks, was the file locked?", e);
            }
            try {
                for (String key : landmarks.m_128431_()) {
                    CompoundTag type = landmarks.m_128469_(key);
                    ResourceLocation typeId = ResourceLocation.m_135820_((String)key);
                    for (String coords : type.m_128431_()) {
                        CompoundTag landmark = type.m_128469_(coords);
                        UUID owner = landmark.m_128441_("owner") ? (UUID)((Pair)UUIDUtil.f_252480_.decode((DynamicOps)NbtOps.f_128958_, (Object)landmark.m_128423_("owner")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow()).getFirst() : GLOBAL;
                        BlockPos pos = new BlockPos(Integer.parseInt(coords.split(",")[0]), Integer.parseInt(coords.split(",")[1]), Integer.parseInt(coords.split(",")[2]));
                        DyeColor dye = !landmark.m_128441_("color") ? null : (DyeColor)DyeColor.f_262211_.decode((DynamicOps)NbtOps.f_128958_, (Object)landmark.m_128423_("color")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(null);
                        ResourceLocation id = (landmark.m_128441_("texture") ? ResourceLocation.m_135820_((String)landmark.m_128461_("texture")) : typeId).m_266382_((String)(dye == null ? "" : "/" + dye.m_41065_()) + "/" + pos.m_123341_() + (String)(pos.m_123342_() == 0 ? "" : "/" + pos.m_123342_()) + "/" + pos.m_123343_());
                        outMap.computeIfAbsent(owner, u -> new HashMap()).put(id, Landmark.create(owner, id, b -> b.add(LandmarkComponentTypes.POS, pos).add(LandmarkComponentTypes.BOX, !landmark.m_128441_("box") ? null : (BoundingBox)BoundingBox.f_162354_.decode((DynamicOps)NbtOps.f_128958_, (Object)landmark.m_128423_("box")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(null)).add(LandmarkComponentTypes.COLOR, dye == null ? null : Integer.valueOf(dye.m_41070_())).add(LandmarkComponentTypes.NAME, !landmark.m_128441_("name") ? null : (Component)ExtraCodecs.f_252442_.decode((DynamicOps)NbtOps.f_128958_, (Object)landmark.m_128423_("name")).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).map(Pair::getFirst).orElse(null)).add(LandmarkComponentTypes.SEED, !landmark.m_128441_("seed") ? null : Integer.valueOf(landmark.m_128451_("seed"))).add(LandmarkComponentTypes.TIME, !landmark.m_128441_("created") ? null : Long.valueOf(landmark.m_128454_("created")))));
                        dirty = true;
                    }
                }
                Surveyor.LOGGER.info("[Surveyor] Recovered {} landmarks from legacy data.", (Object)outMap.values().stream().mapToInt(Map::size).sum());
            }
            catch (Exception e) {
                Surveyor.LOGGER.error("[Surveyor] Encountered an error during v0 landmark migration, skipping...", (Throwable)e);
            }
        } else {
            CompoundTag removed;
            if (!landmarks.m_128456_()) {
                ((Map)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)landmarks).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow()).getFirst()).forEach((uuid, map) -> map.forEach((id, landmark) -> outMap.computeIfAbsent((UUID)uuid, u -> new HashMap()).put(id, landmark)));
            }
            if (!isClient && !(removed = nbt.m_128469_(KEY_REMOVED)).m_128456_()) {
                removedMap = (Multimap)((Pair)REMOVED_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)removed).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow()).getFirst();
            }
        }
        return new WorldLandmarks((ResourceKey<Level>)world.m_46472_(), outMap, removedMap, dirty);
    }

    public boolean contains(UUID uuid, ResourceLocation id) {
        return this.landmarks.containsKey(uuid) && this.landmarks.get(uuid).containsKey(id);
    }

    @Nullable
    public Landmark get(UUID uuid, ResourceLocation id) {
        return this.contains(uuid, id) ? this.landmarks.get(uuid).get(id) : null;
    }

    public <T extends Landmark> Map<ResourceLocation, T> asMap(UUID uuid, SurveyorExploration exploration) {
        HashMap outMap = new HashMap();
        if (this.landmarks.containsKey(uuid)) {
            this.landmarks.get(uuid).forEach((id, landmark) -> {
                if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark)landmark)) {
                    outMap.put(id, landmark);
                }
            });
        }
        return outMap;
    }

    public Map<UUID, Map<ResourceLocation, Landmark>> asMap(SurveyorExploration exploration) {
        HashMap<UUID, Map<ResourceLocation, Landmark>> outmap = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
        this.landmarks.forEach((uuid, map) -> map.forEach((id, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark)landmark)) {
                outmap.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
            }
        }));
        return outmap;
    }

    public Multimap<UUID, ResourceLocation> keySet(SurveyorExploration exploration) {
        HashMultimap outMap = HashMultimap.create();
        this.landmarks.forEach((arg_0, arg_1) -> this.lambda$keySet$15(exploration, (Multimap)outMap, arg_0, arg_1));
        return outMap;
    }

    public Multimap<UUID, ResourceLocation> removed() {
        HashMultimap outMap = HashMultimap.create();
        if (this.removed != null) {
            outMap.putAll(this.removed);
        }
        return outMap;
    }

    public void handleChanged(Level world, Map<UUID, Map<ResourceLocation, Landmark>> changed, boolean local, @Nullable ServerPlayer sender) {
        if (changed.isEmpty()) {
            return;
        }
        HashMap<UUID, Map<ResourceLocation, Landmark>> landmarksAddedChanged = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
        HashMap<UUID, Map> landmarksRemoved = new HashMap<UUID, Map>();
        changed.forEach((uuid, map) -> map.forEach((id, landmark) -> {
            if (this.contains((UUID)uuid, (ResourceLocation)id)) {
                landmarksAddedChanged.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
            } else {
                landmarksRemoved.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
            }
        }));
        if (!landmarksRemoved.isEmpty()) {
            SurveyorEvents.Invoke.landmarksRemoved(world, MapUtil.keyMultiMap(landmarksRemoved));
        }
        if (!landmarksAddedChanged.isEmpty()) {
            SurveyorEvents.Invoke.landmarksAdded(world, MapUtil.keyMultiMap(landmarksAddedChanged));
        }
        if (!local) {
            HashMap<UUID, Map> waypointsRemoved = new HashMap<UUID, Map>();
            HashMap<UUID, Map<ResourceLocation, Landmark>> waypointsAddedChanged = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
            landmarksRemoved.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                if (!landmark.owner().equals(GLOBAL)) {
                    waypointsRemoved.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
                }
            }));
            waypointsRemoved.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                ((Map)landmarksRemoved.get(uuid)).remove(id);
                if (((Map)landmarksRemoved.get(uuid)).isEmpty()) {
                    landmarksRemoved.remove(uuid);
                }
            }));
            landmarksAddedChanged.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                if (!landmark.owner().equals(GLOBAL)) {
                    waypointsAddedChanged.computeIfAbsent((UUID)uuid, t -> new HashMap()).put(id, landmark);
                }
            }));
            waypointsAddedChanged.forEach((uuid, map) -> map.forEach((id, landmark) -> {
                ((Map)landmarksAddedChanged.get(uuid)).remove(id);
                if (((Map)landmarksAddedChanged.get(uuid)).isEmpty()) {
                    landmarksAddedChanged.remove(uuid);
                }
            }));
            if (!landmarksRemoved.isEmpty()) {
                new SyncLandmarksRemovedPacket(MapUtil.keyMultiMap(landmarksRemoved)).send(sender, world, Surveyor.CONFIG.networking.landmarks);
            }
            if (!landmarksAddedChanged.isEmpty()) {
                new SyncLandmarksAddedPacket(landmarksAddedChanged).send(sender, world, Surveyor.CONFIG.networking.landmarks);
            }
            if (!waypointsRemoved.isEmpty()) {
                new SyncLandmarksRemovedPacket(MapUtil.keyMultiMap(waypointsRemoved)).send(sender, world, Surveyor.CONFIG.networking.waypoints);
            }
            if (!waypointsAddedChanged.isEmpty()) {
                new SyncLandmarksAddedPacket(waypointsAddedChanged).send(sender, world, Surveyor.CONFIG.networking.waypoints);
            }
        }
    }

    public Map<UUID, Map<ResourceLocation, Landmark>> putForBatch(Map<UUID, Map<ResourceLocation, Landmark>> changed, Landmark landmark) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return changed;
        }
        this.landmarks.computeIfAbsent(landmark.owner(), t -> new ConcurrentHashMap()).put(landmark.id(), landmark);
        if (this.removed != null) {
            this.removed.remove((Object)landmark.owner(), (Object)landmark.id());
        }
        this.dirty();
        changed.computeIfAbsent(landmark.owner(), t -> new HashMap()).put(landmark.id(), landmark);
        return changed;
    }

    public void putLocal(Level world, Landmark landmark) {
        this.handleChanged(world, this.putForBatch(new HashMap<UUID, Map<ResourceLocation, Landmark>>(), landmark), true, null);
    }

    public void put(Level world, Landmark landmark) {
        this.handleChanged(world, this.putForBatch(new HashMap<UUID, Map<ResourceLocation, Landmark>>(), landmark), false, null);
    }

    public void put(ServerPlayer sender, ServerLevel world, Landmark landmark) {
        this.handleChanged((Level)world, this.putForBatch(new HashMap<UUID, Map<ResourceLocation, Landmark>>(), landmark), false, sender);
    }

    public Map<UUID, Map<ResourceLocation, Landmark>> removeForBatch(Map<UUID, Map<ResourceLocation, Landmark>> changed, UUID uuid, ResourceLocation id) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return changed;
        }
        if (!this.landmarks.containsKey(uuid) || !this.landmarks.get(uuid).containsKey(id)) {
            return changed;
        }
        Landmark landmark = this.landmarks.get(uuid).remove(id);
        if (this.removed != null) {
            this.removed.put((Object)uuid, (Object)id);
        }
        if (this.landmarks.get(uuid).isEmpty()) {
            this.landmarks.remove(uuid);
        }
        this.dirty();
        changed.computeIfAbsent(uuid, t -> new HashMap()).put(id, landmark);
        return changed;
    }

    public void removeLocal(Level world, UUID uuid, ResourceLocation id) {
        this.handleChanged(world, this.removeForBatch(new HashMap<UUID, Map<ResourceLocation, Landmark>>(), uuid, id), true, null);
    }

    public void remove(Level world, UUID uuid, ResourceLocation id) {
        this.handleChanged(world, this.removeForBatch(new HashMap<UUID, Map<ResourceLocation, Landmark>>(), uuid, id), false, null);
    }

    public void remove(ServerPlayer sender, ServerLevel world, UUID uuid, ResourceLocation id) {
        this.handleChanged((Level)world, this.removeForBatch(new HashMap<UUID, Map<ResourceLocation, Landmark>>(), uuid, id), false, sender);
    }

    public Map<UUID, Map<ResourceLocation, Landmark>> removeAllForBatch(Map<UUID, Map<ResourceLocation, Landmark>> changed, Predicate<Landmark> predicate) {
        if (Surveyor.CONFIG.landmarks == SystemMode.FROZEN) {
            return null;
        }
        HashMultimap toRemove = HashMultimap.create();
        this.landmarks.forEach((arg_0, arg_1) -> WorldLandmarks.lambda$removeAllForBatch$34(predicate, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((uuid, id) -> this.removeForBatch(changed, (UUID)uuid, (ResourceLocation)id));
        return changed;
    }

    public void removeAll(Level world, Predicate<Landmark> predicate) {
        this.handleChanged(world, this.removeAllForBatch(new HashMap<UUID, Map<ResourceLocation, Landmark>>(), predicate), false, null);
    }

    public int save(Level world, File folder) {
        if (this.isDirty()) {
            File landmarksFile = new File(folder, "landmarks.dat");
            CompoundTag landmarksCompound = this.writeNbt(new CompoundTag());
            Util.m_183992_().execute(() -> {
                try {
                    NbtIo.m_128944_((CompoundTag)landmarksCompound, (File)landmarksFile);
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error writing landmarks file for {}.", (Object)world.m_46472_().m_135782_(), (Object)e);
                }
            });
            this.dirty = false;
            return this.landmarks.values().stream().mapToInt(Map::size).sum();
        }
        return 0;
    }

    public static boolean canModify(UUID landmark, Level world, @Nullable ServerPlayer player) {
        Level serverWorld;
        Object object = serverWorld = world.m_5776_() ? SurveyorClient.stealServerWorld((ResourceKey<Level>)world.m_46472_()) : world;
        if (serverWorld == null) {
            return landmark.equals(SurveyorClient.getClientUuid()) || Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.GROUP) && SurveyorClient.getSharedExploration().groupPlayers().contains(landmark);
        }
        return player == null || player.m_20310_(2) || landmark.equals(Surveyor.getUuid(player)) || ServerSummary.of(serverWorld.m_7654_()).getGroup(Surveyor.getUuid(player)).contains(landmark);
    }

    public Map<UUID, Map<ResourceLocation, Landmark>> readUpdatePacket(Level world, SyncLandmarksAddedPacket packet, @Nullable ServerPlayer sender) {
        HashMap<UUID, Map<ResourceLocation, Landmark>> changed = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
        packet.landmarks().forEach((uuid, map) -> map.forEach((id, landmark) -> {
            boolean waypoint;
            boolean bl = waypoint = !landmark.owner().equals(GLOBAL);
            if (sender == null || WorldLandmarks.canModify(landmark.owner(), world, sender) && (waypoint && Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.SOLO) || !waypoint && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO))) {
                this.putForBatch(changed, (Landmark)landmark);
            }
        }));
        if (!changed.isEmpty()) {
            this.handleChanged(world, changed, sender == null, sender);
        }
        return changed;
    }

    public Map<UUID, Map<ResourceLocation, Landmark>> readUpdatePacket(Level world, SyncLandmarksRemovedPacket packet, @Nullable ServerPlayer sender) {
        HashMap<UUID, Map<ResourceLocation, Landmark>> changed = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
        packet.landmarks().forEach((uuid, id) -> {
            boolean waypoint;
            Landmark landmark = this.get((UUID)uuid, (ResourceLocation)id);
            if (landmark == null) {
                return;
            }
            boolean bl = waypoint = !landmark.owner().equals(GLOBAL);
            if (sender == null || WorldLandmarks.canModify(landmark.owner(), world, sender) && (waypoint && Surveyor.CONFIG.networking.waypoints.atLeast(NetworkMode.SOLO) || !waypoint && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO))) {
                this.removeForBatch((Map<UUID, Map<ResourceLocation, Landmark>>)changed, (UUID)uuid, (ResourceLocation)id);
            }
        });
        if (!changed.isEmpty()) {
            this.handleChanged(world, changed, sender == null, sender);
        }
        return changed;
    }

    public SyncLandmarksAddedPacket createUpdatePacket(Multimap<UUID, ResourceLocation> keySet) {
        HashMap<UUID, Map<ResourceLocation, Landmark>> landmarks = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
        keySet.forEach((uuid, id) -> landmarks.computeIfAbsent((UUID)uuid, k -> new HashMap()).put(id, this.get((UUID)uuid, (ResourceLocation)id)));
        return new SyncLandmarksAddedPacket(landmarks);
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.landmarks != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }

    private void tryMigrateXaeros(Level world, boolean handleChanged) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        File saveFolder = SurveyorClient.getXaerosSavePath(world);
        if (saveFolder != null) {
            HashMap<UUID, Map<ResourceLocation, Landmark>> changed = new HashMap<UUID, Map<ResourceLocation, Landmark>>();
            Surveyor.LOGGER.info("[Surveyor] Attempting to parse xaero's waypoints from {}/{}", (Object)saveFolder.getParentFile().getName(), (Object)saveFolder.getName());
            try {
                Files.createFile(saveFolder.toPath().resolve(".surveyor_migrated"), new FileAttribute[0]);
                for (File file : Objects.requireNonNullElse(saveFolder.listFiles(f -> f.getName().endsWith(".txt")), new File[0])) {
                    for (String line : Files.readAllLines(file.toPath())) {
                        try {
                            if (!line.startsWith("waypoint:")) continue;
                            String[] split = line.split(":");
                            BlockPos pos = new BlockPos(Integer.parseInt(split[3]), split[4].equals("~") ? 0 : Integer.parseInt(split[4]), Integer.parseInt(split[5]));
                            ResourceLocation id = ResourceLocation.m_214293_((String)"xaeros", (String)"waypoint/%d/%d/%d".formatted(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                            this.putForBatch(changed, Landmark.create(SurveyorClient.getClientUuid(), id, b -> b.add(LandmarkComponentTypes.POS, pos).add(LandmarkComponentTypes.COLOR, XAERO_COLORS[Integer.parseInt(split[6])]).add(LandmarkComponentTypes.NAME, Component.m_237113_((String)split[1]))));
                            this.dirty = true;
                        }
                        catch (Exception e) {
                            Surveyor.LOGGER.error("[Surveyor] Error parsing xaeros waypoint: {}", (Object)line, (Object)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                Surveyor.LOGGER.error("[Surveyor] Error parsing xaeros data from {}", (Object)saveFolder, (Object)e);
            }
            Surveyor.LOGGER.info("[Surveyor] Migrated {} waypoints from xaeros data.", (Object)changed.values().stream().mapToInt(Map::size).sum());
            if (handleChanged) {
                this.handleChanged(world, changed, Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.SOLO), null);
            }
        }
    }

    public void clientInitialized(Level world) {
        this.tryMigrateXaeros(world, true);
        if (Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
            new C2SKnownLandmarksPacket(this.keySet(null)).send();
        }
    }

    private static /* synthetic */ void lambda$removeAllForBatch$34(Predicate predicate, Multimap toRemove, UUID uuid, Map map) {
        map.forEach((id, landmark) -> {
            if (predicate.test(landmark)) {
                toRemove.put((Object)uuid, id);
            }
        });
    }

    private /* synthetic */ void lambda$keySet$15(SurveyorExploration exploration, Multimap outMap, UUID uuid, Map map) {
        map.forEach((id, landmark) -> {
            if (exploration == null || exploration.exploredLandmark(this.worldKey, (Landmark)landmark)) {
                outMap.put((Object)uuid, id);
            }
        });
    }
}

