/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentHolder;
import folk.sisby.surveyor.landmark.component.LandmarkComponentMap;
import folk.sisby.surveyor.landmark.component.LandmarkComponentType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public record Landmark(UUID owner, ResourceLocation id, LandmarkComponentMap components) implements LandmarkComponentHolder
{
    public static Codec<Landmark> createCodec(UUID uuid, ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)LandmarkComponentMap.CODEC.fieldOf("components").forGetter(Landmark::components)).apply((Applicative)instance, components -> new Landmark(uuid, id, (LandmarkComponentMap)components)));
    }

    public static Landmark create(UUID owner, ResourceLocation id, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        return new Landmark(owner, id, ((LandmarkComponentMap.Builder)componentChanges.apply(LandmarkComponentMap.builder())).build());
    }

    public static Landmark global(ResourceLocation id, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        return Landmark.create(WorldLandmarks.GLOBAL, id, componentChanges);
    }

    public static Landmark createIncremental(WorldLandmarks landmarks, UUID uuid, ResourceLocation prefix, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        int i = 1;
        while (landmarks.contains(uuid, ResourceLocation.m_214293_((String)prefix.m_135827_(), (String)(prefix.m_135815_() + "/" + i)))) {
            ++i;
        }
        return Landmark.create(uuid, ResourceLocation.m_214293_((String)prefix.m_135827_(), (String)(prefix.m_135815_() + "/" + i)), componentChanges);
    }

    public static Landmark globalIncremental(WorldLandmarks landmarks, ResourceLocation prefix, UnaryOperator<LandmarkComponentMap.Builder> componentChanges) {
        return Landmark.createIncremental(landmarks, WorldLandmarks.GLOBAL, prefix, componentChanges);
    }

    public List<Component> toText() {
        ArrayList<Component> outList = new ArrayList<Component>();
        for (LandmarkComponentType type : this.components.keySet().stream().sorted(Comparator.comparing(LandmarkComponentType::id)).toList()) {
            outList.add((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)type.id().toString().replace("surveyor:", "")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)": ").m_7220_(this.getView(type))));
        }
        return outList;
    }

    public Tag toNbt() {
        return (Tag)Landmark.createCodec(this.owner, this.id).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).resultOrPartial(arg_0 -> ((Logger)Surveyor.LOGGER).error(arg_0)).orElseThrow();
    }
}

