/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.S2CGroupAmendedPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRequestedPacket;
import folk.sisby.surveyor.util.MapUtil;
import java.util.BitSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SurveyorClientNetworking {
    public static void init() {
        SurveyorNetworking.C2S_SENDER = p -> {
            if (!ClientPlayNetworking.canSend((ResourceLocation)p.getId())) {
                return;
            }
            p.toBufs().forEach(buf -> ClientPlayNetworking.send((ResourceLocation)p.getId(), (FriendlyByteBuf)buf));
        };
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CUpdateRegionPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CUpdateRegionPacket::read, SurveyorClientNetworking::handleTerrainAdded));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CStructuresAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CStructuresAddedPacket::read, SurveyorClientNetworking::handleStructuresAdded));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CGroupChangedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupChangedPacket::read, SurveyorClientNetworking::handleGroupChanged));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CGroupAmendedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupAmendedPacket::read, SurveyorClientNetworking::handleGroupAmended));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CGroupUpdatedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupUpdatedPacket::read, SurveyorClientNetworking::handleGroupUpdated));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksAddedPacket::read, SurveyorClientNetworking::handleLandmarksAdded));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksRemovedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksRemovedPacket::read, SurveyorClientNetworking::handleLandmarksRemoved));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksRequestedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksRequestedPacket::read, SurveyorClientNetworking::handleLandmarksRequested));
    }

    private static void handleTerrainAdded(ClientLevel world, WorldSummary summary, S2CUpdateRegionPacket packet) {
        if (summary.terrain() == null) {
            return;
        }
        BitSet changed = summary.terrain().getRegion(packet.regionPos()).readUpdatePacket(packet);
        (packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration()).mergeRegion((ResourceKey<Level>)world.m_46472_(), packet.regionPos(), packet.set());
        SurveyorEvents.Invoke.terrainUpdated((Level)world, packet.set().stream().mapToObj(i -> packet.regionPos().toChunk(i)).toList());
        if (changed.cardinality() > 1) {
            Surveyor.LOGGER.info("[Surveyor] Received {} chunks in {} from the server.", (Object)changed.cardinality(), (Object)packet.regionPos());
        }
    }

    private static void handleStructuresAdded(ClientLevel world, WorldSummary summary, S2CStructuresAddedPacket packet) {
        if (summary.structures() == null) {
            return;
        }
        Multimap<ResourceKey<Structure>, ChunkPos> keySet = summary.structures().readUpdatePacket((Level)world, packet);
        if (Minecraft.m_91087_().f_91074_ != null && !keySet.isEmpty()) {
            SurveyorExploration exploration = packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration();
            keySet.forEach((key, pos) -> exploration.addStructure((ResourceKey<Level>)world.m_46472_(), (ResourceKey<Structure>)key, (ChunkPos)pos));
            Surveyor.LOGGER.info("[Surveyor] Received {} structures from the server - {}", (Object)keySet.size(), (Object)keySet.keySet().stream().map(r -> r.m_135782_().toString()).collect(Collectors.joining(", ")));
        }
    }

    private static void handleGroupChanged(ClientLevel world, WorldSummary summary, S2CGroupChangedPacket packet) {
        if (!SurveyorClient.getSharedExploration().groupPlayers().equals(packet.players().keySet())) {
            SurveyorClient.getSharedExploration().groupPlayers().clear();
            SurveyorClient.getSharedExploration().groupPlayers().addAll(packet.players().keySet());
        }
        NetworkHandlerSummary.of(Minecraft.m_91087_().m_91403_()).matchSummaries(packet.players());
        SurveyorClient.getSharedExploration().replaceTerrain((ResourceKey<Level>)world.m_46472_(), packet.regionBits());
        SurveyorClient.getSharedExploration().replaceStructures((ResourceKey<Level>)world.m_46472_(), packet.structureKeys());
        SurveyorClient.getExploration().updateClientForLandmarks((Level)world);
        if (summary != null) {
            if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send();
            }
            if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                new C2SKnownStructuresPacket(summary.structures().keySet(null)).send();
            }
            if (summary.landmarks() != null && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
                new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send();
            }
            Surveyor.LOGGER.info("[Surveyor] Received updated share group of {} from the server - {}", (Object)packet.players().size(), (Object)packet.players().values().stream().map(PlayerSummary::username).collect(Collectors.joining(", ")));
        }
    }

    private static void handleGroupAmended(ClientLevel world, WorldSummary summary, S2CGroupAmendedPacket packet) {
        SurveyorClient.getSharedExploration().groupPlayers().add(packet.player());
        Player player = world.m_46003_(packet.player());
        Surveyor.LOGGER.info("[Surveyor] Received additional share group player {}", player == null ? packet.player() : player.m_36316_().getName());
    }

    private static void handleGroupUpdated(ClientLevel world, WorldSummary summary, S2CGroupUpdatedPacket packet) {
        NetworkHandlerSummary.of(Minecraft.m_91087_().m_91403_()).mergeSummaries(packet.players());
    }

    private static void handleLandmarksAdded(ClientLevel world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((Level)world, packet, null);
        Multimap<UUID, ResourceLocation> keys = MapUtil.keyMultiMap(packet.landmarks());
        Surveyor.LOGGER.info("[Surveyor] Received {} landmarks from the server - {}", (Object)keys.size(), (Object)keys.values().stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
    }

    private static void handleLandmarksRemoved(ClientLevel world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((Level)world, packet, null);
        Surveyor.LOGGER.info("[Surveyor] Received {} landmark removals from the server - {}", (Object)packet.landmarks().size(), (Object)packet.landmarks().values().stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
    }

    private static void handleLandmarksRequested(ClientLevel world, WorldSummary summary, SyncLandmarksRequestedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().createUpdatePacket(packet.landmarks()).send();
        Surveyor.LOGGER.info("[Surveyor] Received {} landmark requests from the server - {}", (Object)packet.landmarks().size(), (Object)packet.landmarks().values().stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
    }

    private static <T extends S2CPacket> void handleClient(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader, ClientPacketHandler<T> handler) {
        WorldSummary summary;
        S2CPacket packet = (S2CPacket)reader.apply(buf);
        WorldSummary worldSummary = summary = Minecraft.m_91087_().f_91073_ == null ? null : WorldSummary.of((Level)Minecraft.m_91087_().f_91073_);
        if (summary != null && !summary.isClient()) {
            return;
        }
        Minecraft.m_91087_().execute(() -> handler.handle(Minecraft.m_91087_().f_91073_, summary, packet));
    }

    public static interface ClientPacketHandler<T> {
        public void handle(ClientLevel var1, WorldSummary var2, T var3);
    }
}

