/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.C2SPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRequestedPacket;
import folk.sisby.surveyor.util.MapUtil;
import folk.sisby.surveyor.util.RegionPos;
import java.util.BitSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SurveyorNetworking {
    public static Consumer<C2SPacket> C2S_SENDER = p -> {};

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)C2SKnownTerrainPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownTerrainPacket::read, SurveyorNetworking::handleKnownTerrain));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)C2SKnownStructuresPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownStructuresPacket::read, SurveyorNetworking::handleKnownStructures));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)C2SKnownLandmarksPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownLandmarksPacket::read, SurveyorNetworking::handleKnownLandmarks));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksAddedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksAddedPacket::read, SurveyorNetworking::handleLandmarksAdded));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksRemovedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksRemovedPacket::read, SurveyorNetworking::handleLandmarksRemoved));
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksRequestedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksRequestedPacket::read, SurveyorNetworking::handleLandmarksRequested));
    }

    private static void handleKnownTerrain(ServerPlayer player, ServerLevel world, WorldSummary summary, C2SKnownTerrainPacket packet) {
        if (summary.terrain() == null || Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.NONE)) {
            return;
        }
        Map<RegionPos, BitSet> serverBits = summary.terrain().bitSet(Surveyor.explorationForMode(Surveyor.CONFIG.networking.terrain, player));
        Map<RegionPos, BitSet> clientBits = packet.regionBits();
        int regions = 0;
        int chunks = 0;
        for (RegionPos rPos : serverBits.keySet()) {
            BitSet set = serverBits.get(rPos);
            if (clientBits.containsKey(rPos)) {
                set.andNot(clientBits.get(rPos));
            }
            if (set.isEmpty()) continue;
            ++regions;
            chunks += set.cardinality();
            summary.terrain().queueUpdate(world, rPos, set, player);
        }
        if (regions > 0) {
            Surveyor.LOGGER.info("[Surveyor] Syncing {} missing chunks over {} regions to player {}.", new Object[]{chunks, regions, player.m_36316_().getName()});
        }
    }

    private static void handleKnownStructures(ServerPlayer player, ServerLevel world, WorldSummary summary, C2SKnownStructuresPacket packet) {
        if (summary.structures() == null || Surveyor.CONFIG.networking.structures.atMost(NetworkMode.NONE)) {
            return;
        }
        Multimap<ResourceKey<Structure>, ChunkPos> structures = summary.structures().keySet(Surveyor.explorationForMode(Surveyor.CONFIG.networking.structures, player));
        packet.structureKeys().forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (structures.isEmpty()) {
            return;
        }
        SurveyorExploration personalExploration = SurveyorExploration.of(player);
        Multimap<ResourceKey<Structure>, ChunkPos> personalStructures = personalExploration.limitStructureKeySet((ResourceKey<Level>)world.m_46472_(), (Multimap<ResourceKey<Structure>, ChunkPos>)HashMultimap.create(structures));
        if (!personalStructures.isEmpty()) {
            S2CStructuresAddedPacket.of(false, personalStructures, summary.structures()).send(player);
        }
        personalStructures.forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (!structures.isEmpty()) {
            S2CStructuresAddedPacket.of(true, structures, summary.structures()).send(player);
        }
        if (!personalStructures.isEmpty() || !structures.isEmpty()) {
            Surveyor.LOGGER.info("[Surveyor] Syncing {} personal and {} shared structures to player {}", new Object[]{personalStructures.size(), structures.size(), player.m_36316_().getName()});
        }
    }

    private static void handleKnownLandmarks(ServerPlayer player, ServerLevel world, WorldSummary summary, C2SKnownLandmarksPacket packet) {
        if (summary.landmarks() == null || Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.NONE)) {
            return;
        }
        UUID uuid = Surveyor.getUuid(player);
        Multimap<UUID, ResourceLocation> landmarks = summary.landmarks().keySet(Surveyor.explorationForMode(Surveyor.CONFIG.networking.landmarks, player));
        HashMultimap addLandmarks = HashMultimap.create(landmarks);
        if (!Surveyor.CONFIG.forceUpdateLandmarks) {
            packet.landmarks().forEach((arg_0, arg_1) -> ((Multimap)addLandmarks).remove(arg_0, arg_1));
        }
        if (!addLandmarks.isEmpty()) {
            SyncLandmarksAddedPacket.of((Multimap<UUID, ResourceLocation>)addLandmarks, summary.landmarks()).send(player);
        }
        HashMultimap removeLandmarks = HashMultimap.create(packet.landmarks());
        Multimap<UUID, ResourceLocation> removedLandmarks = summary.landmarks().removed();
        removeLandmarks.entries().removeIf(e -> !removedLandmarks.containsEntry(e.getKey(), e.getValue()) && (landmarks.containsEntry(e.getKey(), e.getValue()) || ((UUID)e.getKey()).equals(WorldLandmarks.GLOBAL) || ((UUID)e.getKey()).equals(uuid)));
        if (!removeLandmarks.isEmpty()) {
            new SyncLandmarksRemovedPacket((Multimap<UUID, ResourceLocation>)removeLandmarks).send(player);
        }
        HashMultimap unknownWaypoints = HashMultimap.create();
        unknownWaypoints.putAll((Object)uuid, (Iterable)packet.landmarks().get((Object)uuid));
        summary.landmarks().keySet(null).get((Object)uuid).forEach(arg_0 -> SurveyorNetworking.lambda$handleKnownLandmarks$8((Multimap)unknownWaypoints, uuid, arg_0));
        removedLandmarks.get((Object)uuid).forEach(arg_0 -> SurveyorNetworking.lambda$handleKnownLandmarks$9((Multimap)unknownWaypoints, uuid, arg_0));
        if (!unknownWaypoints.isEmpty()) {
            new SyncLandmarksRequestedPacket((Multimap<UUID, ResourceLocation>)unknownWaypoints).send(player);
        }
        if (!(addLandmarks.isEmpty() && removeLandmarks.isEmpty() && unknownWaypoints.isEmpty())) {
            Surveyor.LOGGER.info("[Surveyor] Syncing {} landmarks and {} removals and {} unknowns from player {}", new Object[]{addLandmarks.size(), removeLandmarks.size(), unknownWaypoints.size(), player.m_36316_().getName()});
        }
    }

    private static void handleLandmarksAdded(ServerPlayer player, ServerLevel world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        Multimap<UUID, ResourceLocation> keys = MapUtil.keyMultiMap(summary.landmarks().readUpdatePacket((Level)world, packet, player));
        if (!keys.isEmpty()) {
            Surveyor.LOGGER.info("[Surveyor] Adding landmark(s) from player {} - {}", (Object)player.m_36316_().getName(), (Object)keys.values().stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        }
    }

    private static void handleLandmarksRemoved(ServerPlayer player, ServerLevel world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        Map<UUID, Map<ResourceLocation, Landmark>> changed = summary.landmarks().readUpdatePacket((Level)world, packet, player);
        if (!changed.isEmpty()) {
            summary.landmarks().handleChanged((Level)world, changed, false, player);
            Multimap<UUID, ResourceLocation> keys = MapUtil.keyMultiMap(changed);
            Surveyor.LOGGER.info("[Surveyor] Removing landmark(s) for player {} - {}", (Object)player.m_36316_().getName(), (Object)keys.values().stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        }
    }

    private static void handleLandmarksRequested(ServerPlayer player, ServerLevel world, WorldSummary summary, SyncLandmarksRequestedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        Multimap<UUID, ResourceLocation> allowed = SurveyorExploration.ofShared(player).limitLandmarkKeySet((ResourceKey<Level>)world.m_46472_(), summary.landmarks(), (Multimap<UUID, ResourceLocation>)HashMultimap.create(packet.landmarks()));
        if (!allowed.isEmpty()) {
            summary.landmarks().createUpdatePacket(allowed).send(player);
            Surveyor.LOGGER.info("[Surveyor] Sending requested landmark(s) to player {} - {}", (Object)player.m_36316_().getName(), (Object)allowed.values().stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        }
    }

    private static <T extends C2SPacket> void handleServer(ServerPlayer player, FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader, ServerPacketHandler<T> handler) {
        C2SPacket packet = (C2SPacket)reader.apply(buf);
        handler.handle(player, player.m_284548_(), WorldSummary.of((Level)player.m_284548_()), packet);
    }

    private static /* synthetic */ void lambda$handleKnownLandmarks$9(Multimap unknownWaypoints, UUID uuid, ResourceLocation id) {
        unknownWaypoints.remove((Object)uuid, (Object)id);
    }

    private static /* synthetic */ void lambda$handleKnownLandmarks$8(Multimap unknownWaypoints, UUID uuid, ResourceLocation id) {
        unknownWaypoints.remove((Object)uuid, (Object)id);
    }

    public static interface ServerPacketHandler<T> {
        public void handle(ServerPlayer var1, ServerLevel var2, WorldSummary var3, T var4);
    }
}

