/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.util.RegionPos;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface SurveyorExploration {
    public static final String KEY_EXPLORED_TERRAIN = "exploredTerrain";
    public static final String KEY_EXPLORED_STRUCTURES = "exploredStructures";

    public static SurveyorExploration of(ServerPlayer player) {
        return PlayerSummary.of(player).exploration();
    }

    public static SurveyorExploration of(UUID player, MinecraftServer server) {
        return ServerSummary.of(server).getExploration(player, server);
    }

    public static SurveyorExploration ofShared(ServerPlayer player) {
        return SurveyorExploration.ofShared(Surveyor.getUuid(player), player.m_20194_());
    }

    public static SurveyorExploration ofShared(UUID player, MinecraftServer server) {
        return ServerSummary.of(server).groupExploration(player, server);
    }

    public Map<ResourceKey<Level>, Map<RegionPos, BitSet>> terrain();

    public Map<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>> structures();

    public Set<UUID> sharedPlayers();

    default public void copyFrom(SurveyorExploration oldExploration) {
        this.terrain().putAll(oldExploration.terrain());
        this.structures().putAll(oldExploration.structures());
    }

    public boolean personal();

    default public boolean exploredChunk(ResourceKey<Level> worldKey, ChunkPos pos) {
        RegionPos regionPos = RegionPos.of(pos);
        Map<RegionPos, BitSet> regions = this.terrain().get(worldKey);
        return !this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER) || regions != null && regions.containsKey(regionPos) && regions.get(regionPos).get(RegionPos.chunkToBit(pos));
    }

    default public boolean exploredStructure(ResourceKey<Level> worldKey, ResourceKey<Structure> structure, ChunkPos pos) {
        Map<ResourceKey<Structure>, LongSet> structures = this.structures().get(worldKey);
        return !this.personal() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SERVER) || structures != null && structures.containsKey(structure) && structures.get(structure).contains(pos.m_45588_());
    }

    default public boolean exploredLandmark(ResourceKey<Level> worldKey, Landmark landmark) {
        return landmark.owner().equals(WorldLandmarks.GLOBAL) ? !landmark.components().contains(LandmarkComponentTypes.POS) || this.exploredChunk(worldKey, new ChunkPos(landmark.components().get(LandmarkComponentTypes.POS))) : this.sharedPlayers().contains(landmark.owner());
    }

    default public int chunkCount() {
        return this.terrain().values().stream().flatMap(m -> m.values().stream()).mapToInt(BitSet::cardinality).sum();
    }

    default public int structureCount() {
        return this.structures().values().stream().flatMap(m -> m.values().stream()).mapToInt(Set::size).sum();
    }

    default public BitSet limitTerrainBitset(ResourceKey<Level> worldKey, RegionPos rPos, BitSet bitSet) {
        if (!this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER)) {
            return bitSet;
        }
        if (this.terrain().get(worldKey) == null || !this.terrain().get(worldKey).containsKey(rPos)) {
            bitSet.clear();
        } else {
            bitSet.and(this.terrain().get(worldKey).get(rPos));
        }
        return bitSet;
    }

    default public Map<RegionPos, BitSet> limitTerrainBitset(ResourceKey<Level> worldKey, Map<RegionPos, BitSet> bitSet) {
        if (!this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER)) {
            return bitSet;
        }
        Map<RegionPos, BitSet> regions = this.terrain().get(worldKey);
        if (regions == null) {
            bitSet.clear();
        } else {
            bitSet.forEach((rPos, set) -> this.limitTerrainBitset(worldKey, (RegionPos)rPos, (BitSet)set));
        }
        return bitSet;
    }

    default public Multimap<ResourceKey<Structure>, ChunkPos> limitStructureKeySet(ResourceKey<Level> worldKey, Multimap<ResourceKey<Structure>, ChunkPos> keySet) {
        if (!this.personal() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SERVER)) {
            return keySet;
        }
        Map<ResourceKey<Structure>, LongSet> structures = this.structures().get(worldKey);
        if (structures == null) {
            keySet.clear();
        } else {
            keySet.keySet().removeIf(key -> !structures.containsKey(key));
            keySet.entries().removeIf(e -> !((LongSet)structures.get(e.getKey())).contains(((ChunkPos)e.getValue()).m_45588_()));
        }
        return keySet;
    }

    default public Map<UUID, Map<ResourceLocation, Landmark>> limitLandmarkMap(ResourceKey<Level> worldKey, Map<UUID, Map<ResourceLocation, Landmark>> asMap) {
        HashMultimap toRemove = HashMultimap.create();
        asMap.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkMap$6(worldKey, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((uuid, id) -> {
            ((Map)asMap.get(uuid)).remove(id);
            if (((Map)asMap.get(uuid)).isEmpty()) {
                asMap.remove(uuid);
            }
        });
        return asMap;
    }

    default public Multimap<UUID, ResourceLocation> limitLandmarkKeySet(ResourceKey<Level> worldKey, WorldLandmarks worldLandmarks, Multimap<UUID, ResourceLocation> keySet) {
        HashMultimap toRemove = HashMultimap.create();
        keySet.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkKeySet$8(worldLandmarks, worldKey, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((arg_0, arg_1) -> keySet.remove(arg_0, arg_1));
        return keySet;
    }

    default public void updateClientForMergeRegion(Level world, RegionPos regionPos, BitSet bitSet) {
        Set<ChunkPos> terrainKeys = bitSet.stream().mapToObj(regionPos::toChunk).collect(Collectors.toSet());
        SurveyorClientEvents.Invoke.terrainUpdated(world, terrainKeys);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        summary.asMap(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForMergeRegion$10(terrainKeys, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, (Multimap<UUID, ResourceLocation>)landmarkKeys);
    }

    default public void updateClientForLandmarks(Level world) {
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        Multimap<UUID, ResourceLocation> unexploredLandmarks = summary.keySet(null);
        Multimap<UUID, ResourceLocation> exploredLandmarks = summary.keySet(this);
        exploredLandmarks.forEach((arg_0, arg_1) -> unexploredLandmarks.remove(arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, exploredLandmarks);
        SurveyorClientEvents.Invoke.landmarksRemoved(world, unexploredLandmarks);
    }

    default public void mergeRegion(ResourceKey<Level> worldKey, RegionPos regionPos, BitSet bitSet) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(regionPos, p -> new BitSet(32)).or(bitSet);
    }

    default public void replaceTerrain(ResourceKey<Level> worldKey, Map<RegionPos, BitSet> bitSet) {
        Map<RegionPos, BitSet> oldSet = this.terrain().get(worldKey);
        if (oldSet != null) {
            oldSet.clear();
        }
        bitSet.forEach((pos, set) -> this.mergeRegion(worldKey, (RegionPos)pos, (BitSet)set));
    }

    default public void updateClientForAddChunk(Level world, ChunkPos chunkPos) {
        SurveyorClientEvents.Invoke.terrainUpdated(world, chunkPos);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        summary.asMap(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForAddChunk$15(chunkPos, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, (Multimap<UUID, ResourceLocation>)landmarkKeys);
    }

    default public void addChunk(ResourceKey<Level> worldKey, ChunkPos pos) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(RegionPos.of(pos), k -> new BitSet(1024)).set(RegionPos.chunkToBit(pos));
    }

    default public void updateClientForAddStructure(Level world, ResourceKey<Structure> structureKey, ChunkPos pos) {
        SurveyorClientEvents.Invoke.structuresAdded(world, structureKey, pos);
    }

    default public void addStructure(ResourceKey<Level> worldKey, ResourceKey<Structure> structureKey, ChunkPos pos) {
        this.structures().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(structureKey, s -> new LongOpenHashSet()).add(pos.m_45588_());
    }

    default public void mergeStructures(ResourceKey<Level> worldKey, ResourceKey<Structure> structureKey, LongSet starts) {
        this.structures().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(structureKey, s -> new LongOpenHashSet()).addAll((LongCollection)starts);
    }

    default public void replaceStructures(ResourceKey<Level> worldKey, Map<ResourceKey<Structure>, LongSet> structures) {
        LongSet oldSet = structures.get(worldKey);
        if (oldSet != null) {
            oldSet.clear();
        }
        structures.forEach((key, set) -> this.mergeStructures(worldKey, (ResourceKey<Structure>)key, (LongSet)set));
    }

    default public CompoundTag write(CompoundTag nbt) {
        CompoundTag terrainCompound = new CompoundTag();
        this.terrain().forEach((worldKey, map) -> {
            LongArrayList regionLongs = new LongArrayList();
            for (Map.Entry entry : map.entrySet()) {
                regionLongs.add(((RegionPos)entry.getKey()).toLong());
                if (((BitSet)entry.getValue()).cardinality() == 1024) {
                    regionLongs.add(-1L);
                    continue;
                }
                long[] regionBits = ((BitSet)entry.getValue()).toLongArray();
                regionLongs.add((long)regionBits.length);
                regionLongs.addAll(LongList.of((long[])regionBits));
            }
            terrainCompound.m_128388_(worldKey.m_135782_().toString(), regionLongs.toLongArray());
        });
        nbt.m_128365_(KEY_EXPLORED_TERRAIN, (Tag)terrainCompound);
        CompoundTag structuresCompound = new CompoundTag();
        this.structures().forEach((worldKey, map) -> {
            CompoundTag worldStructuresCompound = new CompoundTag();
            for (ResourceKey structure : map.keySet()) {
                worldStructuresCompound.m_128388_(structure.m_135782_().toString(), ((LongSet)map.get(structure)).toLongArray());
            }
            structuresCompound.m_128365_(worldKey.m_135782_().toString(), (Tag)worldStructuresCompound);
        });
        nbt.m_128365_(KEY_EXPLORED_STRUCTURES, (Tag)structuresCompound);
        return nbt;
    }

    default public void read(CompoundTag nbt) {
        CompoundTag terrainCompound = nbt.m_128469_(KEY_EXPLORED_TERRAIN);
        for (String worldKeyString : terrainCompound.m_128431_()) {
            long[] regionArray = terrainCompound.m_128467_(worldKeyString);
            HashMap<RegionPos, BitSet> regionMap = new HashMap<RegionPos, BitSet>();
            int i = 0;
            while (i + 1 < regionArray.length) {
                RegionPos rPos = RegionPos.of(regionArray[i]);
                int bitLength = (int)regionArray[i + 1];
                if (bitLength == -1) {
                    BitSet set = new BitSet(1024);
                    set.set(0, 1024);
                    regionMap.put(rPos, set);
                } else {
                    long[] bitArray = new long[bitLength];
                    System.arraycopy(regionArray, i + 2, bitArray, 0, bitLength);
                    regionMap.put(rPos, BitSet.valueOf(bitArray));
                    i += bitLength;
                }
                i += 2;
            }
            this.terrain().put((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(worldKeyString)), regionMap);
        }
        CompoundTag structuresCompound = nbt.m_128469_(KEY_EXPLORED_STRUCTURES);
        for (String worldKeyString : structuresCompound.m_128431_()) {
            HashMap<ResourceKey, LongOpenHashSet> structureMap = new HashMap<ResourceKey, LongOpenHashSet>();
            CompoundTag worldStructuresCompound = structuresCompound.m_128469_(worldKeyString);
            for (String key : worldStructuresCompound.m_128431_()) {
                structureMap.put(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(key)), new LongOpenHashSet(worldStructuresCompound.m_128467_(key)));
            }
            this.structures().put((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(worldKeyString)), structureMap);
        }
    }

    private static /* synthetic */ void lambda$updateClientForAddChunk$15(ChunkPos chunkPos, Multimap landmarkKeys, UUID uuid, Map map) {
        map.forEach((id, landmark) -> {
            if (landmark.components().contains(LandmarkComponentTypes.POS) && chunkPos.equals((Object)new ChunkPos(landmark.components().get(LandmarkComponentTypes.POS))) && landmark.owner().equals(WorldLandmarks.GLOBAL)) {
                landmarkKeys.put((Object)uuid, id);
            }
        });
    }

    private static /* synthetic */ void lambda$updateClientForMergeRegion$10(Set terrainKeys, Multimap landmarkKeys, UUID uuid, Map map) {
        map.forEach((id, landmark) -> {
            if (landmark.components().contains(LandmarkComponentTypes.POS) && terrainKeys.contains(new ChunkPos(landmark.components().get(LandmarkComponentTypes.POS))) && landmark.owner().equals(WorldLandmarks.GLOBAL)) {
                landmarkKeys.put((Object)uuid, id);
            }
        });
    }

    private /* synthetic */ void lambda$limitLandmarkKeySet$8(WorldLandmarks worldLandmarks, ResourceKey worldKey, Multimap toRemove, UUID uuid, ResourceLocation id) {
        if (!worldLandmarks.contains(uuid, id) || !this.exploredLandmark((ResourceKey<Level>)worldKey, worldLandmarks.get(uuid, id))) {
            toRemove.put((Object)uuid, (Object)id);
        }
    }

    private /* synthetic */ void lambda$limitLandmarkMap$6(ResourceKey worldKey, Multimap toRemove, UUID uuid, Map map) {
        map.forEach((id, landmark) -> {
            if (!this.exploredLandmark((ResourceKey<Level>)worldKey, (Landmark)landmark)) {
                toRemove.put((Object)uuid, id);
            }
        });
    }
}

