/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.MapUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SurveyorEvents {
    private static final Map<ResourceLocation, WorldLoad> worldLoad = new HashMap<ResourceLocation, WorldLoad>();
    private static final Map<ResourceLocation, TerrainUpdated> terrainUpdated = new HashMap<ResourceLocation, TerrainUpdated>();
    private static final Map<ResourceLocation, StructuresAdded> structuresAdded = new HashMap<ResourceLocation, StructuresAdded>();
    private static final Map<ResourceLocation, LandmarksAdded> landmarksAdded = new HashMap<ResourceLocation, LandmarksAdded>();
    private static final Map<ResourceLocation, LandmarksRemoved> landmarksRemoved = new HashMap<ResourceLocation, LandmarksRemoved>();

    public static class Register {
        public static void worldLoad(ResourceLocation id, WorldLoad handler) {
            worldLoad.put(id, handler);
        }

        public static void terrainUpdated(ResourceLocation id, TerrainUpdated handler) {
            terrainUpdated.put(id, handler);
        }

        public static void structuresAdded(ResourceLocation id, StructuresAdded handler) {
            structuresAdded.put(id, handler);
        }

        public static void landmarksAdded(ResourceLocation id, LandmarksAdded handler) {
            landmarksAdded.put(id, handler);
        }

        public static void landmarksRemoved(ResourceLocation id, LandmarksRemoved handler) {
            landmarksRemoved.put(id, handler);
        }
    }

    public static class Invoke {
        public static void worldLoad(ServerLevel world) {
            if (worldLoad.isEmpty()) {
                return;
            }
            WorldSummary summary = WorldSummary.of((Level)world);
            worldLoad.forEach((id, handler) -> handler.onWorldLoad(world, summary));
        }

        public static void terrainUpdated(Level world, Collection<ChunkPos> chunks) {
            if (terrainUpdated.isEmpty() || chunks.isEmpty()) {
                return;
            }
            WorldTerrainSummary summary = WorldSummary.of(world).terrain();
            terrainUpdated.forEach((id, handler) -> handler.onTerrainUpdated(world, summary, chunks));
        }

        public static void terrainUpdated(Level world, ChunkPos pos) {
            Invoke.terrainUpdated(world, List.of(pos));
        }

        public static void structuresAdded(Level world, Multimap<ResourceKey<Structure>, ChunkPos> structures) {
            if (structuresAdded.isEmpty() || structures.isEmpty()) {
                return;
            }
            WorldStructureSummary summary = WorldSummary.of(world).structures();
            structuresAdded.forEach((id, handler) -> handler.onStructuresAdded(world, summary, structures));
        }

        public static void structuresAdded(Level world, ResourceKey<Structure> key, ChunkPos pos) {
            Invoke.structuresAdded(world, MapUtil.asMultiMap(Map.of(key, List.of(pos))));
        }

        public static void landmarksAdded(Level world, Multimap<UUID, ResourceLocation> landmarks) {
            if (landmarksAdded.isEmpty() || landmarks.isEmpty()) {
                return;
            }
            WorldLandmarks summary = WorldSummary.of(world).landmarks();
            landmarksAdded.forEach((id, handler) -> handler.onLandmarksAdded(world, summary, landmarks));
        }

        public static void landmarksRemoved(Level world, Multimap<UUID, ResourceLocation> landmarks) {
            if (landmarksRemoved.isEmpty() || landmarks.isEmpty()) {
                return;
            }
            WorldLandmarks summary = WorldSummary.of(world).landmarks();
            landmarksRemoved.forEach((id, handler) -> handler.onLandmarksRemoved(world, summary, landmarks));
        }
    }

    @FunctionalInterface
    public static interface LandmarksRemoved {
        public void onLandmarksRemoved(Level var1, WorldLandmarks var2, Multimap<UUID, ResourceLocation> var3);
    }

    @FunctionalInterface
    public static interface LandmarksAdded {
        public void onLandmarksAdded(Level var1, WorldLandmarks var2, Multimap<UUID, ResourceLocation> var3);
    }

    @FunctionalInterface
    public static interface StructuresAdded {
        public void onStructuresAdded(Level var1, WorldStructureSummary var2, Multimap<ResourceKey<Structure>, ChunkPos> var3);
    }

    @FunctionalInterface
    public static interface TerrainUpdated {
        public void onTerrainUpdated(Level var1, WorldTerrainSummary var2, Collection<ChunkPos> var3);
    }

    @FunctionalInterface
    public static interface WorldLoad {
        public void onWorldLoad(ServerLevel var1, WorldSummary var2);
    }
}

