/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.SurveyorCommands;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.config.SurveyorConfig;
import folk.sisby.surveyor.landmark.component.LandmarkComponentTypes;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.MapUtil;
import folk.sisby.surveyor.util.RaycastUtil;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Surveyor
implements ModInitializer {
    public static final String ID = "surveyor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"surveyor");
    public static final String DATA_SUBFOLDER = "data";
    public static final SurveyorConfig CONFIG = (SurveyorConfig)SurveyorConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"", (String)"surveyor", SurveyorConfig.class);

    public static ResourceLocation id(String path) {
        return new ResourceLocation(ID, path);
    }

    public static File getSavePath(ResourceKey<Level> worldKey, MinecraftServer server) {
        return DimensionType.m_196975_(worldKey, (Path)server.m_129843_(LevelResource.f_78182_)).resolve(DATA_SUBFOLDER).resolve(ID).toFile();
    }

    public static void checkStructureExploration(ServerLevel world, ServerPlayer player, BlockPos pos) {
        if (!world.m_7232_(pos.m_123341_() >> 4, pos.m_123343_() >> 4)) {
            return;
        }
        WorldStructureSummary worldStructures = WorldSummary.of((Level)world).structures();
        if (worldStructures == null) {
            return;
        }
        Registry structureRegistry = world.m_9598_().m_175515_(Registries.f_256944_);
        SurveyorExploration exploration = SurveyorExploration.of(player);
        Map structureReferences = world.m_46819_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62316_).m_62769_();
        if (!structureReferences.isEmpty()) {
            Multimap unexploredStructures = MapUtil.asMultiMap(structureReferences.entrySet().stream().collect(Collectors.toMap(e -> (ResourceKey)structureRegistry.m_7854_((Object)((Structure)e.getKey())).orElseThrow(), e -> ((LongSet)e.getValue()).longStream().mapToObj(ChunkPos::new).toList())));
            unexploredStructures.entries().removeIf(e -> exploration.exploredStructure((ResourceKey<Level>)world.m_46472_(), (ResourceKey<Structure>)((ResourceKey)e.getKey()), (ChunkPos)e.getValue()));
            unexploredStructures.entries().removeIf(e -> !worldStructures.contains((ResourceKey<Structure>)((ResourceKey)e.getKey()), (ChunkPos)e.getValue()));
            unexploredStructures.forEach((structureKey, startPos) -> {
                Structure structure = (Structure)structureRegistry.m_6246_(structureKey);
                StructureStart start = world.m_46819_(startPos.f_45578_, startPos.f_45579_, ChunkStatus.f_62315_).m_213652_(structure);
                boolean found = false;
                if (start != null && start.m_73603_() && start.m_73601_().m_71051_((Vec3i)pos)) {
                    for (StructurePiece piece : start.m_73602_()) {
                        if (!piece.m_73547_().m_191961_(2).m_71051_((Vec3i)pos)) continue;
                        exploration.addStructure((ResourceKey<Level>)world.m_46472_(), (ResourceKey<Structure>)structureKey, start.m_163625_());
                        found = true;
                        break;
                    }
                }
                if (found && Surveyor.CONFIG.discoveryMessages) {
                    player.m_240418_((Component)Component.m_237113_((String)"Discovered ").m_7220_((Component)Component.m_237113_((String)WordUtils.capitalize((String)structureKey.m_135782_().m_135815_().replace("_", " "))).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" at ")).m_7220_((Component)Component.m_237113_((String)"[%s,%s]".formatted(startPos.f_45578_ << 4, startPos.f_45579_ << 4)).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GRAY), true);
                }
            });
        }
    }

    public static UUID getUuid(ServerPlayer player) {
        return player.m_20194_() != null && player.m_20194_().m_7779_(player.m_36316_()) ? ServerSummary.HOST : player.m_20148_();
    }

    public static ServerPlayer getPlayer(MinecraftServer server, UUID uuid) {
        return server.m_6846_().m_11259_(uuid == ServerSummary.HOST && server.m_236731_() != null ? server.m_236731_().getId() : uuid);
    }

    static SurveyorExploration explorationForMode(NetworkMode mode, ServerPlayer player) {
        return mode.atLeast(NetworkMode.SERVER) ? null : (mode.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : (mode.atLeast(NetworkMode.SOLO) ? SurveyorExploration.of(player) : PlayerSummary.OfflinePlayerSummary.OfflinePlayerExploration.empty(player.m_20148_())));
    }

    public void onInitialize() {
        SurveyorNetworking.init();
        LandmarkComponentTypes.touch();
        CommandRegistrationCallback.EVENT.register(SurveyorCommands::registerCommands);
        ServerPlayConnectionEvents.JOIN.register(ServerSummary::onPlayerJoin);
        ServerChunkEvents.CHUNK_LOAD.register(WorldTerrainSummary::onChunkLoad);
        ServerChunkEvents.CHUNK_LOAD.register(WorldStructureSummary::onChunkLoad);
        ServerChunkEvents.CHUNK_UNLOAD.register(WorldTerrainSummary::onChunkUnload);
        ServerTickEvents.END_SERVER_TICK.register(ServerSummary::onTick);
        ServerTickEvents.END_WORLD_TICK.register(WorldTerrainSummary::onTick);
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if ((world.m_46467_() & 7L) != 0L) {
                return;
            }
            for (ServerPlayer player : world.m_6907_()) {
                Surveyor.checkStructureExploration(world, player, player.m_20183_());
                Surveyor.checkStructureExploration(world, player, BlockPos.m_274446_((Position)RaycastUtil.playerViewRaycast(player, PlayerSummary.of(player).viewDistance()).m_82450_()));
            }
        });
        LOGGER.info("[Surveyor] is not a map mod");
    }
}

