/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.world;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.level.CraftTweakerSavedData;
import com.blamejared.crafttweaker.api.level.CraftTweakerSavedDataHolder;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityTypeTest;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/world/ServerLevel")
@NativeTypeRegistration(value=ServerLevel.class, zenCodeName="crafttweaker.api.world.ServerLevel")
public class ExpandServerLevel {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="customData")
    public static CraftTweakerSavedData getCustomData(ServerLevel internal) {
        return ((CraftTweakerSavedDataHolder)internal).crafttweaker$getSavedData();
    }

    @ZenCodeType.Setter(value="dayTime")
    public static void setDayTime(ServerLevel internal, long time) {
        internal.m_8615_(time);
    }

    @ZenCodeType.Method
    public static void setTimeToDay(ServerLevel internal) {
        internal.m_8615_(1000L);
    }

    @ZenCodeType.Method
    public static void setTimeToNoon(ServerLevel internal) {
        internal.m_8615_(6000L);
    }

    @ZenCodeType.Method
    public static void setTimeToNight(ServerLevel internal) {
        internal.m_8615_(13000L);
    }

    @ZenCodeType.Method
    public static void setTimeToMidnight(ServerLevel internal) {
        internal.m_8615_(18000L);
    }

    @ZenCodeType.Getter(value="seed")
    public static long getSeed(ServerLevel internal) {
        return internal.m_7328_();
    }

    @ZenCodeType.Method
    public static boolean isVillage(ServerLevel internal, BlockPos pos) {
        return internal.m_8802_(pos);
    }

    @ZenCodeType.Method
    public static boolean isRaided(ServerLevel internal, BlockPos pos) {
        return internal.m_8843_(pos);
    }

    @ZenCodeType.Method
    public static boolean isSlimeChunk(ServerLevel internal, BlockPos pos) {
        return WorldgenRandom.m_224681_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4), (long)internal.m_7328_(), (long)987234911L).m_188503_(10) == 0;
    }

    @ZenCodeType.Getter(value="server")
    public static MinecraftServer getServer(ServerLevel internal) {
        return internal.m_7654_();
    }

    @ZenCodeType.Method
    public static List<Entity> getEntities(ServerLevel internal, Predicate<Entity> predicate, @ZenCodeType.Optional EntityType<Entity> type) {
        return (List)GenericUtil.uncheck(internal.m_143280_(type == null ? ExpandEntityTypeTest.ANY : type, predicate));
    }

    @ZenCodeType.Getter(value="damageSources")
    public static DamageSources damageSources(ServerLevel level) {
        return level.m_269111_();
    }
}

