/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.villager;

import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import com.blamejared.crafttweaker.api.villager.ITradeRemover;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.npc.VillagerTrades;

public class ActionRemoveWanderingTrade
extends ActionTradeBase {
    private final ITradeRemover tradeRemover;
    private final List<VillagerTrades.ItemListing> removed;

    public ActionRemoveWanderingTrade(int level, ITradeRemover tradeRemover) {
        super(level);
        this.tradeRemover = tradeRemover;
        this.removed = new ArrayList<VillagerTrades.ItemListing>();
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ItemListing[]> getTrades() {
        return VillagerTrades.f_35628_;
    }

    @Override
    public void apply() {
        List<VillagerTrades.ItemListing> tradeList = this.getTradeList();
        this.apply(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void apply(List<VillagerTrades.ItemListing> tradeList) {
        tradeList.forEach(iTrade -> {
            if (this.tradeRemover.shouldRemove((VillagerTrades.ItemListing)iTrade)) {
                this.removed.add((VillagerTrades.ItemListing)iTrade);
            }
        });
        tradeList.removeAll(this.removed);
    }

    @Override
    public String describe() {
        return String.format("Removing Wandering Trader trade for Level: '%s'", this.level);
    }

    @Override
    public void undo() {
        List<VillagerTrades.ItemListing> tradeList = this.getTradeList();
        this.undo(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void undo(List<VillagerTrades.ItemListing> tradeList) {
        tradeList.addAll(this.removed);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing removal of Wandering Trader trade for Level: '%s'", this.level);
    }
}

