/*
 * Decompiled with CFR 0.152.
 */
package net.funkpla.chunkyautopause;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Objects;
import net.funkpla.chunkyautopause.AutoPauseEnableCommand;
import net.funkpla.chunkyautopause.Config;
import net.funkpla.chunkyautopause.Provider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.ChunkyProvider;
import org.popcraft.chunky.api.ChunkyAPI;
import org.popcraft.chunky.api.ChunkyAPIImpl;
import org.popcraft.chunky.platform.World;
import org.slf4j.Logger;

@Mod(value="chunkyautopause")
public class ChunkyAutoPause {
    public static final String MODID = "chunkyautopause";
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean enabled;
    private static Chunky chunky;
    private static ChunkyAPI chunkyApi;
    private final HashSet<World> suspendedTasks = new HashSet();
    private ResumeTimer resumeTimer;

    public ChunkyAutoPause() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        Provider.register(this);
    }

    private void commonSetup(FMLCommonSetupEvent ignoredEvent) {
        this.setEnabled(Config.enableOnStartup);
        this.resumeTimer = new ResumeTimer(Config.resumeWaitTicks);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        chunky = ChunkyProvider.get();
        chunkyApi = new ChunkyAPIImpl(chunky);
        chunky.getServer().getWorlds().forEach(world -> {
            if (chunkyApi.isRunning(world.toString())) {
                LOGGER.info("Task running for: {}", world);
            } else {
                LOGGER.info("Task not running for: {}", world);
            }
        });
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        int count = Objects.requireNonNull(event.getEntity().m_20194_()).m_7416_();
        LOGGER.debug("Player logged in. Server population is :{}", (Object)count);
        this.suspend();
    }

    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        LOGGER.debug("Registering commands, maybe?");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        AutoPauseEnableCommand.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        int count = Objects.requireNonNull(event.getEntity().m_20194_()).m_7416_();
        LOGGER.debug("Player logged out. Server population is :{}", (Object)count);
        if (count <= 1) {
            this.resumeTimer.start();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        this.resumeTimer.tick();
    }

    private HashSet<World> getTasks() {
        HashSet<World> tasks = new HashSet<World>();
        chunky.getServer().getWorlds().forEach(world -> {
            if (chunkyApi.isRunning(world.getName())) {
                tasks.add((World)world);
            }
        });
        return tasks;
    }

    private void suspend() {
        LOGGER.info("Suspending chunky tasks");
        this.resumeTimer.cancel();
        this.getTasks().forEach(task -> {
            String name = task.getName();
            if (chunkyApi.pauseTask(name)) {
                this.suspendedTasks.add((World)task);
                LOGGER.debug("Suspended task {}", (Object)name);
            }
        });
    }

    private void resume() {
        LOGGER.info("Resuming Chunky Tasks");
        new HashSet<World>(this.suspendedTasks).forEach(task -> {
            String name = task.getName();
            if (chunkyApi.continueTask(name)) {
                this.suspendedTasks.remove(task);
                LOGGER.debug("Resumed task {}", (Object)name);
            }
        });
        assert (this.suspendedTasks.isEmpty());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        LOGGER.debug("Enabled:{}", (Object)this.enabled);
    }

    private class ResumeTimer {
        private int tickCount = 0;
        private final int deadline;
        private boolean started = false;

        public ResumeTimer(int deadline) {
            this.deadline = deadline;
        }

        public void start() {
            this.tickCount = 0;
            this.started = true;
        }

        public void cancel() {
            this.started = false;
            this.tickCount = 0;
        }

        public void tick() {
            if (!this.started) {
                return;
            }
            ++this.tickCount;
            if (this.tickCount >= this.deadline) {
                LOGGER.debug("Resume timer expired");
                ChunkyAutoPause.this.resume();
                this.cancel();
            }
        }
    }
}

