/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.network;

import net.minecraft.network.FriendlyByteBuf;

@FunctionalInterface
public interface PacketCodec<T> {
    public void encode(T var1, FriendlyByteBuf var2);

    default public T decode(FriendlyByteBuf buf) {
        throw new UnsupportedOperationException("[KnightLib] Decode not implemented");
    }

    public static <T> PacketCodec<T> of(final Encoder<T> encoder, final Decoder<T> decoder) {
        return new PacketCodec<T>(){

            @Override
            public void encode(T msg, FriendlyByteBuf buf) {
                encoder.encode(msg, buf);
            }

            @Override
            public T decode(FriendlyByteBuf buf) {
                return decoder.decode(buf);
            }
        };
    }

    @FunctionalInterface
    public static interface Encoder<T> {
        public void encode(T var1, FriendlyByteBuf var2);
    }

    @FunctionalInterface
    public static interface Decoder<T> {
        public T decode(FriendlyByteBuf var1);
    }
}

