/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpackscreateintegration.backpack;

import com.mojang.serialization.Codec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common.MountedBackpackContainerMenu;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common.MountedBackpackContext;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageUpdateMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class MountedSophisticatedBackpack
extends MountedStorageBase {
    public static final Codec<MountedSophisticatedBackpack> CODEC = ItemStack.f_41582_.xmap(MountedSophisticatedBackpack::new, MountedStorageBase::getStorageStack);
    private IBackpackWrapper backpackWrapper = IBackpackWrapper.Noop.INSTANCE;
    @Nullable
    private WeakReference<Entity> contraptionEntity = null;
    private BlockPos localPos = BlockPos.f_121853_;
    private Vec3 position = Vec3.f_82478_;
    @Nullable
    private WeakReference<Level> level = null;
    protected boolean updateRenderAttributes = false;
    private boolean stackDirty = false;
    private boolean clearedNbt = false;

    public MountedSophisticatedBackpack(ItemStack storageStack) {
        super((MountedItemStorageType)ModContent.SOPHISTICATED_MOUNTED_BACKPACK_TYPE.get(), storageStack);
    }

    private void onStackChanged() {
        this.setStackDirty();
    }

    public void setStorageStack(ItemStack stack) {
        super.setStorageStack(stack);
        this.backpackWrapper = IBackpackWrapper.Noop.INSTANCE;
        this.updateRenderAttributes = true;
    }

    private void setStackDirty() {
        this.stackDirty = true;
    }

    private void setStackClean() {
        this.stackDirty = false;
    }

    public static MountedSophisticatedBackpack from(BackpackBlockEntity backpackBe) {
        return new MountedSophisticatedBackpack(backpackBe.getBackpackWrapper().getBackpack());
    }

    @Nullable
    private Entity getEntity() {
        return this.contraptionEntity == null ? null : (Entity)this.contraptionEntity.get();
    }

    public void setContraptionEntity(Entity entity) {
        this.contraptionEntity = new WeakReference<Entity>(entity);
    }

    private void refreshRenderBlockEntity() {
        AbstractContraptionEntity abstractContraptionEntity;
        BlockEntity blockEntity;
        Entity e = this.getEntity();
        if (e instanceof AbstractContraptionEntity && (blockEntity = (abstractContraptionEntity = (AbstractContraptionEntity)e).getContraption().getBlockEntityClientSide(this.localPos)) instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBe = (BackpackBlockEntity)blockEntity;
            backpackBe.setBackpack(this.getStorageStack());
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)abstractContraptionEntity.getContraption().getBlocks().get(this.localPos);
            if (blockInfo != null && blockInfo.f_74676_().m_60734_() instanceof BackpackBlock) {
                backpackBe.m_155250_(blockInfo.f_74676_());
            }
            abstractContraptionEntity.getContraption().invalidateClientContraptionStructure();
        }
    }

    public void updateWithSyncedStorageStack(ItemStack storageStack, boolean refreshBlockRender) {
        this.setStorageStack(storageStack);
        this.updateRenderAttributes = true;
    }

    public IStorageWrapper getStorageWrapper() {
        if (this.backpackWrapper == IBackpackWrapper.Noop.INSTANCE) {
            this.backpackWrapper = new BackpackWrapper(this.getStorageStack());
            this.backpackWrapper.setContentsChangeHandler(this::onStackChanged);
        }
        return this.backpackWrapper;
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        NBTHelper.getUniqueId((ItemStack)this.getStorageStack(), (String)"contentsUuid").ifPresent(uuid -> {
            if (be instanceof BackpackBlockEntity) {
                BackpackBlockEntity backpackBe = (BackpackBlockEntity)be;
                backpackBe.setBackpack(this.getStorageStack());
            }
        });
    }

    private static MountedStorageContainerMenuBase createMenu(int id, Player pl, MountedBackpackContext context) {
        return new MountedBackpackContainerMenu(id, pl, context);
    }

    public static void openMenu(ServerPlayer player, MountedBackpackContext context) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> MountedSophisticatedBackpack.createMenu(w, pl, context), context.getDisplayName(player)), context::toBuffer);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        ServerLevel level = player.m_284548_();
        int contraptionEntityId = contraption.entity.m_19879_();
        BlockPos localPos = info.f_74675_();
        Vec3 localPosVec = Vec3.m_82512_((Vec3i)localPos);
        MountedSophisticatedBackpack.openMenu(player, new MountedBackpackContext(contraptionEntityId, localPos));
        Vec3 globalPos = contraption.entity.toGlobalVector(localPosVec, 0.0f);
        this.onOpen(level, globalPos);
        return true;
    }

    protected Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    void initEntityLevelAndPositions(MovementContext context) {
        if (this.getEntity() == null) {
            AbstractContraptionEntity entity = context.contraption.entity;
            BlockPos localPos = context.localPos;
            Vec3 position = context.position;
            Level level = context.world;
            this.initEntityLevelAndPositions(entity, localPos, level, position);
        }
    }

    public void initEntityLevelAndPositions(AbstractContraptionEntity abstractContraptionEntity, BlockPos localPos, Level level, Vec3 position) {
        this.setContraptionEntity((Entity)abstractContraptionEntity);
        this.setLocalPos(localPos);
        this.setLevel(level);
        this.setPosition(position);
    }

    public void setLocalPos(BlockPos localPos) {
        this.localPos = localPos;
    }

    public void setLevel(Level level) {
        this.level = new WeakReference<Level>(level);
    }

    @Nullable
    protected Level getLevel() {
        return this.level == null ? null : (Level)this.level.get();
    }

    public void tick() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            this.sendStorageUpdatePayload();
        }
        if (level == null) {
            return;
        }
        if (level.m_5776_()) {
            this.clientTick(level);
            return;
        }
        this.runTickableUpgrades(level);
        this.runPickupOnItemEntities(level);
    }

    private void runTickableUpgrades(Level level) {
        this.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(this.getEntity(), level, new BlockPos((int)this.getPosition().m_7096_(), (int)this.getPosition().m_7098_(), (int)this.getPosition().m_7094_())));
    }

    private void runPickupOnItemEntities(Level level) {
        AABB aabb = this.getPickupBoundingBox();
        List collidedWithItemEntities = level.m_45976_(ItemEntity.class, aabb);
        collidedWithItemEntities.forEach(itemEntity -> {
            if (itemEntity.m_6084_()) {
                this.tryToPickup(level, (ItemEntity)itemEntity);
            }
        });
    }

    private void tryToPickup(Level level, ItemEntity itemEntity) {
        ItemStack remainingStack = itemEntity.m_32055_().m_41777_();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)this.getStorageWrapper().getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.m_41613_() < itemEntity.m_32055_().m_41613_()) {
            itemEntity.m_32045_(remainingStack);
        }
    }

    private AABB getPickupBoundingBox() {
        return new AABB(this.getPosition(), this.getPosition().m_82520_(1.0, 1.0, 1.0)).m_82400_(0.2);
    }

    private void clientTick(Level level) {
        if (this.updateRenderAttributes) {
            this.refreshRenderBlockEntity();
            this.updateRenderAttributes = false;
        }
        if (level.f_46441_.m_188503_(10) == 0) {
            RenderInfo renderInfo = this.getStorageWrapper().getRenderInfo();
            this.renderUpgrades(level, level.f_46441_, renderInfo);
        }
    }

    private void renderUpgrades(Level level, RandomSource rand, RenderInfo renderInfo) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> this.renderUpgrade((IUpgradeRenderer)renderer, level, rand, (UpgradeRenderDataType<?>)type, (IUpgradeRenderData)data)));
    }

    private <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, Level level, RandomSource rand, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(level, rand, vector -> vector.add((float)this.getPosition().m_7096_(), (float)this.getPosition().m_7098_() + 0.8f, (float)this.getPosition().m_7094_()), renderData));
    }

    private boolean isStackDirty() {
        return this.stackDirty;
    }

    public void sendStorageUpdatePayload() {
        if (!this.isStackDirty()) {
            return;
        }
        Entity entity = this.getEntity();
        if (entity == null || entity.m_9236_().m_5776_()) {
            return;
        }
        this.setStackClean();
        PacketHandler.INSTANCE.sendToAllTracking((Object)new MountedStorageUpdateMessage(entity.m_19879_(), this.localPos, this.getStorageStack(), false), entity);
    }

    public void setBlockRenderDirty() {
        AbstractContraptionEntity cEntity;
        StructureTemplate.StructureBlockInfo blockInfo;
        Entity entity = this.getEntity();
        if (entity instanceof AbstractContraptionEntity && (blockInfo = (StructureTemplate.StructureBlockInfo)(cEntity = (AbstractContraptionEntity)entity).getContraption().getBlocks().get(this.localPos)) != null && blockInfo.f_74676_().m_60734_() instanceof BackpackBlock) {
            BlockState state = blockInfo.f_74676_();
            state = (BlockState)state.m_61124_((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(false));
            state = (BlockState)state.m_61124_((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(false));
            RenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
            for (TankPosition pos : renderInfo.getTankRenderInfos().keySet()) {
                if (pos == TankPosition.LEFT) {
                    state = (BlockState)state.m_61124_((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(true));
                    continue;
                }
                if (pos != TankPosition.RIGHT) continue;
                state = (BlockState)state.m_61124_((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(true));
            }
            state = (BlockState)state.m_61124_((Property)BackpackBlock.BATTERY, (Comparable)Boolean.valueOf(renderInfo.getBatteryRenderInfo().isPresent()));
            cEntity.setBlock(this.localPos, new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), state, blockInfo.f_74677_()));
        }
    }

    public void clearNbt() {
        Entity entity;
        if (!this.clearedNbt && (entity = this.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)entity;
            abstractContraptionEntity.getContraption().getBlocks().computeIfPresent(this.localPos, (p, blockInfo) -> new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), blockInfo.f_74676_(), null));
            this.clearedNbt = true;
        }
    }

    protected IItemHandlerModifiable getExternalItemHandler() {
        return this.getStorageWrapper().getInventoryForInputOutput();
    }
}

