/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.brewing;

import com.blamejared.crafttweaker.api.action.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.mixin.common.access.brewing.AccessPotionBrewing;
import com.blamejared.crafttweaker.natives.item.alchemy.ExpandPotion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class ActionRemovePotionBrewingRecipe
extends ActionBrewingBase {
    private final List<PotionBrewing.Mix<Potion>> removed = new ArrayList<PotionBrewing.Mix<Potion>>();
    private final Potion input;
    private final Potion output;
    private final IItemStack reagentStack;

    public ActionRemovePotionBrewingRecipe(List<IBrewingRecipe> recipes, Potion output, IItemStack reagentStack, Potion input) {
        super(recipes);
        this.output = output;
        this.input = input;
        this.reagentStack = reagentStack;
    }

    @Override
    public void apply() {
        Iterator<PotionBrewing.Mix<Potion>> vanillaIterator = AccessPotionBrewing.crafttweaker$getPOTION_MIXES().iterator();
        while (vanillaIterator.hasNext()) {
            PotionBrewing.Mix<Potion> mix = vanillaIterator.next();
            Holder.Reference potionInput = mix.f_43532_;
            Holder.Reference potionOutput = mix.f_43534_;
            Ingredient reagent = mix.f_43533_;
            if (potionInput == null || potionOutput == null || reagent == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (potionInput.get() != this.input || potionOutput.get() != this.output || !reagent.test(this.reagentStack.getInternal())) continue;
            this.removed.add(mix);
            vanillaIterator.remove();
        }
    }

    @Override
    public void undo() {
        for (PotionBrewing.Mix<Potion> potion : this.removed) {
            Holder.Reference potionInput = potion.f_43532_;
            Ingredient itemReagent = potion.f_43533_;
            Holder.Reference potionOutput = potion.f_43534_;
            AccessPotionBrewing.crafttweaker$callAddMix((Potion)potionInput.get(), itemReagent.m_43908_()[0].m_41720_(), (Potion)potionOutput.get());
        }
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input) + ", output of: " + ExpandPotion.getCommandString(this.output) + " and a reagent of: " + this.reagentStack;
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input) + ", output of: " + ExpandPotion.getCommandString(this.output) + " and a reagent of: " + this.reagentStack;
    }
}

